# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from . import core
from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.http_response import AsyncHttpResponse, HttpResponse
from .core.request_options import RequestOptions
from .core.unchecked_base_model import construct_type
from .errors.bad_request_error import BadRequestError
from .errors.too_many_requests_error import TooManyRequestsError
from .errors.unauthorized_error import UnauthorizedError
from .types.extract_async_request_experimental_schema import ExtractAsyncRequestExperimentalSchema
from .types.extract_async_request_schema import ExtractAsyncRequestSchema
from .types.extract_async_request_storage import ExtractAsyncRequestStorage
from .types.extract_async_request_structured_output import ExtractAsyncRequestStructuredOutput
from .types.extract_async_response import ExtractAsyncResponse
from .types.extract_request_experimental_schema import ExtractRequestExperimentalSchema
from .types.extract_request_schema import ExtractRequestSchema
from .types.extract_request_storage import ExtractRequestStorage
from .types.extract_request_structured_output import ExtractRequestStructuredOutput
from .types.extract_response import ExtractResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawPulse:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def extract(
        self,
        *,
        file: typing.Optional[core.File] = OMIT,
        file_url: typing.Optional[str] = OMIT,
        structured_output: typing.Optional[ExtractRequestStructuredOutput] = OMIT,
        schema: typing.Optional[ExtractRequestSchema] = OMIT,
        experimental_schema: typing.Optional[ExtractRequestExperimentalSchema] = OMIT,
        schema_prompt: typing.Optional[str] = OMIT,
        custom_prompt: typing.Optional[str] = OMIT,
        chunking: typing.Optional[str] = OMIT,
        chunk_size: typing.Optional[int] = OMIT,
        pages: typing.Optional[str] = OMIT,
        extract_figure: typing.Optional[bool] = OMIT,
        figure_description: typing.Optional[bool] = OMIT,
        return_html: typing.Optional[bool] = OMIT,
        thinking: typing.Optional[bool] = OMIT,
        storage: typing.Optional[ExtractRequestStorage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ExtractResponse]:
        """
        The primary endpoint for the Pulse API. Parses uploaded documents or remote
        file URLs and returns rich markdown content with optional structured data
        extraction based on user-provided schemas and extraction options.

        Parameters
        ----------
        file : typing.Optional[core.File]
            See core.File for more documentation

        file_url : typing.Optional[str]
            Public or pre-signed URL that Pulse will download and extract. Required unless file is provided.

        structured_output : typing.Optional[ExtractRequestStructuredOutput]
            Recommended method for schema-guided extraction. Contains the schema and optional prompt in a single object.

        schema : typing.Optional[ExtractRequestSchema]
            (Deprecated) JSON schema describing structured data to extract. Use structuredOutput instead. Accepts either a JSON object or a stringified JSON representation.

        experimental_schema : typing.Optional[ExtractRequestExperimentalSchema]
            (Deprecated) Experimental schema definition used for feature flagged behaviour. Accepts either a JSON object or a stringified JSON representation.

        schema_prompt : typing.Optional[str]
            (Deprecated) Natural language prompt for schema-guided extraction. Use structuredOutput.schemaPrompt instead.

        custom_prompt : typing.Optional[str]
            (Deprecated) Custom instructions that augment the default extraction behaviour.

        chunking : typing.Optional[str]
            Comma-separated list of chunking strategies to apply (for example `semantic,header,page,recursive`).

        chunk_size : typing.Optional[int]
            Override for maximum characters per chunk when chunking is enabled.

        pages : typing.Optional[str]
            Page range filter supporting segments such as `1-2` or mixed ranges like `1-2,5`.

        extract_figure : typing.Optional[bool]
            Toggle to enable figure extraction in results.

        figure_description : typing.Optional[bool]
            Toggle to generate descriptive captions for extracted figures.

        return_html : typing.Optional[bool]
            Whether to include HTML representation alongside markdown in the response.

        thinking : typing.Optional[bool]
            (Deprecated) Enables expanded rationale output for debugging.

        storage : typing.Optional[ExtractRequestStorage]
            Options for persisting extraction artifacts. When enabled (default), artifacts are saved to storage and a database record is created.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExtractResponse]
            Synchronous extraction result
        """
        _response = self._client_wrapper.httpx_client.request(
            "extract",
            method="POST",
            data={
                "fileUrl": file_url,
                "structuredOutput": structured_output,
                "schema": schema,
                "experimentalSchema": experimental_schema,
                "schemaPrompt": schema_prompt,
                "customPrompt": custom_prompt,
                "chunking": chunking,
                "chunkSize": chunk_size,
                "pages": pages,
                "extractFigure": extract_figure,
                "figureDescription": figure_description,
                "returnHtml": return_html,
                "thinking": thinking,
                "storage": storage,
            },
            files={
                **({"file": file} if file is not None else {}),
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExtractResponse,
                    construct_type(
                        type_=ExtractResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def extract_async(
        self,
        *,
        file: typing.Optional[core.File] = OMIT,
        file_url: typing.Optional[str] = OMIT,
        structured_output: typing.Optional[ExtractAsyncRequestStructuredOutput] = OMIT,
        schema: typing.Optional[ExtractAsyncRequestSchema] = OMIT,
        experimental_schema: typing.Optional[ExtractAsyncRequestExperimentalSchema] = OMIT,
        schema_prompt: typing.Optional[str] = OMIT,
        custom_prompt: typing.Optional[str] = OMIT,
        chunking: typing.Optional[str] = OMIT,
        chunk_size: typing.Optional[int] = OMIT,
        pages: typing.Optional[str] = OMIT,
        extract_figure: typing.Optional[bool] = OMIT,
        figure_description: typing.Optional[bool] = OMIT,
        return_html: typing.Optional[bool] = OMIT,
        thinking: typing.Optional[bool] = OMIT,
        storage: typing.Optional[ExtractAsyncRequestStorage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ExtractAsyncResponse]:
        """
        Starts an asynchronous extraction job. The request mirrors the
        synchronous options but returns immediately with a job identifier that
        clients can poll for completion status.

        Parameters
        ----------
        file : typing.Optional[core.File]
            See core.File for more documentation

        file_url : typing.Optional[str]
            Public or pre-signed URL that Pulse will download and extract. Required unless file is provided.

        structured_output : typing.Optional[ExtractAsyncRequestStructuredOutput]
            Recommended method for schema-guided extraction. Contains the schema and optional prompt in a single object.

        schema : typing.Optional[ExtractAsyncRequestSchema]
            (Deprecated) JSON schema describing structured data to extract. Use structuredOutput instead. Accepts either a JSON object or a stringified JSON representation.

        experimental_schema : typing.Optional[ExtractAsyncRequestExperimentalSchema]
            (Deprecated) Experimental schema definition used for feature flagged behaviour. Accepts either a JSON object or a stringified JSON representation.

        schema_prompt : typing.Optional[str]
            (Deprecated) Natural language prompt for schema-guided extraction. Use structuredOutput.schemaPrompt instead.

        custom_prompt : typing.Optional[str]
            (Deprecated) Custom instructions that augment the default extraction behaviour.

        chunking : typing.Optional[str]
            Comma-separated list of chunking strategies to apply (for example `semantic,header,page,recursive`).

        chunk_size : typing.Optional[int]
            Override for maximum characters per chunk when chunking is enabled.

        pages : typing.Optional[str]
            Page range filter supporting segments such as `1-2` or mixed ranges like `1-2,5`.

        extract_figure : typing.Optional[bool]
            Toggle to enable figure extraction in results.

        figure_description : typing.Optional[bool]
            Toggle to generate descriptive captions for extracted figures.

        return_html : typing.Optional[bool]
            Whether to include HTML representation alongside markdown in the response.

        thinking : typing.Optional[bool]
            (Deprecated) Enables expanded rationale output for debugging.

        storage : typing.Optional[ExtractAsyncRequestStorage]
            Options for persisting extraction artifacts. When enabled (default), artifacts are saved to storage and a database record is created.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExtractAsyncResponse]
            Asynchronous extraction job accepted
        """
        _response = self._client_wrapper.httpx_client.request(
            "extract_async",
            method="POST",
            data={
                "fileUrl": file_url,
                "structuredOutput": structured_output,
                "schema": schema,
                "experimentalSchema": experimental_schema,
                "schemaPrompt": schema_prompt,
                "customPrompt": custom_prompt,
                "chunking": chunking,
                "chunkSize": chunk_size,
                "pages": pages,
                "extractFigure": extract_figure,
                "figureDescription": figure_description,
                "returnHtml": return_html,
                "thinking": thinking,
                "storage": storage,
            },
            files={
                **({"file": file} if file is not None else {}),
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExtractAsyncResponse,
                    construct_type(
                        type_=ExtractAsyncResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawPulse:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def extract(
        self,
        *,
        file: typing.Optional[core.File] = OMIT,
        file_url: typing.Optional[str] = OMIT,
        structured_output: typing.Optional[ExtractRequestStructuredOutput] = OMIT,
        schema: typing.Optional[ExtractRequestSchema] = OMIT,
        experimental_schema: typing.Optional[ExtractRequestExperimentalSchema] = OMIT,
        schema_prompt: typing.Optional[str] = OMIT,
        custom_prompt: typing.Optional[str] = OMIT,
        chunking: typing.Optional[str] = OMIT,
        chunk_size: typing.Optional[int] = OMIT,
        pages: typing.Optional[str] = OMIT,
        extract_figure: typing.Optional[bool] = OMIT,
        figure_description: typing.Optional[bool] = OMIT,
        return_html: typing.Optional[bool] = OMIT,
        thinking: typing.Optional[bool] = OMIT,
        storage: typing.Optional[ExtractRequestStorage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ExtractResponse]:
        """
        The primary endpoint for the Pulse API. Parses uploaded documents or remote
        file URLs and returns rich markdown content with optional structured data
        extraction based on user-provided schemas and extraction options.

        Parameters
        ----------
        file : typing.Optional[core.File]
            See core.File for more documentation

        file_url : typing.Optional[str]
            Public or pre-signed URL that Pulse will download and extract. Required unless file is provided.

        structured_output : typing.Optional[ExtractRequestStructuredOutput]
            Recommended method for schema-guided extraction. Contains the schema and optional prompt in a single object.

        schema : typing.Optional[ExtractRequestSchema]
            (Deprecated) JSON schema describing structured data to extract. Use structuredOutput instead. Accepts either a JSON object or a stringified JSON representation.

        experimental_schema : typing.Optional[ExtractRequestExperimentalSchema]
            (Deprecated) Experimental schema definition used for feature flagged behaviour. Accepts either a JSON object or a stringified JSON representation.

        schema_prompt : typing.Optional[str]
            (Deprecated) Natural language prompt for schema-guided extraction. Use structuredOutput.schemaPrompt instead.

        custom_prompt : typing.Optional[str]
            (Deprecated) Custom instructions that augment the default extraction behaviour.

        chunking : typing.Optional[str]
            Comma-separated list of chunking strategies to apply (for example `semantic,header,page,recursive`).

        chunk_size : typing.Optional[int]
            Override for maximum characters per chunk when chunking is enabled.

        pages : typing.Optional[str]
            Page range filter supporting segments such as `1-2` or mixed ranges like `1-2,5`.

        extract_figure : typing.Optional[bool]
            Toggle to enable figure extraction in results.

        figure_description : typing.Optional[bool]
            Toggle to generate descriptive captions for extracted figures.

        return_html : typing.Optional[bool]
            Whether to include HTML representation alongside markdown in the response.

        thinking : typing.Optional[bool]
            (Deprecated) Enables expanded rationale output for debugging.

        storage : typing.Optional[ExtractRequestStorage]
            Options for persisting extraction artifacts. When enabled (default), artifacts are saved to storage and a database record is created.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExtractResponse]
            Synchronous extraction result
        """
        _response = await self._client_wrapper.httpx_client.request(
            "extract",
            method="POST",
            data={
                "fileUrl": file_url,
                "structuredOutput": structured_output,
                "schema": schema,
                "experimentalSchema": experimental_schema,
                "schemaPrompt": schema_prompt,
                "customPrompt": custom_prompt,
                "chunking": chunking,
                "chunkSize": chunk_size,
                "pages": pages,
                "extractFigure": extract_figure,
                "figureDescription": figure_description,
                "returnHtml": return_html,
                "thinking": thinking,
                "storage": storage,
            },
            files={
                **({"file": file} if file is not None else {}),
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExtractResponse,
                    construct_type(
                        type_=ExtractResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def extract_async(
        self,
        *,
        file: typing.Optional[core.File] = OMIT,
        file_url: typing.Optional[str] = OMIT,
        structured_output: typing.Optional[ExtractAsyncRequestStructuredOutput] = OMIT,
        schema: typing.Optional[ExtractAsyncRequestSchema] = OMIT,
        experimental_schema: typing.Optional[ExtractAsyncRequestExperimentalSchema] = OMIT,
        schema_prompt: typing.Optional[str] = OMIT,
        custom_prompt: typing.Optional[str] = OMIT,
        chunking: typing.Optional[str] = OMIT,
        chunk_size: typing.Optional[int] = OMIT,
        pages: typing.Optional[str] = OMIT,
        extract_figure: typing.Optional[bool] = OMIT,
        figure_description: typing.Optional[bool] = OMIT,
        return_html: typing.Optional[bool] = OMIT,
        thinking: typing.Optional[bool] = OMIT,
        storage: typing.Optional[ExtractAsyncRequestStorage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ExtractAsyncResponse]:
        """
        Starts an asynchronous extraction job. The request mirrors the
        synchronous options but returns immediately with a job identifier that
        clients can poll for completion status.

        Parameters
        ----------
        file : typing.Optional[core.File]
            See core.File for more documentation

        file_url : typing.Optional[str]
            Public or pre-signed URL that Pulse will download and extract. Required unless file is provided.

        structured_output : typing.Optional[ExtractAsyncRequestStructuredOutput]
            Recommended method for schema-guided extraction. Contains the schema and optional prompt in a single object.

        schema : typing.Optional[ExtractAsyncRequestSchema]
            (Deprecated) JSON schema describing structured data to extract. Use structuredOutput instead. Accepts either a JSON object or a stringified JSON representation.

        experimental_schema : typing.Optional[ExtractAsyncRequestExperimentalSchema]
            (Deprecated) Experimental schema definition used for feature flagged behaviour. Accepts either a JSON object or a stringified JSON representation.

        schema_prompt : typing.Optional[str]
            (Deprecated) Natural language prompt for schema-guided extraction. Use structuredOutput.schemaPrompt instead.

        custom_prompt : typing.Optional[str]
            (Deprecated) Custom instructions that augment the default extraction behaviour.

        chunking : typing.Optional[str]
            Comma-separated list of chunking strategies to apply (for example `semantic,header,page,recursive`).

        chunk_size : typing.Optional[int]
            Override for maximum characters per chunk when chunking is enabled.

        pages : typing.Optional[str]
            Page range filter supporting segments such as `1-2` or mixed ranges like `1-2,5`.

        extract_figure : typing.Optional[bool]
            Toggle to enable figure extraction in results.

        figure_description : typing.Optional[bool]
            Toggle to generate descriptive captions for extracted figures.

        return_html : typing.Optional[bool]
            Whether to include HTML representation alongside markdown in the response.

        thinking : typing.Optional[bool]
            (Deprecated) Enables expanded rationale output for debugging.

        storage : typing.Optional[ExtractAsyncRequestStorage]
            Options for persisting extraction artifacts. When enabled (default), artifacts are saved to storage and a database record is created.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExtractAsyncResponse]
            Asynchronous extraction job accepted
        """
        _response = await self._client_wrapper.httpx_client.request(
            "extract_async",
            method="POST",
            data={
                "fileUrl": file_url,
                "structuredOutput": structured_output,
                "schema": schema,
                "experimentalSchema": experimental_schema,
                "schemaPrompt": schema_prompt,
                "customPrompt": custom_prompt,
                "chunking": chunking,
                "chunkSize": chunk_size,
                "pages": pages,
                "extractFigure": extract_figure,
                "figureDescription": figure_description,
                "returnHtml": return_html,
                "thinking": thinking,
                "storage": storage,
            },
            files={
                **({"file": file} if file is not None else {}),
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExtractAsyncResponse,
                    construct_type(
                        type_=ExtractAsyncResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
