# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .extract_input_experimental_schema import ExtractInputExperimentalSchema
from .extract_input_schema import ExtractInputSchema
from .extract_input_storage import ExtractInputStorage
from .extract_input_structured_output import ExtractInputStructuredOutput


class ExtractInput(UncheckedBaseModel):
    """
    Input schema for extraction requests. Provide either file (direct upload) or fileUrl (remote URL).
    """

    file: typing.Optional[str] = pydantic.Field(default=None)
    """
    Document to upload directly. Required unless fileUrl is provided.
    """

    file_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="fileUrl")] = pydantic.Field(
        default=None
    )
    """
    Public or pre-signed URL that Pulse will download and extract. Required unless file is provided.
    """

    structured_output: typing_extensions.Annotated[
        typing.Optional[ExtractInputStructuredOutput], FieldMetadata(alias="structuredOutput")
    ] = pydantic.Field(default=None)
    """
    Recommended method for schema-guided extraction. Contains the schema and optional prompt in a single object.
    """

    schema_: typing_extensions.Annotated[typing.Optional[ExtractInputSchema], FieldMetadata(alias="schema")] = (
        pydantic.Field(default=None)
    )
    """
    (Deprecated) JSON schema describing structured data to extract. Use structuredOutput instead. Accepts either a JSON object or a stringified JSON representation.
    """

    experimental_schema: typing_extensions.Annotated[
        typing.Optional[ExtractInputExperimentalSchema], FieldMetadata(alias="experimentalSchema")
    ] = pydantic.Field(default=None)
    """
    (Deprecated) Experimental schema definition used for feature flagged behaviour. Accepts either a JSON object or a stringified JSON representation.
    """

    schema_prompt: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="schemaPrompt")] = (
        pydantic.Field(default=None)
    )
    """
    (Deprecated) Natural language prompt for schema-guided extraction. Use structuredOutput.schemaPrompt instead.
    """

    custom_prompt: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="customPrompt")] = (
        pydantic.Field(default=None)
    )
    """
    (Deprecated) Custom instructions that augment the default extraction behaviour.
    """

    chunking: typing.Optional[str] = pydantic.Field(default=None)
    """
    Comma-separated list of chunking strategies to apply (for example `semantic,header,page,recursive`).
    """

    chunk_size: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="chunkSize")] = pydantic.Field(
        default=None
    )
    """
    Override for maximum characters per chunk when chunking is enabled.
    """

    pages: typing.Optional[str] = pydantic.Field(default=None)
    """
    Page range filter supporting segments such as `1-2` or mixed ranges like `1-2,5`.
    """

    extract_figure: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="extractFigure")] = (
        pydantic.Field(default=None)
    )
    """
    Toggle to enable figure extraction in results.
    """

    figure_description: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="figureDescription")] = (
        pydantic.Field(default=None)
    )
    """
    Toggle to generate descriptive captions for extracted figures.
    """

    return_html: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="returnHtml")] = pydantic.Field(
        default=None
    )
    """
    Whether to include HTML representation alongside markdown in the response.
    """

    thinking: typing.Optional[bool] = pydantic.Field(default=None)
    """
    (Deprecated) Enables expanded rationale output for debugging.
    """

    storage: typing.Optional[ExtractInputStorage] = pydantic.Field(default=None)
    """
    Options for persisting extraction artifacts. When enabled (default), artifacts are saved to storage and a database record is created.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
