# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel


class ExtractOptionsStorage(UncheckedBaseModel):
    """
    Options for persisting extraction artifacts. When enabled (default), artifacts are saved to storage and a database record is created.
    """

    enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to persist extraction artifacts. Set to false for temporary extractions with no storage or database record.
    """

    folder_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="folderName")] = pydantic.Field(
        default=None
    )
    """
    Target folder name to save the extraction to. Creates the folder if it doesn't exist.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
