# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .job_status import JobStatus


class JobStatusResponse(UncheckedBaseModel):
    """
    Current status and metadata for an asynchronous extraction job.
    """

    job_id: str = pydantic.Field()
    """
    Identifier assigned to the asynchronous extraction job.
    """

    status: JobStatus
    created_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the job was accepted.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp of the last status update, if available.
    """

    result: typing.Optional[typing.Dict[str, typing.Any]] = pydantic.Field(default=None)
    """
    Structured payload that contains extraction output when the job is completed.
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error message describing why the job failed, if applicable.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
