# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...errors.bad_request_error import BadRequestError
from ...errors.internal_server_error import InternalServerError
from .types.list_response_item import ListResponseItem
from .types.usage_response import UsageResponse

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RulesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def solve(self, slug: str, *, request: typing.Dict[str, typing.Any]) -> typing.Dict[str, typing.Any]:
        """
        Executes a single rule identified by a unique slug. The request and response formats are dynamic, dependent on the rule configuration.

        Parameters:
            - slug: str. The unique identifier for the rule.

            - request: typing.Dict[str, typing.Any].
        ---
        import rulebricks as rb

        # Set the API key
        rb.set_api_key("XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX")

        rb.rules.solve(
            slug="slug",
            request={"name": "John Doe", "age": 30, "email": "jdoe@acme.co"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/solve/{slug}"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Dict[str, typing.Any], _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def bulk_solve(
        self, slug: str, *, request: typing.List[typing.Dict[str, typing.Any]]
    ) -> typing.List[typing.Dict[str, typing.Any]]:
        """
        Executes a particular rule against multiple request data payloads provided in a list.

        Parameters:
            - slug: str. The unique identifier of the rule to execute against all payloads.

            - request: typing.List[typing.Dict[str, typing.Any]].
        ---
        import rulebricks as rb

        # Set the API key
        rb.set_api_key("XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX")

        rb.rules.bulk_solve(
            slug="slug",
            request=[
                {"name": "John Doe", "age": 30, "email": "jdoe@acme.co"},
                {"name": "Jane Doe", "age": 28, "email": "jane@example.com"},
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/bulk-solve/{slug}"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[typing.Dict[str, typing.Any]], _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def parallel_solve(self, *, request: typing.Dict[str, typing.Any]) -> typing.Dict[str, typing.Any]:
        """
        Executes multiple rules in parallel based on a provided mapping of rule slugs to payloads.

        Parameters:
            - request: typing.Dict[str, typing.Any].
        ---
        import rulebricks as rb

        # Set the API key
        rb.set_api_key("XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX")

        rb.rules.parallel_solve(
            request={
                "eligibility": {
                    "rule": "1ef03ms",
                    "name": "John Doe",
                    "age": 30,
                    "email": "jdoe@acme.co",
                },
                "offers": {
                    "rule": "OvmsYwn",
                    "customer_id": "12345",
                    "last_purchase_days_ago": 30,
                    "selected_plan": "premium",
                },
            },
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/parallel-solve"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Dict[str, typing.Any], _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list(self) -> typing.List[ListResponseItem]:
        """
        List all rules in the organization.

        ---
        import rulebricks as rb

        # Set the API key
        rb.set_api_key("XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX")

        rb.rules.list()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/list"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[ListResponseItem], _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def usage(self) -> UsageResponse:
        """
        Get the rule execution usage of your organization.

        ---
        import rulebricks as rb

        # Set the API key
        rb.set_api_key("XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX")

        rb.rules.usage()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/usage"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UsageResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncRulesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def solve(self, slug: str, *, request: typing.Dict[str, typing.Any]) -> typing.Dict[str, typing.Any]:
        """
        Executes a single rule identified by a unique slug. The request and response formats are dynamic, dependent on the rule configuration.

        Parameters:
            - slug: str. The unique identifier for the rule.

            - request: typing.Dict[str, typing.Any].
        ---
        import rulebricks as rb

        # Set the API key
        rb.set_api_key("XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX")

        await rb.async_api.rules.solve(
            slug="slug",
            request={"name": "John Doe", "age": 30, "email": "jdoe@acme.co"},
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/solve/{slug}"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Dict[str, typing.Any], _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def bulk_solve(
        self, slug: str, *, request: typing.List[typing.Dict[str, typing.Any]]
    ) -> typing.List[typing.Dict[str, typing.Any]]:
        """
        Executes a particular rule against multiple request data payloads provided in a list.

        Parameters:
            - slug: str. The unique identifier of the rule to execute against all payloads.

            - request: typing.List[typing.Dict[str, typing.Any]].
        ---
        import rulebricks as rb

        # Set the API key
        rb.set_api_key("XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX")

        await rb.async_api.rules.bulk_solve(
            slug="slug",
            request=[
                {"name": "John Doe", "age": 30, "email": "jdoe@acme.co"},
                {"name": "Jane Doe", "age": 28, "email": "jane@example.com"},
            ],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/bulk-solve/{slug}"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[typing.Dict[str, typing.Any]], _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def parallel_solve(self, *, request: typing.Dict[str, typing.Any]) -> typing.Dict[str, typing.Any]:
        """
        Executes multiple rules in parallel based on a provided mapping of rule slugs to payloads.

        Parameters:
            - request: typing.Dict[str, typing.Any].
        ---
        import rulebricks as rb

        # Set the API key
        rb.set_api_key("XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX")

        await rb.async_api.rules.parallel_solve(
            request={
                "eligibility": {
                    "rule": "1ef03ms",
                    "name": "John Doe",
                    "age": 30,
                    "email": "jdoe@acme.co",
                },
                "offers": {
                    "rule": "OvmsYwn",
                    "customer_id": "12345",
                    "last_purchase_days_ago": 30,
                    "selected_plan": "premium",
                },
            },
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/parallel-solve"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Dict[str, typing.Any], _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list(self) -> typing.List[ListResponseItem]:
        """
        List all rules in the organization.

        ---
        import rulebricks as rb

        # Set the API key
        rb.set_api_key("XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX")

        await rb.async_api.rules.list()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/list"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[ListResponseItem], _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def usage(self) -> UsageResponse:
        """
        Get the rule execution usage of your organization.

        ---
        import rulebricks as rb

        # Set the API key
        rb.set_api_key("XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX")

        await rb.async_api.rules.usage()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/usage"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UsageResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
