# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ListResponseItemRequestSchemaItem(pydantic.BaseModel):
    key: typing.Optional[str] = pydantic.Field(description="The key for the request field.")
    show: typing.Optional[bool] = pydantic.Field(description="Whether the field is visible in the rule editor.")
    name: typing.Optional[str] = pydantic.Field(description="The name of the request field.")
    description: typing.Optional[str] = pydantic.Field(description="The description of the request field.")
    type: typing.Optional[str] = pydantic.Field(description="The data type of the request field.")
    default_value: typing.Optional[str] = pydantic.Field(
        alias="defaultValue", description="The default value of the request field."
    )
    default_computed_value: typing.Optional[str] = pydantic.Field(
        alias="defaultComputedValue", description="The computed default value of the request field."
    )
    transform: typing.Optional[str] = pydantic.Field(description="The transformation applied to the request field.")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
