# coding: utf-8

"""
    Gradient AI API

    Interface for interacting with Gradient AI.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@gradient.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import StrictBytes, StrictStr, constr

from typing import Union

from gradientai.openapi.client.models.analyze_sentiment_body_params import AnalyzeSentimentBodyParams
from gradientai.openapi.client.models.analyze_sentiment_success import AnalyzeSentimentSuccess
from gradientai.openapi.client.models.create_audio_transcription_body_params import CreateAudioTranscriptionBodyParams
from gradientai.openapi.client.models.create_audio_transcription_success import CreateAudioTranscriptionSuccess
from gradientai.openapi.client.models.extract_entity_body_params import ExtractEntityBodyParams
from gradientai.openapi.client.models.extract_entity_success import ExtractEntitySuccess
from gradientai.openapi.client.models.extract_pdf_success import ExtractPdfSuccess
from gradientai.openapi.client.models.generate_answer_body_params import GenerateAnswerBodyParams
from gradientai.openapi.client.models.generate_answer_success import GenerateAnswerSuccess
from gradientai.openapi.client.models.get_audio_transcription_success import GetAudioTranscriptionSuccess
from gradientai.openapi.client.models.personalize_document_body_params import PersonalizeDocumentBodyParams
from gradientai.openapi.client.models.personalize_document_success import PersonalizeDocumentSuccess
from gradientai.openapi.client.models.summarize_document_body_params import SummarizeDocumentBodyParams
from gradientai.openapi.client.models.summarize_document_success import SummarizeDocumentSuccess

from gradientai.openapi.client.api_client import ApiClient
from gradientai.openapi.client.api_response import ApiResponse
from gradientai.openapi.client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class BlocksApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def analyze_sentiment(self, x_gradient_workspace_id : constr(strict=True, min_length=1), analyze_sentiment_body_params : AnalyzeSentimentBodyParams, **kwargs) -> AnalyzeSentimentSuccess:  # noqa: E501
        """Sentiment analysis  # noqa: E501

        Analyzes text to determine the emotional tone of the message.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.analyze_sentiment(x_gradient_workspace_id, analyze_sentiment_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param analyze_sentiment_body_params: (required)
        :type analyze_sentiment_body_params: AnalyzeSentimentBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AnalyzeSentimentSuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the analyze_sentiment_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.analyze_sentiment_with_http_info(x_gradient_workspace_id, analyze_sentiment_body_params, **kwargs)  # noqa: E501

    @validate_arguments
    def analyze_sentiment_with_http_info(self, x_gradient_workspace_id : constr(strict=True, min_length=1), analyze_sentiment_body_params : AnalyzeSentimentBodyParams, **kwargs) -> ApiResponse:  # noqa: E501
        """Sentiment analysis  # noqa: E501

        Analyzes text to determine the emotional tone of the message.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.analyze_sentiment_with_http_info(x_gradient_workspace_id, analyze_sentiment_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param analyze_sentiment_body_params: (required)
        :type analyze_sentiment_body_params: AnalyzeSentimentBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AnalyzeSentimentSuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_gradient_workspace_id',
            'analyze_sentiment_body_params'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method analyze_sentiment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['analyze_sentiment_body_params'] is not None:
            _body_params = _params['analyze_sentiment_body_params']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "AnalyzeSentimentSuccess",
            '4XX': "AnalyzeSentimentError",
        }

        return self.api_client.call_api(
            '/blocks/analyze-sentiment', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_audio_transcription(self, x_gradient_workspace_id : constr(strict=True, min_length=1), create_audio_transcription_body_params : CreateAudioTranscriptionBodyParams, **kwargs) -> CreateAudioTranscriptionSuccess:  # noqa: E501
        """Create audio transcription  # noqa: E501

        Creates an audio transcription job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_audio_transcription(x_gradient_workspace_id, create_audio_transcription_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param create_audio_transcription_body_params: (required)
        :type create_audio_transcription_body_params: CreateAudioTranscriptionBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateAudioTranscriptionSuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_audio_transcription_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_audio_transcription_with_http_info(x_gradient_workspace_id, create_audio_transcription_body_params, **kwargs)  # noqa: E501

    @validate_arguments
    def create_audio_transcription_with_http_info(self, x_gradient_workspace_id : constr(strict=True, min_length=1), create_audio_transcription_body_params : CreateAudioTranscriptionBodyParams, **kwargs) -> ApiResponse:  # noqa: E501
        """Create audio transcription  # noqa: E501

        Creates an audio transcription job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_audio_transcription_with_http_info(x_gradient_workspace_id, create_audio_transcription_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param create_audio_transcription_body_params: (required)
        :type create_audio_transcription_body_params: CreateAudioTranscriptionBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateAudioTranscriptionSuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_gradient_workspace_id',
            'create_audio_transcription_body_params'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_audio_transcription" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_audio_transcription_body_params'] is not None:
            _body_params = _params['create_audio_transcription_body_params']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "CreateAudioTranscriptionSuccess",
            '4XX': "CreateAudioTranscriptionError",
        }

        return self.api_client.call_api(
            '/blocks/transcription', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def extract_entity(self, x_gradient_workspace_id : constr(strict=True, min_length=1), extract_entity_body_params : ExtractEntityBodyParams, **kwargs) -> ExtractEntitySuccess:  # noqa: E501
        """Entity extraction  # noqa: E501

        Extracts an entity from the document with the specified fields and types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.extract_entity(x_gradient_workspace_id, extract_entity_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param extract_entity_body_params: (required)
        :type extract_entity_body_params: ExtractEntityBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ExtractEntitySuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the extract_entity_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.extract_entity_with_http_info(x_gradient_workspace_id, extract_entity_body_params, **kwargs)  # noqa: E501

    @validate_arguments
    def extract_entity_with_http_info(self, x_gradient_workspace_id : constr(strict=True, min_length=1), extract_entity_body_params : ExtractEntityBodyParams, **kwargs) -> ApiResponse:  # noqa: E501
        """Entity extraction  # noqa: E501

        Extracts an entity from the document with the specified fields and types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.extract_entity_with_http_info(x_gradient_workspace_id, extract_entity_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param extract_entity_body_params: (required)
        :type extract_entity_body_params: ExtractEntityBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ExtractEntitySuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_gradient_workspace_id',
            'extract_entity_body_params'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method extract_entity" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['extract_entity_body_params'] is not None:
            _body_params = _params['extract_entity_body_params']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "ExtractEntitySuccess",
            '4XX': "ExtractEntityError",
        }

        return self.api_client.call_api(
            '/blocks/extract', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def extract_pdf(self, x_gradient_workspace_id : constr(strict=True, min_length=1), file : Union[StrictBytes, StrictStr], **kwargs) -> ExtractPdfSuccess:  # noqa: E501
        """PDF extraction  # noqa: E501

        Extracts content from the PDF.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.extract_pdf(x_gradient_workspace_id, file, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param file: (required)
        :type file: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ExtractPdfSuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the extract_pdf_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.extract_pdf_with_http_info(x_gradient_workspace_id, file, **kwargs)  # noqa: E501

    @validate_arguments
    def extract_pdf_with_http_info(self, x_gradient_workspace_id : constr(strict=True, min_length=1), file : Union[StrictBytes, StrictStr], **kwargs) -> ApiResponse:  # noqa: E501
        """PDF extraction  # noqa: E501

        Extracts content from the PDF.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.extract_pdf_with_http_info(x_gradient_workspace_id, file, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param file: (required)
        :type file: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ExtractPdfSuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_gradient_workspace_id',
            'file'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method extract_pdf" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['file']:
            _files['file'] = _params['file']

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "ExtractPdfSuccess",
            '4XX': "ExtractPdfError",
        }

        return self.api_client.call_api(
            '/blocks/extract-pdf', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def generate_answer(self, x_gradient_workspace_id : constr(strict=True, min_length=1), generate_answer_body_params : GenerateAnswerBodyParams, **kwargs) -> GenerateAnswerSuccess:  # noqa: E501
        """Document question & answer  # noqa: E501

        Answers questions using the provided context.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_answer(x_gradient_workspace_id, generate_answer_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param generate_answer_body_params: (required)
        :type generate_answer_body_params: GenerateAnswerBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenerateAnswerSuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the generate_answer_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.generate_answer_with_http_info(x_gradient_workspace_id, generate_answer_body_params, **kwargs)  # noqa: E501

    @validate_arguments
    def generate_answer_with_http_info(self, x_gradient_workspace_id : constr(strict=True, min_length=1), generate_answer_body_params : GenerateAnswerBodyParams, **kwargs) -> ApiResponse:  # noqa: E501
        """Document question & answer  # noqa: E501

        Answers questions using the provided context.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_answer_with_http_info(x_gradient_workspace_id, generate_answer_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param generate_answer_body_params: (required)
        :type generate_answer_body_params: GenerateAnswerBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenerateAnswerSuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_gradient_workspace_id',
            'generate_answer_body_params'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_answer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['generate_answer_body_params'] is not None:
            _body_params = _params['generate_answer_body_params']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "GenerateAnswerSuccess",
            '4XX': "GenerateAnswerError",
        }

        return self.api_client.call_api(
            '/blocks/answer', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_audio_transcription(self, transcription_id : constr(strict=True, min_length=1), x_gradient_workspace_id : constr(strict=True, min_length=1), **kwargs) -> GetAudioTranscriptionSuccess:  # noqa: E501
        """Get audio transcription  # noqa: E501

        Gets the result of the audio transcription job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_audio_transcription(transcription_id, x_gradient_workspace_id, async_req=True)
        >>> result = thread.get()

        :param transcription_id: (required)
        :type transcription_id: str
        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetAudioTranscriptionSuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_audio_transcription_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_audio_transcription_with_http_info(transcription_id, x_gradient_workspace_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_audio_transcription_with_http_info(self, transcription_id : constr(strict=True, min_length=1), x_gradient_workspace_id : constr(strict=True, min_length=1), **kwargs) -> ApiResponse:  # noqa: E501
        """Get audio transcription  # noqa: E501

        Gets the result of the audio transcription job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_audio_transcription_with_http_info(transcription_id, x_gradient_workspace_id, async_req=True)
        >>> result = thread.get()

        :param transcription_id: (required)
        :type transcription_id: str
        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetAudioTranscriptionSuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'transcription_id',
            'x_gradient_workspace_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audio_transcription" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('transcription_id') is not None:  # noqa: E501
            _query_params.append(('transcriptionId', _params['transcription_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "GetAudioTranscriptionSuccess",
            '4XX': "GetAudioTranscriptionError",
        }

        return self.api_client.call_api(
            '/blocks/transcription', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def personalize_document(self, x_gradient_workspace_id : constr(strict=True, min_length=1), personalize_document_body_params : PersonalizeDocumentBodyParams, **kwargs) -> PersonalizeDocumentSuccess:  # noqa: E501
        """Document personalization  # noqa: E501

        Personalizes the document in a tone and style specific to the described target audience.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.personalize_document(x_gradient_workspace_id, personalize_document_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param personalize_document_body_params: (required)
        :type personalize_document_body_params: PersonalizeDocumentBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PersonalizeDocumentSuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the personalize_document_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.personalize_document_with_http_info(x_gradient_workspace_id, personalize_document_body_params, **kwargs)  # noqa: E501

    @validate_arguments
    def personalize_document_with_http_info(self, x_gradient_workspace_id : constr(strict=True, min_length=1), personalize_document_body_params : PersonalizeDocumentBodyParams, **kwargs) -> ApiResponse:  # noqa: E501
        """Document personalization  # noqa: E501

        Personalizes the document in a tone and style specific to the described target audience.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.personalize_document_with_http_info(x_gradient_workspace_id, personalize_document_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param personalize_document_body_params: (required)
        :type personalize_document_body_params: PersonalizeDocumentBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PersonalizeDocumentSuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_gradient_workspace_id',
            'personalize_document_body_params'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method personalize_document" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['personalize_document_body_params'] is not None:
            _body_params = _params['personalize_document_body_params']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "PersonalizeDocumentSuccess",
            '4XX': "PersonalizeDocumentError",
        }

        return self.api_client.call_api(
            '/blocks/personalize', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def summarize_document(self, x_gradient_workspace_id : constr(strict=True, min_length=1), summarize_document_body_params : SummarizeDocumentBodyParams, **kwargs) -> SummarizeDocumentSuccess:  # noqa: E501
        """Document summary  # noqa: E501

        Generates a summary of the document using the provided guidance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.summarize_document(x_gradient_workspace_id, summarize_document_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param summarize_document_body_params: (required)
        :type summarize_document_body_params: SummarizeDocumentBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SummarizeDocumentSuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the summarize_document_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.summarize_document_with_http_info(x_gradient_workspace_id, summarize_document_body_params, **kwargs)  # noqa: E501

    @validate_arguments
    def summarize_document_with_http_info(self, x_gradient_workspace_id : constr(strict=True, min_length=1), summarize_document_body_params : SummarizeDocumentBodyParams, **kwargs) -> ApiResponse:  # noqa: E501
        """Document summary  # noqa: E501

        Generates a summary of the document using the provided guidance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.summarize_document_with_http_info(x_gradient_workspace_id, summarize_document_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param summarize_document_body_params: (required)
        :type summarize_document_body_params: SummarizeDocumentBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SummarizeDocumentSuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_gradient_workspace_id',
            'summarize_document_body_params'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method summarize_document" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['summarize_document_body_params'] is not None:
            _body_params = _params['summarize_document_body_params']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "SummarizeDocumentSuccess",
            '4XX': "SummarizeDocumentError",
        }

        return self.api_client.call_api(
            '/blocks/summarize', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
