# gradientai.openapi.client.FilesApi

All URIs are relative to *https://api.gradient.ai/api*

Method | HTTP request | Description
------------- | ------------- | -------------
[**upload_file**](FilesApi.md#upload_file) | **POST** /files | File upload


# **upload_file**
> UploadFileSuccess upload_file(type, x_gradient_workspace_id, file)

File upload

Stores uploaded file.

### Example

* Bearer Authentication (AccessToken):
```python
import time
import os
import gradientai.openapi.client
from gradientai.openapi.client.models.upload_file_success import UploadFileSuccess
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.FilesApi(api_client)
    type = 'type_example' # str | 
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 
    file = None # bytearray | 

    try:
        # File upload
        api_response = api_instance.upload_file(type, x_gradient_workspace_id, file)
        print("The response of FilesApi->upload_file:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling FilesApi->upload_file: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **str**|  | 
 **x_gradient_workspace_id** | **str**|  | 
 **file** | **bytearray**|  | 

### Return type

[**UploadFileSuccess**](UploadFileSuccess.md)

### Authorization

[AccessToken](../README.md#AccessToken)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**4XX** | Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

