# gradientai.openapi.client.RAGApi

All URIs are relative to *https://api.gradient.ai/api*

Method | HTTP request | Description
------------- | ------------- | -------------
[**add_files_to_rag_collection**](RAGApi.md#add_files_to_rag_collection) | **POST** /rag-collections/{id}/files | Add files to RAG collection
[**create_rag_collection**](RAGApi.md#create_rag_collection) | **POST** /rag-collections | Create RAG collection
[**get_rag_collection**](RAGApi.md#get_rag_collection) | **GET** /rag-collections/{id} | Get RAG collection
[**list_rag_collections**](RAGApi.md#list_rag_collections) | **GET** /rag-collections | List RAG collections


# **add_files_to_rag_collection**
> object add_files_to_rag_collection(id, x_gradient_workspace_id, add_files_to_rag_collection_body_params)

Add files to RAG collection

Adds files to the RAG collection.

### Example

* Bearer Authentication (AccessToken):
```python
import time
import os
import gradientai.openapi.client
from gradientai.openapi.client.models.add_files_to_rag_collection_body_params import AddFilesToRagCollectionBodyParams
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.RAGApi(api_client)
    id = 'id_example' # str | 
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 
    add_files_to_rag_collection_body_params = gradientai.openapi.client.AddFilesToRagCollectionBodyParams() # AddFilesToRagCollectionBodyParams | 

    try:
        # Add files to RAG collection
        api_response = api_instance.add_files_to_rag_collection(id, x_gradient_workspace_id, add_files_to_rag_collection_body_params)
        print("The response of RAGApi->add_files_to_rag_collection:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RAGApi->add_files_to_rag_collection: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 
 **x_gradient_workspace_id** | **str**|  | 
 **add_files_to_rag_collection_body_params** | [**AddFilesToRagCollectionBodyParams**](AddFilesToRagCollectionBodyParams.md)|  | 

### Return type

**object**

### Authorization

[AccessToken](../README.md#AccessToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**4XX** | Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_rag_collection**
> CreateRagCollectionSuccess create_rag_collection(x_gradient_workspace_id, create_rag_collection_body_params)

Create RAG collection

Creates a new collection of RAG documents.

### Example

* Bearer Authentication (AccessToken):
```python
import time
import os
import gradientai.openapi.client
from gradientai.openapi.client.models.create_rag_collection_body_params import CreateRagCollectionBodyParams
from gradientai.openapi.client.models.create_rag_collection_success import CreateRagCollectionSuccess
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.RAGApi(api_client)
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 
    create_rag_collection_body_params = gradientai.openapi.client.CreateRagCollectionBodyParams() # CreateRagCollectionBodyParams | 

    try:
        # Create RAG collection
        api_response = api_instance.create_rag_collection(x_gradient_workspace_id, create_rag_collection_body_params)
        print("The response of RAGApi->create_rag_collection:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RAGApi->create_rag_collection: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_gradient_workspace_id** | **str**|  | 
 **create_rag_collection_body_params** | [**CreateRagCollectionBodyParams**](CreateRagCollectionBodyParams.md)|  | 

### Return type

[**CreateRagCollectionSuccess**](CreateRagCollectionSuccess.md)

### Authorization

[AccessToken](../README.md#AccessToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**4XX** | Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_rag_collection**
> GetRagCollectionSuccess get_rag_collection(id, x_gradient_workspace_id)

Get RAG collection

Gets the RAG collection details.

### Example

* Bearer Authentication (AccessToken):
```python
import time
import os
import gradientai.openapi.client
from gradientai.openapi.client.models.get_rag_collection_success import GetRagCollectionSuccess
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.RAGApi(api_client)
    id = 'id_example' # str | 
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 

    try:
        # Get RAG collection
        api_response = api_instance.get_rag_collection(id, x_gradient_workspace_id)
        print("The response of RAGApi->get_rag_collection:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RAGApi->get_rag_collection: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 
 **x_gradient_workspace_id** | **str**|  | 

### Return type

[**GetRagCollectionSuccess**](GetRagCollectionSuccess.md)

### Authorization

[AccessToken](../README.md#AccessToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**4XX** | Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_rag_collections**
> ListRagCollectionsSuccess list_rag_collections(x_gradient_workspace_id)

List RAG collections

Lists all RAG collections associated with your workspace.

### Example

* Bearer Authentication (AccessToken):
```python
import time
import os
import gradientai.openapi.client
from gradientai.openapi.client.models.list_rag_collections_success import ListRagCollectionsSuccess
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.RAGApi(api_client)
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 

    try:
        # List RAG collections
        api_response = api_instance.list_rag_collections(x_gradient_workspace_id)
        print("The response of RAGApi->list_rag_collections:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RAGApi->list_rag_collections: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_gradient_workspace_id** | **str**|  | 

### Return type

[**ListRagCollectionsSuccess**](ListRagCollectionsSuccess.md)

### Authorization

[AccessToken](../README.md#AccessToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**4XX** | Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

