# coding: utf-8

"""
    Gradient AI API

    Interface for interacting with Gradient AI.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@gradient.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, conlist, constr
from gradientai.openapi.client.models.analyze_sentiment_body_params_examples_inner import AnalyzeSentimentBodyParamsExamplesInner

class AnalyzeSentimentBodyParams(BaseModel):
    """
    AnalyzeSentimentBodyParams
    """
    document: constr(strict=True, min_length=1) = Field(..., description="The document that will be analyzed to determine the sentiment.")
    examples: Optional[conlist(AnalyzeSentimentBodyParamsExamplesInner)] = Field(None, description="Example pairs of documents and sentiments.")
    additional_properties: Dict[str, Any] = {}
    __properties = ["document", "examples"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AnalyzeSentimentBodyParams:
        """Create an instance of AnalyzeSentimentBodyParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "additional_properties"
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in examples (list)
        _items = []
        if self.examples:
            for _item in self.examples:
                if _item:
                    _items.append(_item.to_dict())
            _dict['examples'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if examples (nullable) is None
        # and __fields_set__ contains the field
        if self.examples is None and "examples" in self.__fields_set__:
            _dict['examples'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AnalyzeSentimentBodyParams:
        """Create an instance of AnalyzeSentimentBodyParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AnalyzeSentimentBodyParams.parse_obj(obj)

        _obj = AnalyzeSentimentBodyParams.parse_obj({
            "document": obj.get("document"),
            "examples": [AnalyzeSentimentBodyParamsExamplesInner.from_dict(_item) for _item in obj.get("examples")] if obj.get("examples") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj

