# coding: utf-8

"""
    Gradient AI API

    Interface for interacting with Gradient AI.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@gradient.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic import BaseModel, Field, constr
from gradientai.openapi.client.models.extract_entity_body_params_schema_value import ExtractEntityBodyParamsSchemaValue

class ExtractEntityBodyParams(BaseModel):
    """
    ExtractEntityBodyParams
    """
    document: constr(strict=True, min_length=1) = Field(..., description="The document from which to extract data.")
    var_schema: Dict[str, ExtractEntityBodyParamsSchemaValue] = Field(..., alias="schema", description="The expected schema of the entity result.")
    additional_properties: Dict[str, Any] = {}
    __properties = ["document", "schema"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExtractEntityBodyParams:
        """Create an instance of ExtractEntityBodyParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "additional_properties"
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in var_schema (dict)
        _field_dict = {}
        if self.var_schema:
            for _key in self.var_schema:
                if self.var_schema[_key]:
                    _field_dict[_key] = self.var_schema[_key].to_dict()
            _dict['schema'] = _field_dict
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExtractEntityBodyParams:
        """Create an instance of ExtractEntityBodyParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExtractEntityBodyParams.parse_obj(obj)

        _obj = ExtractEntityBodyParams.parse_obj({
            "document": obj.get("document"),
            "var_schema": dict(
                (_k, ExtractEntityBodyParamsSchemaValue.from_dict(_v))
                for _k, _v in obj.get("schema").items()
            )
            if obj.get("schema") is not None
            else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj

