# coding: utf-8

"""
    Gradient AI API

    Interface for interacting with Gradient AI.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@gradient.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic import BaseModel, Field, StrictStr, conint, conlist
from gradientai.openapi.client.models.extract_pdf_success_pages_inner_images_inner import ExtractPdfSuccessPagesInnerImagesInner
from gradientai.openapi.client.models.extract_pdf_success_pages_inner_tables_inner import ExtractPdfSuccessPagesInnerTablesInner
from gradientai.openapi.client.models.extract_pdf_success_pages_inner_text_blocks_inner import ExtractPdfSuccessPagesInnerTextBlocksInner

class ExtractPdfSuccessPagesInner(BaseModel):
    """
    ExtractPdfSuccessPagesInner
    """
    images: conlist(ExtractPdfSuccessPagesInnerImagesInner) = Field(...)
    page_number: conint(strict=True, gt=0) = Field(..., alias="pageNumber")
    tables: conlist(ExtractPdfSuccessPagesInnerTablesInner) = Field(...)
    text: StrictStr = Field(...)
    text_blocks: conlist(ExtractPdfSuccessPagesInnerTextBlocksInner) = Field(..., alias="textBlocks")
    additional_properties: Dict[str, Any] = {}
    __properties = ["images", "pageNumber", "tables", "text", "textBlocks"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExtractPdfSuccessPagesInner:
        """Create an instance of ExtractPdfSuccessPagesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "additional_properties"
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict['images'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tables (list)
        _items = []
        if self.tables:
            for _item in self.tables:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tables'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in text_blocks (list)
        _items = []
        if self.text_blocks:
            for _item in self.text_blocks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['textBlocks'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExtractPdfSuccessPagesInner:
        """Create an instance of ExtractPdfSuccessPagesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExtractPdfSuccessPagesInner.parse_obj(obj)

        _obj = ExtractPdfSuccessPagesInner.parse_obj({
            "images": [ExtractPdfSuccessPagesInnerImagesInner.from_dict(_item) for _item in obj.get("images")] if obj.get("images") is not None else None,
            "page_number": obj.get("pageNumber"),
            "tables": [ExtractPdfSuccessPagesInnerTablesInner.from_dict(_item) for _item in obj.get("tables")] if obj.get("tables") is not None else None,
            "text": obj.get("text"),
            "text_blocks": [ExtractPdfSuccessPagesInnerTextBlocksInner.from_dict(_item) for _item in obj.get("textBlocks")] if obj.get("textBlocks") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj

