# coding: utf-8

"""
    Gradient AI API

    Interface for interacting with Gradient AI.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@gradient.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr, conint

class ExtractPdfSuccessPagesInnerTablesInnerTableRowsInnerCellsInner(BaseModel):
    """
    ExtractPdfSuccessPagesInnerTablesInnerTableRowsInnerCellsInner
    """
    cell_value: StrictStr = Field(..., alias="cellValue")
    col_span: Optional[conint(strict=True, gt=0)] = Field(..., alias="colSpan")
    row_span: Optional[conint(strict=True, gt=0)] = Field(..., alias="rowSpan")
    additional_properties: Dict[str, Any] = {}
    __properties = ["cellValue", "colSpan", "rowSpan"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExtractPdfSuccessPagesInnerTablesInnerTableRowsInnerCellsInner:
        """Create an instance of ExtractPdfSuccessPagesInnerTablesInnerTableRowsInnerCellsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "additional_properties"
                          },
                          exclude_none=True)
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if col_span (nullable) is None
        # and __fields_set__ contains the field
        if self.col_span is None and "col_span" in self.__fields_set__:
            _dict['colSpan'] = None

        # set to None if row_span (nullable) is None
        # and __fields_set__ contains the field
        if self.row_span is None and "row_span" in self.__fields_set__:
            _dict['rowSpan'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExtractPdfSuccessPagesInnerTablesInnerTableRowsInnerCellsInner:
        """Create an instance of ExtractPdfSuccessPagesInnerTablesInnerTableRowsInnerCellsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExtractPdfSuccessPagesInnerTablesInnerTableRowsInnerCellsInner.parse_obj(obj)

        _obj = ExtractPdfSuccessPagesInnerTablesInnerTableRowsInnerCellsInner.parse_obj({
            "cell_value": obj.get("cellValue"),
            "col_span": obj.get("colSpan"),
            "row_span": obj.get("rowSpan")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj

