import typing
import bpy.ops.transform
import bpy.types

GenericType = typing.TypeVar("GenericType")

def brush_stroke(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    stroke: typing.Optional[
        bpy.types.bpy_prop_collection["bpy.types.OperatorStrokeElement"]
    ] = None,
    mode: typing.Optional[typing.Any] = "NORMAL",
):
    """Draw a new stroke in the active Grease Pencil object

        :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
        :type execution_context: typing.Optional[typing.Union[int, str]]
        :type undo: typing.Optional[bool]
        :param stroke: Stroke
        :type stroke: typing.Optional[bpy.types.bpy_prop_collection['bpy.types.OperatorStrokeElement']]
        :param mode: Stroke Mode, Action taken when a paint stroke is made

    NORMAL
    Regular -- Apply brush normally.

    INVERT
    Invert -- Invert action of brush for duration of stroke.

    SMOOTH
    Smooth -- Switch brush to smooth mode for duration of stroke.
        :type mode: typing.Optional[typing.Any]
    """

    ...

def caps_set(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    type: typing.Optional[typing.Any] = "ROUND",
):
    """Change curve caps mode (rounded or flat)

        :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
        :type execution_context: typing.Optional[typing.Union[int, str]]
        :type undo: typing.Optional[bool]
        :param type: Type

    ROUND
    Rounded -- Set as default rounded.

    FLAT
    Flat.

    START
    Toggle Start.

    END
    Toggle End.
        :type type: typing.Optional[typing.Any]
    """

    ...

def clean_loose(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    limit: typing.Optional[typing.Any] = 1,
):
    """Remove loose points

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param limit: Limit, Number of points to consider stroke as loose
    :type limit: typing.Optional[typing.Any]
    """

    ...

def cyclical_set(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    type: typing.Optional[typing.Any] = "TOGGLE",
):
    """Close or open the selected stroke adding a segment from last to first point

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param type: Type
    :type type: typing.Optional[typing.Any]
    """

    ...

def delete(override_context=None, execution_context=None, undo=None):
    """Delete selected strokes or points

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def delete_frame(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    type: typing.Optional[typing.Any] = "ACTIVE_FRAME",
):
    """Delete Grease Pencil Frame(s)

        :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
        :type execution_context: typing.Optional[typing.Union[int, str]]
        :type undo: typing.Optional[bool]
        :param type: Type, Method used for deleting Grease Pencil frames

    ACTIVE_FRAME
    Active Frame -- Deletes current frame in the active layer.

    ALL_FRAMES
    All Active Frames -- Delete active frames for all layers.
        :type type: typing.Optional[typing.Any]
    """

    ...

def dissolve(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    type: typing.Optional[typing.Any] = "POINTS",
):
    """Delete selected points without splitting strokes

        :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
        :type execution_context: typing.Optional[typing.Union[int, str]]
        :type undo: typing.Optional[bool]
        :param type: Type, Method used for dissolving stroke points

    POINTS
    Dissolve -- Dissolve selected points.

    BETWEEN
    Dissolve Between -- Dissolve points between selected points.

    UNSELECT
    Dissolve Unselect -- Dissolve all unselected points.
        :type type: typing.Optional[typing.Any]
    """

    ...

def draw_mode_toggle(override_context=None, execution_context=None, undo=None):
    """Enter/Exit draw mode for grease pencil

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def duplicate(override_context=None, execution_context=None, undo=None):
    """Duplicate the selected points

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def duplicate_move(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    GREASE_PENCIL_OT_duplicate: typing.Optional[typing.Any] = None,
    TRANSFORM_OT_translate: typing.Optional["bpy.ops.transform.translate"] = None,
):
    """Make copies of the selected Grease Pencil strokes and move them

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param GREASE_PENCIL_OT_duplicate: Duplicate, Duplicate the selected points
    :type GREASE_PENCIL_OT_duplicate: typing.Optional[typing.Any]
    :param TRANSFORM_OT_translate: Move, Move selected items
    :type TRANSFORM_OT_translate: typing.Optional['bpy.ops.transform.translate']
    """

    ...

def insert_blank_frame(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    all_layers: typing.Optional[typing.Union[bool, typing.Any]] = False,
    duration: typing.Optional[typing.Any] = 0,
):
    """Insert a blank frame on the current scene frame

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param all_layers: All Layers, Insert a blank frame in all editable layers
    :type all_layers: typing.Optional[typing.Union[bool, typing.Any]]
    :param duration: Duration
    :type duration: typing.Optional[typing.Any]
    """

    ...

def layer_active(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    layer: typing.Optional[typing.Any] = 0,
):
    """Set the active Grease Pencil layer

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param layer: Grease Pencil Layer
    :type layer: typing.Optional[typing.Any]
    """

    ...

def layer_add(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    new_layer_name: typing.Union[str, typing.Any] = "Layer",
):
    """Add a new Grease Pencil layer in the active object

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param new_layer_name: Name, Name of the new layer
    :type new_layer_name: typing.Union[str, typing.Any]
    """

    ...

def layer_duplicate(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    empty_keyframes: typing.Optional[typing.Union[bool, typing.Any]] = False,
):
    """Make a copy of the active Grease Pencil layer

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param empty_keyframes: Empty Keyframes, Add Empty Keyframes
    :type empty_keyframes: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def layer_group_add(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    new_layer_group_name: typing.Union[str, typing.Any] = "",
):
    """Add a new Grease Pencil layer group in the active object

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param new_layer_group_name: Name, Name of the new layer group
    :type new_layer_group_name: typing.Union[str, typing.Any]
    """

    ...

def layer_hide(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    unselected: typing.Optional[typing.Union[bool, typing.Any]] = False,
):
    """Hide selected/unselected Grease Pencil layers

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param unselected: Unselected, Hide unselected rather than selected layers
    :type unselected: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def layer_isolate(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    affect_visibility: typing.Optional[typing.Union[bool, typing.Any]] = False,
):
    """Make only active layer visible/editable

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param affect_visibility: Affect Visibility, Also affect the visibility
    :type affect_visibility: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def layer_lock_all(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    lock: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Lock all Grease Pencil layers to prevent them from being accidentally modified

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param lock: Lock Value, Lock/Unlock all layers
    :type lock: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def layer_remove(override_context=None, execution_context=None, undo=None):
    """Remove the active Grease Pencil layer

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def layer_reorder(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    target_layer_name: typing.Union[str, typing.Any] = "Layer",
    location: typing.Optional[typing.Any] = "ABOVE",
):
    """Reorder the active Grease Pencil layer

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param target_layer_name: Target Name, Name of the target layer
    :type target_layer_name: typing.Union[str, typing.Any]
    :param location: Location
    :type location: typing.Optional[typing.Any]
    """

    ...

def layer_reveal(override_context=None, execution_context=None, undo=None):
    """Show all Grease Pencil layers

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def material_copy_to_object(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    only_active: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Append Materials of the active Grease Pencil to other object

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param only_active: Only Active, Append only active material, uncheck to append all materials
    :type only_active: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def material_hide(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    invert: typing.Optional[typing.Union[bool, typing.Any]] = False,
):
    """Hide active/inactive Grease Pencil material(s)

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param invert: Invert, Hide inactive materials instead of the active one
    :type invert: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def material_lock_all(override_context=None, execution_context=None, undo=None):
    """Lock all Grease Pencil materials to prevent them from being accidentally modified

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def material_lock_unselected(override_context=None, execution_context=None, undo=None):
    """Lock any material not used in any selected stroke

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def material_lock_unused(override_context=None, execution_context=None, undo=None):
    """Lock and hide any material not used

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def material_reveal(override_context=None, execution_context=None, undo=None):
    """Unhide all hidden Grease Pencil materials

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def material_unlock_all(override_context=None, execution_context=None, undo=None):
    """Unlock all Grease Pencil materials so that they can be edited

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def move_to_layer(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    target_layer_name: typing.Union[str, typing.Any] = "Layer",
    add_new_layer: typing.Optional[typing.Union[bool, typing.Any]] = False,
):
    """Move selected strokes to another layer

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param target_layer_name: Name, Target Grease Pencil Layer
    :type target_layer_name: typing.Union[str, typing.Any]
    :param add_new_layer: New Layer, Move selection to a new layer
    :type add_new_layer: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def reorder(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    direction: typing.Optional[typing.Any] = "TOP",
):
    """Change the display order of the selected strokes

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param direction: Direction
    :type direction: typing.Optional[typing.Any]
    """

    ...

def select_all(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    action: typing.Optional[typing.Any] = "TOGGLE",
):
    """(De)select all visible strokes

        :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
        :type execution_context: typing.Optional[typing.Union[int, str]]
        :type undo: typing.Optional[bool]
        :param action: Action, Selection action to execute

    TOGGLE
    Toggle -- Toggle selection for all elements.

    SELECT
    Select -- Select all elements.

    DESELECT
    Deselect -- Deselect all elements.

    INVERT
    Invert -- Invert selection of all elements.
        :type action: typing.Optional[typing.Any]
    """

    ...

def select_alternate(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    deselect_ends: typing.Optional[typing.Union[bool, typing.Any]] = False,
):
    """Select alternated points in strokes with already selected points

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param deselect_ends: Deselect Ends, (De)select the first and last point of each stroke
    :type deselect_ends: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def select_ends(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    amount_start: typing.Optional[typing.Any] = 0,
    amount_end: typing.Optional[typing.Any] = 1,
):
    """Select end points of strokes

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param amount_start: Amount Start, Number of points to select from the start
    :type amount_start: typing.Optional[typing.Any]
    :param amount_end: Amount End, Number of points to select from the end
    :type amount_end: typing.Optional[typing.Any]
    """

    ...

def select_less(override_context=None, execution_context=None, undo=None):
    """Shrink the selection by one point

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def select_linked(override_context=None, execution_context=None, undo=None):
    """Select all points in curves with any point selection

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def select_more(override_context=None, execution_context=None, undo=None):
    """Grow the selection by one point

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def select_random(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    ratio: typing.Optional[typing.Any] = 0.5,
    seed: typing.Optional[typing.Any] = 0,
    action: typing.Optional[typing.Any] = "SELECT",
):
    """Selects random points from the current strokes selection

        :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
        :type execution_context: typing.Optional[typing.Union[int, str]]
        :type undo: typing.Optional[bool]
        :param ratio: Ratio, Portion of items to select randomly
        :type ratio: typing.Optional[typing.Any]
        :param seed: Random Seed, Seed for the random number generator
        :type seed: typing.Optional[typing.Any]
        :param action: Action, Selection action to execute

    SELECT
    Select -- Select all elements.

    DESELECT
    Deselect -- Deselect all elements.
        :type action: typing.Optional[typing.Any]
    """

    ...

def separate(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    mode: typing.Optional[typing.Any] = "SELECTED",
):
    """Separate the selected geometry into a new grease pencil object

        :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
        :type execution_context: typing.Optional[typing.Union[int, str]]
        :type undo: typing.Optional[bool]
        :param mode: Mode

    SELECTED
    Selection -- Separate selected geometry.

    MATERIAL
    By Material -- Separate by material.

    LAYER
    By Layer -- Separate by layer.
        :type mode: typing.Optional[typing.Any]
    """

    ...

def set_active_material(override_context=None, execution_context=None, undo=None):
    """Set the selected stroke material as the active material

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...

def set_material(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    slot: typing.Optional[typing.Union[int, str, typing.Any]] = "DEFAULT",
):
    """Set active material

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param slot: Material Slot
    :type slot: typing.Optional[typing.Union[int, str, typing.Any]]
    """

    ...

def set_selection_mode(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    mode: typing.Optional[typing.Any] = "POINT",
):
    """Change the selection mode for Grease Pencil strokes

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param mode: Mode
    :type mode: typing.Optional[typing.Any]
    """

    ...

def set_uniform_opacity(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    opacity: typing.Optional[typing.Any] = 1.0,
):
    """Set all stroke points to same opacity

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param opacity: Opacity
    :type opacity: typing.Optional[typing.Any]
    """

    ...

def set_uniform_thickness(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    thickness: typing.Optional[typing.Any] = 0.1,
):
    """Set all stroke points to same thickness

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param thickness: Thickness, Thickness
    :type thickness: typing.Optional[typing.Any]
    """

    ...

def stroke_material_set(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    material: typing.Union[str, typing.Any] = "",
):
    """Assign the active material slot to the selected strokes

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param material: Material, Name of the material
    :type material: typing.Union[str, typing.Any]
    """

    ...

def stroke_simplify(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    factor: typing.Optional[typing.Any] = 0.01,
):
    """Simplify selected strokes

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param factor: Factor
    :type factor: typing.Optional[typing.Any]
    """

    ...

def stroke_smooth(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    iterations: typing.Optional[typing.Any] = 10,
    factor: typing.Optional[typing.Any] = 1.0,
    smooth_ends: typing.Optional[typing.Union[bool, typing.Any]] = False,
    keep_shape: typing.Optional[typing.Union[bool, typing.Any]] = False,
    smooth_position: typing.Optional[typing.Union[bool, typing.Any]] = True,
    smooth_radius: typing.Optional[typing.Union[bool, typing.Any]] = True,
    smooth_opacity: typing.Optional[typing.Union[bool, typing.Any]] = False,
):
    """Smooth selected strokes

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param iterations: Iterations
    :type iterations: typing.Optional[typing.Any]
    :param factor: Factor
    :type factor: typing.Optional[typing.Any]
    :param smooth_ends: Smooth Endpoints
    :type smooth_ends: typing.Optional[typing.Union[bool, typing.Any]]
    :param keep_shape: Keep Shape
    :type keep_shape: typing.Optional[typing.Union[bool, typing.Any]]
    :param smooth_position: Position
    :type smooth_position: typing.Optional[typing.Union[bool, typing.Any]]
    :param smooth_radius: Radius
    :type smooth_radius: typing.Optional[typing.Union[bool, typing.Any]]
    :param smooth_opacity: Opacity
    :type smooth_opacity: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def stroke_subdivide(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    number_cuts: typing.Optional[typing.Any] = 1,
    only_selected: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Subdivide between continuous selected points of the stroke adding a point half way between them

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param number_cuts: Number of Cuts
    :type number_cuts: typing.Optional[typing.Any]
    :param only_selected: Selected Points, Smooth only selected points in the stroke
    :type only_selected: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def stroke_subdivide_smooth(
    override_context=None,
    execution_context=None,
    undo=None,
    *,
    GREASE_PENCIL_OT_stroke_subdivide: typing.Optional[typing.Any] = None,
    GREASE_PENCIL_OT_stroke_smooth: typing.Optional[typing.Any] = None,
):
    """Subdivide strokes and smooth them

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    :param GREASE_PENCIL_OT_stroke_subdivide: Subdivide Stroke, Subdivide between continuous selected points of the stroke adding a point half way between them
    :type GREASE_PENCIL_OT_stroke_subdivide: typing.Optional[typing.Any]
    :param GREASE_PENCIL_OT_stroke_smooth: Smooth Stroke, Smooth selected strokes
    :type GREASE_PENCIL_OT_stroke_smooth: typing.Optional[typing.Any]
    """

    ...

def stroke_switch_direction(override_context=None, execution_context=None, undo=None):
    """Change direction of the points of the selected strokes

    :type override_context: typing.Optional[typing.Union['bpy.types.Context', typing.Dict]]
    :type execution_context: typing.Optional[typing.Union[int, str]]
    :type undo: typing.Optional[bool]
    """

    ...
