# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2018 Dan Tès <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

layer = 76

objects = {
    0x05162463: "types.ResPQ",
    0x83c95aec: "types.PQInnerData",
    0x3c6a84d4: "types.PQInnerDataTemp",
    0x75a3f765: "types.BindAuthKeyInner",
    0x79cb045d: "types.ServerDHParamsFail",
    0xd0e8075c: "types.ServerDHParamsOk",
    0xb5890dba: "types.ServerDHInnerData",
    0x6643b654: "types.ClientDHInnerData",
    0x3bcbf734: "types.DhGenOk",
    0x46dc1fb9: "types.DhGenRetry",
    0xa69dae02: "types.DhGenFail",
    0xf660e1d4: "types.DestroyAuthKeyOk",
    0x0a9f2259: "types.DestroyAuthKeyNone",
    0xea109b13: "types.DestroyAuthKeyFail",
    0x60469778: "functions.ReqPq",
    0xbe7e8ef1: "functions.ReqPqMulti",
    0xd712e4be: "functions.ReqDHParams",
    0xf5045f1f: "functions.SetClientDHParams",
    0xd1435160: "functions.DestroyAuthKey",
    0x62d6b459: "types.MsgsAck",
    0xa7eff811: "types.BadMsgNotification",
    0xedab447b: "types.BadServerSalt",
    0xda69fb52: "types.MsgsStateReq",
    0x04deb57d: "types.MsgsStateInfo",
    0x8cc0d131: "types.MsgsAllInfo",
    0x276d3ec6: "types.MsgDetailedInfo",
    0x809db6df: "types.MsgNewDetailedInfo",
    0x7d861a08: "types.MsgResendReq",
    0x8610baeb: "types.MsgResendAnsReq",
    0xf35c6d01: "types.RpcResult",
    0x2144ca19: "types.RpcError",
    0x5e2ad36e: "types.RpcAnswerUnknown",
    0xcd78e586: "types.RpcAnswerDroppedRunning",
    0xa43ad8b7: "types.RpcAnswerDropped",
    0x347773c5: "types.Pong",
    0xe22045fc: "types.DestroySessionOk",
    0x62d350c9: "types.DestroySessionNone",
    0x9ec20908: "types.NewSessionCreated",
    0xd433ad73: "types.IpPort",
    0xd997c3c5: "types.help.ConfigSimple",
    0x58e4a740: "functions.RpcDropAnswer",
    0xb921bd04: "functions.GetFutureSalts",
    0x7abe77ec: "functions.Ping",
    0xf3427b8c: "functions.PingDelayDisconnect",
    0xe7512126: "functions.DestroySession",
    0x9a5f6e95: "functions.contest.SaveDeveloperInfo",
    0x9299359f: "functions.HttpWait",
    0x7f3b18ea: "types.InputPeerEmpty",
    0x7da07ec9: "types.InputPeerSelf",
    0x179be863: "types.InputPeerChat",
    0x7b8e7de6: "types.InputPeerUser",
    0x20adaef8: "types.InputPeerChannel",
    0xb98886cf: "types.InputUserEmpty",
    0xf7c1b13f: "types.InputUserSelf",
    0xd8292816: "types.InputUser",
    0xf392b7f4: "types.InputPhoneContact",
    0xf52ff27f: "types.InputFile",
    0xfa4f0bb5: "types.InputFileBig",
    0x9664f57f: "types.InputMediaEmpty",
    0x1e287d04: "types.InputMediaUploadedPhoto",
    0xb3ba0635: "types.InputMediaPhoto",
    0xf9c44144: "types.InputMediaGeoPoint",
    0xa6e45987: "types.InputMediaContact",
    0x5b38c6c1: "types.InputMediaUploadedDocument",
    0x23ab23d2: "types.InputMediaDocument",
    0xc13d1c11: "types.InputMediaVenue",
    0x4843b0fd: "types.InputMediaGifExternal",
    0xe5bbfe1a: "types.InputMediaPhotoExternal",
    0xfb52dc99: "types.InputMediaDocumentExternal",
    0xd33f43f3: "types.InputMediaGame",
    0xf4e096c3: "types.InputMediaInvoice",
    0x7b1a118f: "types.InputMediaGeoLive",
    0x1ca48f57: "types.InputChatPhotoEmpty",
    0x927c55b4: "types.InputChatUploadedPhoto",
    0x8953ad37: "types.InputChatPhoto",
    0xe4c123d6: "types.InputGeoPointEmpty",
    0xf3b7acc9: "types.InputGeoPoint",
    0x1cd7bf0d: "types.InputPhotoEmpty",
    0xfb95c6c4: "types.InputPhoto",
    0x14637196: "types.InputFileLocation",
    0xf5235d55: "types.InputEncryptedFileLocation",
    0x430f0724: "types.InputDocumentFileLocation",
    0x770656a8: "types.InputAppEvent",
    0x9db1bc6d: "types.PeerUser",
    0xbad0e5bb: "types.PeerChat",
    0xbddde532: "types.PeerChannel",
    0xaa963b05: "types.storage.FileUnknown",
    0x40bc6f52: "types.storage.FilePartial",
    0x007efe0e: "types.storage.FileJpeg",
    0xcae1aadf: "types.storage.FileGif",
    0x0a4f63c0: "types.storage.FilePng",
    0xae1e508d: "types.storage.FilePdf",
    0x528a0677: "types.storage.FileMp3",
    0x4b09ebbc: "types.storage.FileMov",
    0xb3cea0e4: "types.storage.FileMp4",
    0x1081464c: "types.storage.FileWebp",
    0x7c596b46: "types.FileLocationUnavailable",
    0x53d69076: "types.FileLocation",
    0x200250ba: "types.UserEmpty",
    0x2e13f4c3: "types.User",
    0x4f11bae1: "types.UserProfilePhotoEmpty",
    0xd559d8c8: "types.UserProfilePhoto",
    0x09d05049: "types.UserStatusEmpty",
    0xedb93949: "types.UserStatusOnline",
    0x008c703f: "types.UserStatusOffline",
    0xe26f42f1: "types.UserStatusRecently",
    0x07bf09fc: "types.UserStatusLastWeek",
    0x77ebc742: "types.UserStatusLastMonth",
    0x9ba2d800: "types.ChatEmpty",
    0xd91cdd54: "types.Chat",
    0x07328bdb: "types.ChatForbidden",
    0x450b7115: "types.Channel",
    0x289da732: "types.ChannelForbidden",
    0x2e02a614: "types.ChatFull",
    0x76af5481: "types.ChannelFull",
    0xc8d7493e: "types.ChatParticipant",
    0xda13538a: "types.ChatParticipantCreator",
    0xe2d6e436: "types.ChatParticipantAdmin",
    0xfc900c2b: "types.ChatParticipantsForbidden",
    0x3f460fed: "types.ChatParticipants",
    0x37c1011c: "types.ChatPhotoEmpty",
    0x6153276a: "types.ChatPhoto",
    0x83e5de54: "types.MessageEmpty",
    0x44f9b43d: "types.Message",
    0x9e19a1f6: "types.MessageService",
    0x3ded6320: "types.MessageMediaEmpty",
    0x695150d7: "types.MessageMediaPhoto",
    0x56e0d474: "types.MessageMediaGeo",
    0x5e7d2f39: "types.MessageMediaContact",
    0x9f84f49e: "types.MessageMediaUnsupported",
    0x9cb070d7: "types.MessageMediaDocument",
    0xa32dd600: "types.MessageMediaWebPage",
    0x2ec0533f: "types.MessageMediaVenue",
    0xfdb19008: "types.MessageMediaGame",
    0x84551347: "types.MessageMediaInvoice",
    0x7c3c2609: "types.MessageMediaGeoLive",
    0xb6aef7b0: "types.MessageActionEmpty",
    0xa6638b9a: "types.MessageActionChatCreate",
    0xb5a1ce5a: "types.MessageActionChatEditTitle",
    0x7fcb13a8: "types.MessageActionChatEditPhoto",
    0x95e3fbef: "types.MessageActionChatDeletePhoto",
    0x488a7337: "types.MessageActionChatAddUser",
    0xb2ae9b0c: "types.MessageActionChatDeleteUser",
    0xf89cf5e8: "types.MessageActionChatJoinedByLink",
    0x95d2ac92: "types.MessageActionChannelCreate",
    0x51bdb021: "types.MessageActionChatMigrateTo",
    0xb055eaee: "types.MessageActionChannelMigrateFrom",
    0x94bd38ed: "types.MessageActionPinMessage",
    0x9fbab604: "types.MessageActionHistoryClear",
    0x92a72876: "types.MessageActionGameScore",
    0x8f31b327: "types.MessageActionPaymentSentMe",
    0x40699cd0: "types.MessageActionPaymentSent",
    0x80e11a7f: "types.MessageActionPhoneCall",
    0x4792929b: "types.MessageActionScreenshotTaken",
    0xfae69f56: "types.MessageActionCustomAction",
    0xabe9affe: "types.MessageActionBotAllowed",
    0xe4def5db: "types.Dialog",
    0x2331b22d: "types.PhotoEmpty",
    0x9288dd29: "types.Photo",
    0x0e17e23c: "types.PhotoSizeEmpty",
    0x77bfb61b: "types.PhotoSize",
    0xe9a734fa: "types.PhotoCachedSize",
    0x1117dd5f: "types.GeoPointEmpty",
    0x2049d70c: "types.GeoPoint",
    0x811ea28e: "types.auth.CheckedPhone",
    0x5e002502: "types.auth.SentCode",
    0xcd050916: "types.auth.Authorization",
    0xdf969c2d: "types.auth.ExportedAuthorization",
    0xb8bc5b0c: "types.InputNotifyPeer",
    0x193b4417: "types.InputNotifyUsers",
    0x4a95e84e: "types.InputNotifyChats",
    0xa429b886: "types.InputNotifyAll",
    0xf03064d8: "types.InputPeerNotifyEventsEmpty",
    0xe86a2c74: "types.InputPeerNotifyEventsAll",
    0x38935eb2: "types.InputPeerNotifySettings",
    0xadd53cb3: "types.PeerNotifyEventsEmpty",
    0x6d1ded88: "types.PeerNotifyEventsAll",
    0x70a68512: "types.PeerNotifySettingsEmpty",
    0x9acda4c0: "types.PeerNotifySettings",
    0x818426cd: "types.PeerSettings",
    0xccb03657: "types.WallPaper",
    0x63117f24: "types.WallPaperSolid",
    0x58dbcab8: "types.InputReportReasonSpam",
    0x1e22c78d: "types.InputReportReasonViolence",
    0x2e59d922: "types.InputReportReasonPornography",
    0xe1746d0a: "types.InputReportReasonOther",
    0x0f220f3f: "types.UserFull",
    0xf911c994: "types.Contact",
    0xd0028438: "types.ImportedContact",
    0x561bc879: "types.ContactBlocked",
    0xd3680c61: "types.ContactStatus",
    0x3ace484c: "types.contacts.Link",
    0xb74ba9d2: "types.contacts.ContactsNotModified",
    0xeae87e42: "types.contacts.Contacts",
    0x77d01c3b: "types.contacts.ImportedContacts",
    0x1c138d15: "types.contacts.Blocked",
    0x900802a1: "types.contacts.BlockedSlice",
    0x15ba6c40: "types.messages.Dialogs",
    0x71e094f3: "types.messages.DialogsSlice",
    0x8c718e87: "types.messages.Messages",
    0x0b446ae3: "types.messages.MessagesSlice",
    0x99262e37: "types.messages.ChannelMessages",
    0x74535f21: "types.messages.MessagesNotModified",
    0x64ff9fd5: "types.messages.Chats",
    0x9cd81144: "types.messages.ChatsSlice",
    0xe5d7d19c: "types.messages.ChatFull",
    0xb45c69d1: "types.messages.AffectedHistory",
    0x57e2f66c: "types.InputMessagesFilterEmpty",
    0x9609a51c: "types.InputMessagesFilterPhotos",
    0x9fc00e65: "types.InputMessagesFilterVideo",
    0x56e9f0e4: "types.InputMessagesFilterPhotoVideo",
    0x9eddf188: "types.InputMessagesFilterDocument",
    0x7ef0dd87: "types.InputMessagesFilterUrl",
    0xffc86587: "types.InputMessagesFilterGif",
    0x50f5c392: "types.InputMessagesFilterVoice",
    0x3751b49e: "types.InputMessagesFilterMusic",
    0x3a20ecb8: "types.InputMessagesFilterChatPhotos",
    0x80c99768: "types.InputMessagesFilterPhoneCalls",
    0x7a7c17a4: "types.InputMessagesFilterRoundVoice",
    0xb549da53: "types.InputMessagesFilterRoundVideo",
    0xc1f8e69a: "types.InputMessagesFilterMyMentions",
    0xe7026d0d: "types.InputMessagesFilterGeo",
    0xe062db83: "types.InputMessagesFilterContacts",
    0x1f2b0afd: "types.UpdateNewMessage",
    0x4e90bfd6: "types.UpdateMessageID",
    0xa20db0e5: "types.UpdateDeleteMessages",
    0x5c486927: "types.UpdateUserTyping",
    0x9a65ea1f: "types.UpdateChatUserTyping",
    0x07761198: "types.UpdateChatParticipants",
    0x1bfbd823: "types.UpdateUserStatus",
    0xa7332b73: "types.UpdateUserName",
    0x95313b0c: "types.UpdateUserPhoto",
    0x2575bbb9: "types.UpdateContactRegistered",
    0x9d2e67c5: "types.UpdateContactLink",
    0x12bcbd9a: "types.UpdateNewEncryptedMessage",
    0x1710f156: "types.UpdateEncryptedChatTyping",
    0xb4a2e88d: "types.UpdateEncryption",
    0x38fe25b7: "types.UpdateEncryptedMessagesRead",
    0xea4b0e5c: "types.UpdateChatParticipantAdd",
    0x6e5f8c22: "types.UpdateChatParticipantDelete",
    0x8e5e9873: "types.UpdateDcOptions",
    0x80ece81a: "types.UpdateUserBlocked",
    0xbec268ef: "types.UpdateNotifySettings",
    0xebe46819: "types.UpdateServiceNotification",
    0xee3b272a: "types.UpdatePrivacy",
    0x12b9417b: "types.UpdateUserPhone",
    0x9961fd5c: "types.UpdateReadHistoryInbox",
    0x2f2f21bf: "types.UpdateReadHistoryOutbox",
    0x7f891213: "types.UpdateWebPage",
    0x68c13933: "types.UpdateReadMessagesContents",
    0xeb0467fb: "types.UpdateChannelTooLong",
    0xb6d45656: "types.UpdateChannel",
    0x62ba04d9: "types.UpdateNewChannelMessage",
    0x4214f37f: "types.UpdateReadChannelInbox",
    0xc37521c9: "types.UpdateDeleteChannelMessages",
    0x98a12b4b: "types.UpdateChannelMessageViews",
    0x6e947941: "types.UpdateChatAdmins",
    0xb6901959: "types.UpdateChatParticipantAdmin",
    0x688a30aa: "types.UpdateNewStickerSet",
    0x0bb2d201: "types.UpdateStickerSetsOrder",
    0x43ae3dec: "types.UpdateStickerSets",
    0x9375341e: "types.UpdateSavedGifs",
    0x54826690: "types.UpdateBotInlineQuery",
    0x0e48f964: "types.UpdateBotInlineSend",
    0x1b3f4df7: "types.UpdateEditChannelMessage",
    0x98592475: "types.UpdateChannelPinnedMessage",
    0xe73547e1: "types.UpdateBotCallbackQuery",
    0xe40370a3: "types.UpdateEditMessage",
    0xf9d27a5a: "types.UpdateInlineBotCallbackQuery",
    0x25d6c9c7: "types.UpdateReadChannelOutbox",
    0xee2bb969: "types.UpdateDraftMessage",
    0x571d2742: "types.UpdateReadFeaturedStickers",
    0x9a422c20: "types.UpdateRecentStickers",
    0xa229dd06: "types.UpdateConfig",
    0x3354678f: "types.UpdatePtsChanged",
    0x40771900: "types.UpdateChannelWebPage",
    0x19d27f3c: "types.UpdateDialogPinned",
    0xea4cb65b: "types.UpdatePinnedDialogs",
    0x8317c0c3: "types.UpdateBotWebhookJSON",
    0x9b9240a6: "types.UpdateBotWebhookJSONQuery",
    0xe0cdc940: "types.UpdateBotShippingQuery",
    0x5d2f3aa9: "types.UpdateBotPrecheckoutQuery",
    0xab0f6b1e: "types.UpdatePhoneCall",
    0x10c2404b: "types.UpdateLangPackTooLong",
    0x56022f4d: "types.UpdateLangPack",
    0xe511996d: "types.UpdateFavedStickers",
    0x89893b45: "types.UpdateChannelReadMessagesContents",
    0x7084a7be: "types.UpdateContactsReset",
    0x70db6837: "types.UpdateChannelAvailableMessages",
    0xa56c2a3e: "types.updates.State",
    0x5d75a138: "types.updates.DifferenceEmpty",
    0x00f49ca0: "types.updates.Difference",
    0xa8fb1981: "types.updates.DifferenceSlice",
    0x4afe8f6d: "types.updates.DifferenceTooLong",
    0xe317af7e: "types.UpdatesTooLong",
    0x914fbf11: "types.UpdateShortMessage",
    0x16812688: "types.UpdateShortChatMessage",
    0x78d4dec1: "types.UpdateShort",
    0x725b04c3: "types.UpdatesCombined",
    0x74ae4240: "types.Update",
    0x11f1331c: "types.UpdateShortSentMessage",
    0x8dca6aa5: "types.photos.Photos",
    0x15051f54: "types.photos.PhotosSlice",
    0x20212ca8: "types.photos.Photo",
    0x096a18d5: "types.upload.File",
    0xf18cda44: "types.upload.FileCdnRedirect",
    0x05d8c6cc: "types.DcOption",
    0x86b5778e: "types.Config",
    0x8e1a1775: "types.NearestDc",
    0x8987f311: "types.help.AppUpdate",
    0xc45a6536: "types.help.NoAppUpdate",
    0x18cb9f78: "types.help.InviteText",
    0xab7ec0a0: "types.EncryptedChatEmpty",
    0x3bf703dc: "types.EncryptedChatWaiting",
    0xc878527e: "types.EncryptedChatRequested",
    0xfa56ce36: "types.EncryptedChat",
    0x13d6dd27: "types.EncryptedChatDiscarded",
    0xf141b5e1: "types.InputEncryptedChat",
    0xc21f497e: "types.EncryptedFileEmpty",
    0x4a70994c: "types.EncryptedFile",
    0x1837c364: "types.InputEncryptedFileEmpty",
    0x64bd0306: "types.InputEncryptedFileUploaded",
    0x5a17b5e5: "types.InputEncryptedFile",
    0x2dc173c8: "types.InputEncryptedFileBigUploaded",
    0xed18c118: "types.EncryptedMessage",
    0x23734b06: "types.EncryptedMessageService",
    0xc0e24635: "types.messages.DhConfigNotModified",
    0x2c221edd: "types.messages.DhConfig",
    0x560f8935: "types.messages.SentEncryptedMessage",
    0x9493ff32: "types.messages.SentEncryptedFile",
    0x72f0eaae: "types.InputDocumentEmpty",
    0x18798952: "types.InputDocument",
    0x36f8c871: "types.DocumentEmpty",
    0x87232bc7: "types.Document",
    0x17c6b5f6: "types.help.Support",
    0x9fd40bd8: "types.NotifyPeer",
    0xb4c83b4c: "types.NotifyUsers",
    0xc007cec3: "types.NotifyChats",
    0x74d07c60: "types.NotifyAll",
    0x16bf744e: "types.SendMessageTypingAction",
    0xfd5ec8f5: "types.SendMessageCancelAction",
    0xa187d66f: "types.SendMessageRecordVideoAction",
    0xe9763aec: "types.SendMessageUploadVideoAction",
    0xd52f73f7: "types.SendMessageRecordAudioAction",
    0xf351d7ab: "types.SendMessageUploadAudioAction",
    0xd1d34a26: "types.SendMessageUploadPhotoAction",
    0xaa0cd9e4: "types.SendMessageUploadDocumentAction",
    0x176f8ba1: "types.SendMessageGeoLocationAction",
    0x628cbc6f: "types.SendMessageChooseContactAction",
    0xdd6a8f48: "types.SendMessageGamePlayAction",
    0x88f27fbc: "types.SendMessageRecordRoundAction",
    0x243e1c66: "types.SendMessageUploadRoundAction",
    0xb3134d9d: "types.contacts.Found",
    0x4f96cb18: "types.InputPrivacyKeyStatusTimestamp",
    0xbdfb0426: "types.InputPrivacyKeyChatInvite",
    0xfabadc5f: "types.InputPrivacyKeyPhoneCall",
    0xbc2eab30: "types.PrivacyKeyStatusTimestamp",
    0x500e6dfa: "types.PrivacyKeyChatInvite",
    0x3d662b7b: "types.PrivacyKeyPhoneCall",
    0x0d09e07b: "types.InputPrivacyValueAllowContacts",
    0x184b35ce: "types.InputPrivacyValueAllowAll",
    0x131cc67f: "types.InputPrivacyValueAllowUsers",
    0x0ba52007: "types.InputPrivacyValueDisallowContacts",
    0xd66b66c9: "types.InputPrivacyValueDisallowAll",
    0x90110467: "types.InputPrivacyValueDisallowUsers",
    0xfffe1bac: "types.PrivacyValueAllowContacts",
    0x65427b82: "types.PrivacyValueAllowAll",
    0x4d5bbe0c: "types.PrivacyValueAllowUsers",
    0xf888fa1a: "types.PrivacyValueDisallowContacts",
    0x8b73e763: "types.PrivacyValueDisallowAll",
    0x0c7f49b7: "types.PrivacyValueDisallowUsers",
    0x554abb6f: "types.account.PrivacyRules",
    0xb8d0afdf: "types.AccountDaysTTL",
    0x6c37c15c: "types.DocumentAttributeImageSize",
    0x11b58939: "types.DocumentAttributeAnimated",
    0x6319d612: "types.DocumentAttributeSticker",
    0x0ef02ce6: "types.DocumentAttributeVideo",
    0x9852f9c6: "types.DocumentAttributeAudio",
    0x15590068: "types.DocumentAttributeFilename",
    0x9801d2f7: "types.DocumentAttributeHasStickers",
    0xf1749a22: "types.messages.StickersNotModified",
    0x8a8ecd32: "types.messages.Stickers",
    0x12b299d4: "types.StickerPack",
    0xe86602c3: "types.messages.AllStickersNotModified",
    0xedfd405f: "types.messages.AllStickers",
    0x84d19185: "types.messages.AffectedMessages",
    0x5f4f9247: "types.ContactLinkUnknown",
    0xfeedd3ad: "types.ContactLinkNone",
    0x268f3f59: "types.ContactLinkHasPhone",
    0xd502c2d0: "types.ContactLinkContact",
    0xeb1477e8: "types.WebPageEmpty",
    0xc586da1c: "types.WebPagePending",
    0x5f07b4bc: "types.WebPage",
    0x85849473: "types.WebPageNotModified",
    0x7bf2e6f6: "types.Authorization",
    0x1250abde: "types.account.Authorizations",
    0x96dabc18: "types.account.NoPassword",
    0x7c18141c: "types.account.Password",
    0xb7b72ab3: "types.account.PasswordSettings",
    0x86916deb: "types.account.PasswordInputSettings",
    0x137948a5: "types.auth.PasswordRecovery",
    0xa384b779: "types.ReceivedNotifyMessage",
    0x69df3769: "types.ChatInviteEmpty",
    0xfc2e05bc: "types.ChatInviteExported",
    0x5a686d7c: "types.ChatInviteAlready",
    0xdb74f558: "types.ChatInvite",
    0xffb62b95: "types.InputStickerSetEmpty",
    0x9de7a269: "types.InputStickerSetID",
    0x861cc8a0: "types.InputStickerSetShortName",
    0x5585a139: "types.StickerSet",
    0xb60a24a6: "types.messages.StickerSet",
    0xc27ac8c7: "types.BotCommand",
    0x98e81d3a: "types.BotInfo",
    0xa2fa4880: "types.KeyboardButton",
    0x258aff05: "types.KeyboardButtonUrl",
    0x683a5e46: "types.KeyboardButtonCallback",
    0xb16a6c29: "types.KeyboardButtonRequestPhone",
    0xfc796b3f: "types.KeyboardButtonRequestGeoLocation",
    0x0568a748: "types.KeyboardButtonSwitchInline",
    0x50f41ccf: "types.KeyboardButtonGame",
    0xafd93fbb: "types.KeyboardButtonBuy",
    0x77608b83: "types.KeyboardButtonRow",
    0xa03e5b85: "types.ReplyKeyboardHide",
    0xf4108aa0: "types.ReplyKeyboardForceReply",
    0x3502758c: "types.ReplyKeyboardMarkup",
    0x48a30254: "types.ReplyInlineMarkup",
    0xbb92ba95: "types.MessageEntityUnknown",
    0xfa04579d: "types.MessageEntityMention",
    0x6f635b0d: "types.MessageEntityHashtag",
    0x6cef8ac7: "types.MessageEntityBotCommand",
    0x6ed02538: "types.MessageEntityUrl",
    0x64e475c2: "types.MessageEntityEmail",
    0xbd610bc9: "types.MessageEntityBold",
    0x826f8b60: "types.MessageEntityItalic",
    0x28a20571: "types.MessageEntityCode",
    0x73924be0: "types.MessageEntityPre",
    0x76a6d327: "types.MessageEntityTextUrl",
    0x352dca58: "types.MessageEntityMentionName",
    0x208e68c9: "types.InputMessageEntityMentionName",
    0x9b69e34b: "types.MessageEntityPhone",
    0x4c4e743f: "types.MessageEntityCashtag",
    0xee8c1e86: "types.InputChannelEmpty",
    0xafeb712e: "types.InputChannel",
    0x7f077ad9: "types.contacts.ResolvedPeer",
    0x0ae30253: "types.MessageRange",
    0x3e11affb: "types.updates.ChannelDifferenceEmpty",
    0x6a9d7b35: "types.updates.ChannelDifferenceTooLong",
    0x2064674e: "types.updates.ChannelDifference",
    0x94d42ee7: "types.ChannelMessagesFilterEmpty",
    0xcd77d957: "types.ChannelMessagesFilter",
    0x15ebac1d: "types.ChannelParticipant",
    0xa3289a6d: "types.ChannelParticipantSelf",
    0xe3e2e1f9: "types.ChannelParticipantCreator",
    0xa82fa898: "types.ChannelParticipantAdmin",
    0x222c1886: "types.ChannelParticipantBanned",
    0xde3f3c79: "types.ChannelParticipantsRecent",
    0xb4608969: "types.ChannelParticipantsAdmins",
    0xa3b54985: "types.ChannelParticipantsKicked",
    0xb0d1865b: "types.ChannelParticipantsBots",
    0x1427a5e1: "types.ChannelParticipantsBanned",
    0x0656ac4b: "types.ChannelParticipantsSearch",
    0xf56ee2a8: "types.channels.ChannelParticipants",
    0xf0173fe9: "types.channels.ChannelParticipantsNotModified",
    0xd0d9b163: "types.channels.ChannelParticipant",
    0xf1ee3e90: "types.help.TermsOfService",
    0x162ecc1f: "types.FoundGif",
    0x9c750409: "types.FoundGifCached",
    0x450a1c0a: "types.messages.FoundGifs",
    0xe8025ca2: "types.messages.SavedGifsNotModified",
    0x2e0709a5: "types.messages.SavedGifs",
    0x3380c786: "types.InputBotInlineMessageMediaAuto",
    0x3dcd7a87: "types.InputBotInlineMessageText",
    0xc1b15d65: "types.InputBotInlineMessageMediaGeo",
    0xaaafadc8: "types.InputBotInlineMessageMediaVenue",
    0x2daf01a7: "types.InputBotInlineMessageMediaContact",
    0x4b425864: "types.InputBotInlineMessageGame",
    0x88bf9319: "types.InputBotInlineResult",
    0xa8d864a7: "types.InputBotInlineResultPhoto",
    0xfff8fdc4: "types.InputBotInlineResultDocument",
    0x4fa417f2: "types.InputBotInlineResultGame",
    0x764cf810: "types.BotInlineMessageMediaAuto",
    0x8c7f65e2: "types.BotInlineMessageText",
    0xb722de65: "types.BotInlineMessageMediaGeo",
    0x4366232e: "types.BotInlineMessageMediaVenue",
    0x35edb4d4: "types.BotInlineMessageMediaContact",
    0x11965f3a: "types.BotInlineResult",
    0x17db940b: "types.BotInlineMediaResult",
    0x947ca848: "types.messages.BotResults",
    0x5dab1af4: "types.ExportedMessageLink",
    0x559ebe6d: "types.MessageFwdHeader",
    0x72a3158c: "types.auth.CodeTypeSms",
    0x741cd3e3: "types.auth.CodeTypeCall",
    0x226ccefb: "types.auth.CodeTypeFlashCall",
    0x3dbb5986: "types.auth.SentCodeTypeApp",
    0xc000bba2: "types.auth.SentCodeTypeSms",
    0x5353e5a7: "types.auth.SentCodeTypeCall",
    0xab03c6d9: "types.auth.SentCodeTypeFlashCall",
    0x36585ea4: "types.messages.BotCallbackAnswer",
    0x26b5dde6: "types.messages.MessageEditData",
    0x890c3d89: "types.InputBotInlineMessageID",
    0x3c20629f: "types.InlineBotSwitchPM",
    0x3371c354: "types.messages.PeerDialogs",
    0xedcdc05b: "types.TopPeer",
    0xab661b5b: "types.TopPeerCategoryBotsPM",
    0x148677e2: "types.TopPeerCategoryBotsInline",
    0x0637b7ed: "types.TopPeerCategoryCorrespondents",
    0xbd17a14a: "types.TopPeerCategoryGroups",
    0x161d9628: "types.TopPeerCategoryChannels",
    0x1e76a78c: "types.TopPeerCategoryPhoneCalls",
    0xfb834291: "types.TopPeerCategoryPeers",
    0xde266ef5: "types.contacts.TopPeersNotModified",
    0x70b772a8: "types.contacts.TopPeers",
    0xba4baec5: "types.DraftMessageEmpty",
    0xfd8e711f: "types.DraftMessage",
    0x04ede3cf: "types.messages.FeaturedStickersNotModified",
    0xf89d88e5: "types.messages.FeaturedStickers",
    0x0b17f890: "types.messages.RecentStickersNotModified",
    0x22f3afb3: "types.messages.RecentStickers",
    0x4fcba9c8: "types.messages.ArchivedStickers",
    0x38641628: "types.messages.StickerSetInstallResultSuccess",
    0x35e410a8: "types.messages.StickerSetInstallResultArchive",
    0x6410a5d2: "types.StickerSetCovered",
    0x3407e51b: "types.StickerSetMultiCovered",
    0xaed6dbb2: "types.MaskCoords",
    0x4a992157: "types.InputStickeredMediaPhoto",
    0x0438865b: "types.InputStickeredMediaDocument",
    0xbdf9653b: "types.Game",
    0x032c3e77: "types.InputGameID",
    0xc331e80a: "types.InputGameShortName",
    0x58fffcd0: "types.HighScore",
    0x9a3bfd99: "types.messages.HighScores",
    0xdc3d824f: "types.TextEmpty",
    0x744694e0: "types.TextPlain",
    0x6724abc4: "types.TextBold",
    0xd912a59c: "types.TextItalic",
    0xc12622c4: "types.TextUnderline",
    0x9bf8bb95: "types.TextStrike",
    0x6c3f19b9: "types.TextFixed",
    0x3c2884c1: "types.TextUrl",
    0xde5a0dd6: "types.TextEmail",
    0x7e6260d7: "types.TextConcat",
    0x13567e8a: "types.PageBlockUnsupported",
    0x70abc3fd: "types.PageBlockTitle",
    0x8ffa9a1f: "types.PageBlockSubtitle",
    0xbaafe5e0: "types.PageBlockAuthorDate",
    0xbfd064ec: "types.PageBlockHeader",
    0xf12bb6e1: "types.PageBlockSubheader",
    0x467a0766: "types.PageBlockParagraph",
    0xc070d93e: "types.PageBlockPreformatted",
    0x48870999: "types.PageBlockFooter",
    0xdb20b188: "types.PageBlockDivider",
    0xce0d37b0: "types.PageBlockAnchor",
    0x3a58c7f4: "types.PageBlockList",
    0x263d7c26: "types.PageBlockBlockquote",
    0x4f4456d3: "types.PageBlockPullquote",
    0xe9c69982: "types.PageBlockPhoto",
    0xd9d71866: "types.PageBlockVideo",
    0x39f23300: "types.PageBlockCover",
    0xcde200d1: "types.PageBlockEmbed",
    0x292c7be9: "types.PageBlockEmbedPost",
    0x08b31c4f: "types.PageBlockCollage",
    0x130c8963: "types.PageBlockSlideshow",
    0xef1751b5: "types.PageBlockChannel",
    0x31b81a7f: "types.PageBlockAudio",
    0x8e3f9ebe: "types.PagePart",
    0x556ec7aa: "types.PageFull",
    0x85e42301: "types.PhoneCallDiscardReasonMissed",
    0xe095c1a0: "types.PhoneCallDiscardReasonDisconnect",
    0x57adc690: "types.PhoneCallDiscardReasonHangup",
    0xfaf7e8c9: "types.PhoneCallDiscardReasonBusy",
    0x7d748d04: "types.DataJSON",
    0xcb296bf8: "types.LabeledPrice",
    0xc30aa358: "types.Invoice",
    0xea02c27e: "types.PaymentCharge",
    0x1e8caaeb: "types.PostAddress",
    0x909c3f94: "types.PaymentRequestedInfo",
    0xcdc27a1f: "types.PaymentSavedCredentialsCard",
    0xc61acbd8: "types.WebDocument",
    0xf9c8bcc6: "types.WebDocumentNoProxy",
    0x9bed434d: "types.InputWebDocument",
    0xc239d686: "types.InputWebFileLocation",
    0x21e753bc: "types.upload.WebFile",
    0x3f56aea3: "types.payments.PaymentForm",
    0xd1451883: "types.payments.ValidatedRequestedInfo",
    0x4e5f810d: "types.payments.PaymentResult",
    0x6b56b921: "types.payments.PaymentVerficationNeeded",
    0x500911e1: "types.payments.PaymentReceipt",
    0xfb8fe43c: "types.payments.SavedInfo",
    0xc10eb2cf: "types.InputPaymentCredentialsSaved",
    0x3417d728: "types.InputPaymentCredentials",
    0x0aa1c39f: "types.InputPaymentCredentialsApplePay",
    0xca05d50e: "types.InputPaymentCredentialsAndroidPay",
    0xdb64fd34: "types.account.TmpPassword",
    0xb6213cdf: "types.ShippingOption",
    0xffa0a496: "types.InputStickerSetItem",
    0x1e36fded: "types.InputPhoneCall",
    0x5366c915: "types.PhoneCallEmpty",
    0x1b8f4ad1: "types.PhoneCallWaiting",
    0x83761ce4: "types.PhoneCallRequested",
    0x6d003d3f: "types.PhoneCallAccepted",
    0xffe6ab67: "types.PhoneCall",
    0x50ca4de1: "types.PhoneCallDiscarded",
    0x9d4c17c0: "types.PhoneConnection",
    0xa2bb35cb: "types.PhoneCallProtocol",
    0xec82e140: "types.phone.PhoneCall",
    0xeea8e46e: "types.upload.CdnFileReuploadNeeded",
    0xa99fca4f: "types.upload.CdnFile",
    0xc982eaba: "types.CdnPublicKey",
    0x5725e40a: "types.CdnConfig",
    0xcad181f6: "types.LangPackString",
    0x6c47ac9f: "types.LangPackStringPluralized",
    0x2979eeb2: "types.LangPackStringDeleted",
    0xf385c1f6: "types.LangPackDifference",
    0x117698f1: "types.LangPackLanguage",
    0x5d7ceba5: "types.ChannelAdminRights",
    0x58cf4249: "types.ChannelBannedRights",
    0xe6dfb825: "types.ChannelAdminLogEventActionChangeTitle",
    0x55188a2e: "types.ChannelAdminLogEventActionChangeAbout",
    0x6a4afc38: "types.ChannelAdminLogEventActionChangeUsername",
    0xb82f55c3: "types.ChannelAdminLogEventActionChangePhoto",
    0x1b7907ae: "types.ChannelAdminLogEventActionToggleInvites",
    0x26ae0971: "types.ChannelAdminLogEventActionToggleSignatures",
    0xe9e82c18: "types.ChannelAdminLogEventActionUpdatePinned",
    0x709b2405: "types.ChannelAdminLogEventActionEditMessage",
    0x42e047bb: "types.ChannelAdminLogEventActionDeleteMessage",
    0x183040d3: "types.ChannelAdminLogEventActionParticipantJoin",
    0xf89777f2: "types.ChannelAdminLogEventActionParticipantLeave",
    0xe31c34d8: "types.ChannelAdminLogEventActionParticipantInvite",
    0xe6d83d7e: "types.ChannelAdminLogEventActionParticipantToggleBan",
    0xd5676710: "types.ChannelAdminLogEventActionParticipantToggleAdmin",
    0xb1c3caa7: "types.ChannelAdminLogEventActionChangeStickerSet",
    0x5f5c95f1: "types.ChannelAdminLogEventActionTogglePreHistoryHidden",
    0x3b5a3e40: "types.ChannelAdminLogEvent",
    0xed8af74d: "types.channels.AdminLogResults",
    0xea107ae4: "types.ChannelAdminLogEventsFilter",
    0x5ce14175: "types.PopularContact",
    0x9e8fa6d3: "types.messages.FavedStickersNotModified",
    0xf37f2f16: "types.messages.FavedStickers",
    0x46e1d13d: "types.RecentMeUrlUnknown",
    0x8dbc3336: "types.RecentMeUrlUser",
    0xa01b22f9: "types.RecentMeUrlChat",
    0xeb49081d: "types.RecentMeUrlChatInvite",
    0xbc0a57dc: "types.RecentMeUrlStickerSet",
    0x0e0310d7: "types.help.RecentMeUrls",
    0x1cc6e91f: "types.InputSingleMedia",
    0xcac943f2: "types.WebAuthorization",
    0xed56c9fc: "types.account.WebAuthorizations",
    0xa676a322: "types.InputMessageID",
    0xbad88395: "types.InputMessageReplyTo",
    0x86872538: "types.InputMessagePinned",
    0xfcaafeb7: "types.InputDialogPeer",
    0xe56dbf05: "types.DialogPeer",
    0x0d54b65d: "types.messages.FoundStickerSetsNotModified",
    0x5108d648: "types.messages.FoundStickerSets",
    0x6242c773: "types.FileHash",
    0xcb9f372d: "functions.InvokeAfterMsg",
    0x3dc4b4f0: "functions.InvokeAfterMsgs",
    0xc7481da6: "functions.InitConnection",
    0xda9b0d0d: "functions.InvokeWithLayer",
    0xbf9459b7: "functions.InvokeWithoutUpdates",
    0x6fe51dfb: "functions.auth.CheckPhone",
    0x86aef0ec: "functions.auth.SendCode",
    0x1b067634: "functions.auth.SignUp",
    0xbcd51581: "functions.auth.SignIn",
    0x5717da40: "functions.auth.LogOut",
    0x9fab0d1a: "functions.auth.ResetAuthorizations",
    0x771c1d97: "functions.auth.SendInvites",
    0xe5bfffcd: "functions.auth.ExportAuthorization",
    0xe3ef9613: "functions.auth.ImportAuthorization",
    0xcdd42a05: "functions.auth.BindTempAuthKey",
    0x67a3ff2c: "functions.auth.ImportBotAuthorization",
    0x0a63011e: "functions.auth.CheckPassword",
    0xd897bc66: "functions.auth.RequestPasswordRecovery",
    0x4ea56e92: "functions.auth.RecoverPassword",
    0x3ef1a9bf: "functions.auth.ResendCode",
    0x1f040578: "functions.auth.CancelCode",
    0x8e48a188: "functions.auth.DropTempAuthKeys",
    0x5cbea590: "functions.account.RegisterDevice",
    0x3076c4bf: "functions.account.UnregisterDevice",
    0x84be5b93: "functions.account.UpdateNotifySettings",
    0x12b3ad31: "functions.account.GetNotifySettings",
    0xdb7e1747: "functions.account.ResetNotifySettings",
    0x78515775: "functions.account.UpdateProfile",
    0x6628562c: "functions.account.UpdateStatus",
    0xc04cfac2: "functions.account.GetWallPapers",
    0xae189d5f: "functions.account.ReportPeer",
    0x2714d86c: "functions.account.CheckUsername",
    0x3e0bdd7c: "functions.account.UpdateUsername",
    0xdadbc950: "functions.account.GetPrivacy",
    0xc9f81ce8: "functions.account.SetPrivacy",
    0x418d4e0b: "functions.account.DeleteAccount",
    0x08fc711d: "functions.account.GetAccountTTL",
    0x2442485e: "functions.account.SetAccountTTL",
    0x08e57deb: "functions.account.SendChangePhoneCode",
    0x70c32edb: "functions.account.ChangePhone",
    0x38df3532: "functions.account.UpdateDeviceLocked",
    0xe320c158: "functions.account.GetAuthorizations",
    0xdf77f3bc: "functions.account.ResetAuthorization",
    0x548a30f5: "functions.account.GetPassword",
    0xbc8d11bb: "functions.account.GetPasswordSettings",
    0xfa7c4b86: "functions.account.UpdatePasswordSettings",
    0x1516d7bd: "functions.account.SendConfirmPhoneCode",
    0x5f2178c3: "functions.account.ConfirmPhone",
    0x4a82327e: "functions.account.GetTmpPassword",
    0x182e6d6f: "functions.account.GetWebAuthorizations",
    0x2d01b9ef: "functions.account.ResetWebAuthorization",
    0x682d2594: "functions.account.ResetWebAuthorizations",
    0x0d91a548: "functions.users.GetUsers",
    0xca30a5b1: "functions.users.GetFullUser",
    0xc4a353ee: "functions.contacts.GetStatuses",
    0xc023849f: "functions.contacts.GetContacts",
    0x2c800be5: "functions.contacts.ImportContacts",
    0x8e953744: "functions.contacts.DeleteContact",
    0x59ab389e: "functions.contacts.DeleteContacts",
    0x332b49fc: "functions.contacts.Block",
    0xe54100bd: "functions.contacts.Unblock",
    0xf57c350f: "functions.contacts.GetBlocked",
    0x84e53737: "functions.contacts.ExportCard",
    0x4fe196fe: "functions.contacts.ImportCard",
    0x11f812d8: "functions.contacts.Search",
    0xf93ccba3: "functions.contacts.ResolveUsername",
    0xd4982db5: "functions.contacts.GetTopPeers",
    0x1ae373ac: "functions.contacts.ResetTopPeerRating",
    0x879537f1: "functions.contacts.ResetSaved",
    0x63c66506: "functions.messages.GetMessages",
    0x191ba9c5: "functions.messages.GetDialogs",
    0xdcbb8260: "functions.messages.GetHistory",
    0x8614ef68: "functions.messages.Search",
    0x0e306d3a: "functions.messages.ReadHistory",
    0x1c015b09: "functions.messages.DeleteHistory",
    0xe58e95d2: "functions.messages.DeleteMessages",
    0x05a954c0: "functions.messages.ReceivedMessages",
    0xa3825e50: "functions.messages.SetTyping",
    0xfa88427a: "functions.messages.SendMessage",
    0xb8d1262b: "functions.messages.SendMedia",
    0x708e0195: "functions.messages.ForwardMessages",
    0xcf1592db: "functions.messages.ReportSpam",
    0xa8f1709b: "functions.messages.HideReportSpam",
    0x3672e09c: "functions.messages.GetPeerSettings",
    0xbd82b658: "functions.messages.Report",
    0x3c6aa187: "functions.messages.GetChats",
    0x3b831c66: "functions.messages.GetFullChat",
    0xdc452855: "functions.messages.EditChatTitle",
    0xca4c79d8: "functions.messages.EditChatPhoto",
    0xf9a0aa09: "functions.messages.AddChatUser",
    0xe0611f16: "functions.messages.DeleteChatUser",
    0x09cb126e: "functions.messages.CreateChat",
    0x26cf8950: "functions.messages.GetDhConfig",
    0xf64daf43: "functions.messages.RequestEncryption",
    0x3dbc0415: "functions.messages.AcceptEncryption",
    0xedd923c5: "functions.messages.DiscardEncryption",
    0x791451ed: "functions.messages.SetEncryptedTyping",
    0x7f4b690a: "functions.messages.ReadEncryptedHistory",
    0xa9776773: "functions.messages.SendEncrypted",
    0x9a901b66: "functions.messages.SendEncryptedFile",
    0x32d439a4: "functions.messages.SendEncryptedService",
    0x55a5bb66: "functions.messages.ReceivedQueue",
    0x4b0c8c0f: "functions.messages.ReportEncryptedSpam",
    0x36a73f77: "functions.messages.ReadMessageContents",
    0x85cb5182: "functions.messages.GetStickers",
    0x1c9618b1: "functions.messages.GetAllStickers",
    0x8b68b0cc: "functions.messages.GetWebPagePreview",
    0x7d885289: "functions.messages.ExportChatInvite",
    0x3eadb1bb: "functions.messages.CheckChatInvite",
    0x6c50051c: "functions.messages.ImportChatInvite",
    0x2619a90e: "functions.messages.GetStickerSet",
    0xc78fe460: "functions.messages.InstallStickerSet",
    0xf96e55de: "functions.messages.UninstallStickerSet",
    0xe6df7378: "functions.messages.StartBot",
    0xc4c8a55d: "functions.messages.GetMessagesViews",
    0xec8bd9e1: "functions.messages.ToggleChatAdmins",
    0xa9e69f2e: "functions.messages.EditChatAdmin",
    0x15a3b8e3: "functions.messages.MigrateChat",
    0x9e3cacb0: "functions.messages.SearchGlobal",
    0x78337739: "functions.messages.ReorderStickerSets",
    0x338e2464: "functions.messages.GetDocumentByHash",
    0xbf9a776b: "functions.messages.SearchGifs",
    0x83bf3d52: "functions.messages.GetSavedGifs",
    0x327a30cb: "functions.messages.SaveGif",
    0x514e999d: "functions.messages.GetInlineBotResults",
    0xeb5ea206: "functions.messages.SetInlineBotResults",
    0xb16e06fe: "functions.messages.SendInlineBotResult",
    0xfda68d36: "functions.messages.GetMessageEditData",
    0x05d1b8dd: "functions.messages.EditMessage",
    0xb0e08243: "functions.messages.EditInlineBotMessage",
    0x810a9fec: "functions.messages.GetBotCallbackAnswer",
    0xd58f130a: "functions.messages.SetBotCallbackAnswer",
    0xe470bcfd: "functions.messages.GetPeerDialogs",
    0xbc39e14b: "functions.messages.SaveDraft",
    0x6a3f8d65: "functions.messages.GetAllDrafts",
    0x2dacca4f: "functions.messages.GetFeaturedStickers",
    0x5b118126: "functions.messages.ReadFeaturedStickers",
    0x5ea192c9: "functions.messages.GetRecentStickers",
    0x392718f8: "functions.messages.SaveRecentSticker",
    0x8999602d: "functions.messages.ClearRecentStickers",
    0x57f17692: "functions.messages.GetArchivedStickers",
    0x65b8c79f: "functions.messages.GetMaskStickers",
    0xcc5b67cc: "functions.messages.GetAttachedStickers",
    0x8ef8ecc0: "functions.messages.SetGameScore",
    0x15ad9f64: "functions.messages.SetInlineGameScore",
    0xe822649d: "functions.messages.GetGameHighScores",
    0x0f635e1b: "functions.messages.GetInlineGameHighScores",
    0x0d0a48c4: "functions.messages.GetCommonChats",
    0xeba80ff0: "functions.messages.GetAllChats",
    0x32ca8f91: "functions.messages.GetWebPage",
    0xa731e257: "functions.messages.ToggleDialogPin",
    0x5b51d63f: "functions.messages.ReorderPinnedDialogs",
    0xe254d64e: "functions.messages.GetPinnedDialogs",
    0xe5f672fa: "functions.messages.SetBotShippingResults",
    0x09c2dd95: "functions.messages.SetBotPrecheckoutResults",
    0x519bc2b1: "functions.messages.UploadMedia",
    0xc97df020: "functions.messages.SendScreenshotNotification",
    0x21ce0b0e: "functions.messages.GetFavedStickers",
    0xb9ffc55b: "functions.messages.FaveSticker",
    0x46578472: "functions.messages.GetUnreadMentions",
    0x0f0189d3: "functions.messages.ReadMentions",
    0xbbc45b09: "functions.messages.GetRecentLocations",
    0x2095512f: "functions.messages.SendMultiMedia",
    0x5057c497: "functions.messages.UploadEncryptedFile",
    0xc2b7d08b: "functions.messages.SearchStickerSets",
    0xedd4882a: "functions.updates.GetState",
    0x25939651: "functions.updates.GetDifference",
    0x03173d78: "functions.updates.GetChannelDifference",
    0xf0bb5152: "functions.photos.UpdateProfilePhoto",
    0x4f32c098: "functions.photos.UploadProfilePhoto",
    0x87cf7f2f: "functions.photos.DeletePhotos",
    0x91cd32a8: "functions.photos.GetUserPhotos",
    0xb304a621: "functions.upload.SaveFilePart",
    0xe3a6cfb5: "functions.upload.GetFile",
    0xde7b673d: "functions.upload.SaveBigFilePart",
    0x24e6818d: "functions.upload.GetWebFile",
    0x2000bcc3: "functions.upload.GetCdnFile",
    0x9b2754a8: "functions.upload.ReuploadCdnFile",
    0x4da54231: "functions.upload.GetCdnFileHashes",
    0xc7025931: "functions.upload.GetFileHashes",
    0xc4f9186b: "functions.help.GetConfig",
    0x1fb33026: "functions.help.GetNearestDc",
    0xae2de196: "functions.help.GetAppUpdate",
    0x6f02f748: "functions.help.SaveAppLog",
    0x4d392343: "functions.help.GetInviteText",
    0x9cdf08cd: "functions.help.GetSupport",
    0x9010ef6f: "functions.help.GetAppChangelog",
    0x350170f3: "functions.help.GetTermsOfService",
    0xec22cfcd: "functions.help.SetBotUpdatesStatus",
    0x52029342: "functions.help.GetCdnConfig",
    0x3dc0f114: "functions.help.GetRecentMeUrls",
    0xcc104937: "functions.channels.ReadHistory",
    0x84c1fd4e: "functions.channels.DeleteMessages",
    0xd10dd71b: "functions.channels.DeleteUserHistory",
    0xfe087810: "functions.channels.ReportSpam",
    0xad8c9a23: "functions.channels.GetMessages",
    0x123e05e9: "functions.channels.GetParticipants",
    0x546dd7a6: "functions.channels.GetParticipant",
    0x0a7f6bbb: "functions.channels.GetChannels",
    0x08736a09: "functions.channels.GetFullChannel",
    0xf4893d7f: "functions.channels.CreateChannel",
    0x13e27f1e: "functions.channels.EditAbout",
    0x20b88214: "functions.channels.EditAdmin",
    0x566decd0: "functions.channels.EditTitle",
    0xf12e57c9: "functions.channels.EditPhoto",
    0x10e6bd2c: "functions.channels.CheckUsername",
    0x3514b3de: "functions.channels.UpdateUsername",
    0x24b524c5: "functions.channels.JoinChannel",
    0xf836aa95: "functions.channels.LeaveChannel",
    0x199f3a6c: "functions.channels.InviteToChannel",
    0xc7560885: "functions.channels.ExportInvite",
    0xc0111fe3: "functions.channels.DeleteChannel",
    0x49609307: "functions.channels.ToggleInvites",
    0xceb77163: "functions.channels.ExportMessageLink",
    0x1f69b606: "functions.channels.ToggleSignatures",
    0xa72ded52: "functions.channels.UpdatePinnedMessage",
    0x8d8d82d7: "functions.channels.GetAdminedPublicChannels",
    0xbfd915cd: "functions.channels.EditBanned",
    0x33ddf480: "functions.channels.GetAdminLog",
    0xea8ca4f9: "functions.channels.SetStickers",
    0xeab5dc38: "functions.channels.ReadMessageContents",
    0xaf369d42: "functions.channels.DeleteHistory",
    0xeabbb94c: "functions.channels.TogglePreHistoryHidden",
    0xaa2769ed: "functions.bots.SendCustomRequest",
    0xe6213f4d: "functions.bots.AnswerWebhookJSONQuery",
    0x99f09745: "functions.payments.GetPaymentForm",
    0xa092a980: "functions.payments.GetPaymentReceipt",
    0x770a8e74: "functions.payments.ValidateRequestedInfo",
    0x2b8879b3: "functions.payments.SendPaymentForm",
    0x227d824b: "functions.payments.GetSavedInfo",
    0xd83d70c1: "functions.payments.ClearSavedInfo",
    0x9bd86e6a: "functions.stickers.CreateStickerSet",
    0xf7760f51: "functions.stickers.RemoveStickerFromSet",
    0xffb6d4ca: "functions.stickers.ChangeStickerPosition",
    0x8653febe: "functions.stickers.AddStickerToSet",
    0x55451fa9: "functions.phone.GetCallConfig",
    0x5b95b3d4: "functions.phone.RequestCall",
    0x3bd2b4a0: "functions.phone.AcceptCall",
    0x2efe1722: "functions.phone.ConfirmCall",
    0x17d54f61: "functions.phone.ReceivedCall",
    0x78d413a6: "functions.phone.DiscardCall",
    0x1c536a34: "functions.phone.SetCallRating",
    0x277add7e: "functions.phone.SaveCallDebug",
    0x9ab5c58e: "functions.langpack.GetLangPack",
    0x2e1ee318: "functions.langpack.GetStrings",
    0x0b2e4d7d: "functions.langpack.GetDifference",
    0x800fd57d: "functions.langpack.GetLanguages",
    0xb0700000: "types.pyrogram.Update",
    0xb0700001: "types.pyrogram.User",
    0xb0700002: "types.pyrogram.Chat",
    0xb0700003: "types.pyrogram.Message",
    0xb0700004: "types.pyrogram.MessageEntity",
    0xb0700005: "types.pyrogram.PhotoSize",
    0xb0700006: "types.pyrogram.Audio",
    0xb0700007: "types.pyrogram.Document",
    0xb0700008: "types.pyrogram.Video",
    0xb0700009: "types.pyrogram.Voice",
    0xb0700010: "types.pyrogram.VideoNote",
    0xb0700011: "types.pyrogram.Contact",
    0xb0700012: "types.pyrogram.Location",
    0xb0700013: "types.pyrogram.Venue",
    0xb0700014: "types.pyrogram.UserProfilePhotos",
    0xb0700015: "types.pyrogram.ChatPhoto",
    0xb0700016: "types.pyrogram.ChatMember",
    0xb0700017: "types.pyrogram.Sticker",
    0xbc799737: "core.BoolFalse",
    0x997275b5: "core.BoolTrue",
    0x56730bcc: "core.Null",
    0x1cb5c415: "core.Vector",
    0x73f1f8dc: "core.MsgContainer",
    0xae500895: "core.FutureSalts",
    0x0949d9dc: "core.FutureSalt",
    0x3072cfa1: "core.GzipPacked",
    0x5bb8e511: "core.Message"
}
