# -*- coding: utf-8 -*-
"""ECHK_20250327_00.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1DIgEbQKaosoPpTsPe_Zr78QVH7SpiLbv

# EnvironmentChecker
仮想環境ないの各種パッケージとCUDA情報をチェックするクラス


```
2025/03/27 0.1.0 完成
```

# EnvironmentChecker

## 1. モジュール定義
"""

# @title a. EnvironmentChecker 定義
import subprocess
import pkg_resources

class EnvironmentChecker:
    """
    仮想環境内の各種パッケージとCUDA情報をチェックするクラス。

    チェック内容:
      - PyTorch がビルドされた CUDA バージョンの確認
      - conda での cudatoolkit の確認
      - xformers、bitsandbytes、torch のバージョンチェック
    """

    def __init__(self):
        pass

    def check_cuda_version(self):
        """PyTorch の CUDA バージョンと conda list での cudatoolkit を確認する"""
        # PyTorch の場合
        try:
            import torch
            cuda_version = torch.version.cuda
            if cuda_version:
                print(f"PyTorch のビルドされた CUDA バージョン: {cuda_version}")
            else:
                print("PyTorch はインストールされていますが、CUDA バージョンが取得できませんでした。")
        except ImportError:
            print("PyTorch がインストールされていません。")

        # conda での cudatoolkit の確認（実行環境で conda コマンドが利用可能な場合）
        try:
            result = subprocess.run(["conda", "list", "cudatoolkit"],
                                    capture_output=True, text=True, check=True)
            print("conda list cudatoolkit の結果:")
            print(result.stdout)
        except Exception as e:
            print("conda コマンドで cudatoolkit のチェックに失敗しました:", e)

    def check_package(self, package_name):
        """指定したパッケージのバージョン情報を表示する"""
        try:
            version = pkg_resources.get_distribution(package_name).version
            print(f"{package_name}: {version}")
        except pkg_resources.DistributionNotFound:
            print(f"{package_name} はインストールされていません。")

    def check_xformers(self):
        """xformers のバージョン情報をチェックする"""
        self.check_package("xformers")

    def check_bitsandbytes(self):
        """bitsandbytes のバージョン情報をチェックする"""
        self.check_package("bitsandbytes")

    def check_pytorch(self):
        """PyTorch (torch) のバージョン情報をチェックする"""
        self.check_package("torch")

    def check_all(self):
        """すべてのチェック項目をまとめて実行する"""
        print("=== 環境チェック開始 ===")
        self.check_cuda_version()
        self.check_xformers()
        self.check_bitsandbytes()
        self.check_pytorch()
        print("=== 環境チェック完了 ===")


# 使用例
if __name__ == "__main__":
    checker = EnvironmentChecker()
    checker.check_all()