class e{constructor(){this.eventViewer=null,this.moduleViewer=null,this.sessionManager=null,this.activityTreeRetryCount=0,this.maxRetryAttempts=10,this.socketManager=null,this.agentInference=null,this.agentHierarchy=null,this.uiStateManager=null,this.eventProcessor=null,this.exportManager=null,this.workingDirectoryManager=null,this.fileToolTracker=null,this.buildTracker=null,this.init()}init(){console.log("Initializing refactored Claude MPM Dashboard...");try{this.fetchServerConfig(),this.initializeSocketManager(),this.initializeCoreComponents(),this.initializeBuildTracker(),this.initializeAgentInference(),this.initializeAgentHierarchy(),this.initializeUIStateManager(),this.initializeWorkingDirectoryManager(),this.initializeFileToolTracker(),this.initializeEventProcessor(),this.initializeExportManager(),this.setupModuleInteractions(),this.initializeFromURL(),console.log("Claude MPM Dashboard initialized successfully")}catch(e){throw console.error("Error during dashboard initialization:",e),e}}fetchServerConfig(){fetch("/api/config").then(e=>e.json()).then(e=>{window.dashboardConfig=e;const t=document.getElementById("working-dir-path");t&&e.workingDirectory&&(t.textContent=e.workingDirectory);const n=document.getElementById("footer-git-branch");n&&e.gitBranch&&(n.textContent=e.gitBranch),console.log("Dashboard configuration loaded:",e)}).catch(e=>{console.warn("Failed to fetch server config:",e),window.dashboardConfig={workingDirectory:".",gitBranch:"Unknown"}})}validateInitialization(){const e=[{name:"socketManager",component:this.socketManager},{name:"eventViewer",component:this.eventViewer},{name:"agentHierarchy",component:this.agentHierarchy}].filter(e=>!e.component);e.length>0&&console.warn("Missing critical components:",e.map(e=>e.name))}postInit(){try{this.agentHierarchy&&(window.dashboard.agentHierarchy=this.agentHierarchy),this.validateInitialization()}catch(e){console.error("Error in dashboard postInit:",e)}}initializeSocketManager(){this.socketManager=new SocketManager,this.socketManager.setupConnectionControls(),this.socketClient=this.socketManager.getSocketClient(),window.socketClient=this.socketClient}initializeCoreComponents(){this.eventViewer=new EventViewer("events-list",this.socketClient),this.moduleViewer=new ModuleViewer,this.sessionManager=new SessionManager(this.socketClient),window.eventViewer=this.eventViewer,window.moduleViewer=this.moduleViewer,window.sessionManager=this.sessionManager}initializeBuildTracker(){this.buildTracker=new BuildTracker,this.buildTracker.setSocketClient(this.socketClient);const e=()=>{const t=document.querySelector(".header-title");t?(this.buildTracker.mount(t),console.log("BuildTracker mounted successfully")):(console.warn("Header-title element not found for build tracker, will retry"),setTimeout(e,100))};e(),window.buildTracker=this.buildTracker}initializeAgentInference(){this.agentInference=new AgentInference(this.eventViewer),this.agentInference.initialize()}initializeAgentHierarchy(){try{this.agentHierarchy=new AgentHierarchy(this.agentInference,this.eventViewer)}catch(e){console.error("Failed to initialize agent hierarchy:",e),this.agentHierarchy={render:()=>'<div class="error">Agent hierarchy unavailable</div>',expandAllNodes:()=>{},collapseAllNodes:()=>{},updateWithNewEvents:()=>{}}}}initializeUIStateManager(){this.uiStateManager=new UIStateManager,this.setupTabFilters()}initializeWorkingDirectoryManager(){this.workingDirectoryManager=new WorkingDirectoryManager(this.socketManager)}initializeFileToolTracker(){this.fileToolTracker=new FileToolTracker(this.agentInference,this.workingDirectoryManager)}initializeEventProcessor(){this.eventProcessor=new EventProcessor(this.eventViewer,this.agentInference)}initializeExportManager(){this.exportManager=new ExportManager(this.eventViewer)}setupModuleInteractions(){this.socketManager.onEventUpdate(e=>{console.log("[Dashboard] Processing event update with",e.length,"events"),e.length>0&&console.log("[Dashboard] Sample event structure:",{first_event:e[0],has_tool_events:e.some(e=>e.tool_name||e.data&&e.data.tool_name),hook_events:e.filter(e=>"hook"===e.type).length,tool_subtypes:e.filter(e=>"pre_tool"===e.subtype||"post_tool"===e.subtype).length}),this.fileToolTracker.updateFileOperations(e),this.fileToolTracker.updateToolCalls(e);const t=this.fileToolTracker.getFileOperations(),n=this.fileToolTracker.getToolCalls();console.log("[Dashboard] After update - File operations:",t.size,"Tool calls:",n.size),this.agentInference.processAgentInference(),window.CodeViewer&&"function"==typeof window.CodeViewer.refreshFromFileToolTracker&&setTimeout(()=>{window.CodeViewer.refreshFromFileToolTracker()},50),this.agentHierarchy.updateWithNewEvents(e),"events"===this.uiStateManager.getCurrentTab()&&this.exportManager.scrollListToBottom("events-list"),this.renderCurrentTab()}),this.socketManager.onConnectionStatusChange((e,t)=>{"connected"===t&&this.workingDirectoryManager.updateGitBranch(this.workingDirectoryManager.getCurrentWorkingDir())}),document.addEventListener("tabChanged",e=>{this.renderCurrentTab(),this.uiStateManager.updateTabNavigationItems()}),document.addEventListener("eventsClearing",()=>{this.fileToolTracker.clear(),this.agentInference.initialize()}),document.addEventListener("showCardDetails",e=>{this.showCardDetails(e.detail.tabName,e.detail.index)}),document.addEventListener("sessionFilterChanged",e=>{this.renderCurrentTab()})}setupTabFilters(){const e=document.getElementById("agents-search-input"),t=document.getElementById("agents-type-filter");e&&e.addEventListener("input",()=>{"agents"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()}),t&&t.addEventListener("change",()=>{"agents"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()});const n=document.getElementById("tools-search-input"),i=document.getElementById("tools-type-filter");n&&n.addEventListener("input",()=>{"tools"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()}),i&&i.addEventListener("change",()=>{"tools"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()});const o=document.getElementById("files-search-input"),r=document.getElementById("files-type-filter");o&&o.addEventListener("input",()=>{"files"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()}),r&&r.addEventListener("change",()=>{"files"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()})}initializeFromURL(){const e=new URLSearchParams(window.location.search);this.socketManager.initializeFromURL(e)}renderCurrentTab(){const e=this.uiStateManager.getCurrentTab();switch(e){case"events":break;case"claude-tree":window.CodeViewer&&"function"==typeof window.CodeViewer.show&&window.CodeViewer.show();break;case"activity":if(window.ActivityTree&&"function"==typeof window.ActivityTree)this.activityTreeRetryCount=0,window.activityTreeInstance||(window.activityTreeInstance=new window.ActivityTree),window.activityTreeInstance&&(window.activityTreeInstance.initialized||window.activityTreeInstance.initialize(),"function"==typeof window.activityTreeInstance.renderWhenVisible&&window.activityTreeInstance.renderWhenVisible(),"function"==typeof window.activityTreeInstance.forceShow&&window.activityTreeInstance.forceShow());else if(window.activityTree&&"function"==typeof window.activityTree){const e=window.activityTree();e&&("function"==typeof e.renderWhenVisible&&e.renderWhenVisible(),"function"==typeof e.forceShow&&e.forceShow())}else if(this.activityTreeRetryCount<this.maxRetryAttempts)this.activityTreeRetryCount++,console.warn(`Activity tree component not available, retrying in 100ms... (attempt ${this.activityTreeRetryCount}/${this.maxRetryAttempts})`),setTimeout(()=>{"activity"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()},100);else{console.error("Maximum retry attempts reached for ActivityTree initialization. Giving up.");const e=document.getElementById("activity-tree-container")||document.getElementById("activity-tree");e&&(e.innerHTML='<div class="error-message">⚠️ Activity Tree failed to load. Please refresh the page.</div>')}break;case"agents":this.renderAgents();break;case"tools":this.renderTools();break;case"files":this.renderFiles()}this.uiStateManager.getSelectedCard().tab===e&&this.uiStateManager.updateCardSelectionUI(),this.uiStateManager.updateUnifiedSelectionUI()}renderAgents(){const e=document.getElementById("agents-list");if(!e)return;const t=document.getElementById("agents-search-input")?.value||"",n=document.getElementById("agents-type-filter")?.value||"",i=this.renderAgentsFlat(t,n);e.innerHTML=i,this.removeHierarchyControls();const o=this.agentInference.getUniqueAgentInstances();this.updateAgentsFilterDropdowns(o)}removeHierarchyControls(){const e=document.getElementById("hierarchy-controls");e&&e.remove()}renderAgentsFlat(e,t){const n=this.eventViewer.events;if(!n||0===n.length)return'<div class="no-events">No agent events found...</div>';this.agentInference.processAgentInference();const i=this.agentInference.getEventAgentMap(),o=[];if(n.forEach((n,r)=>{const s=i.get(r);if(s&&("subagent"===s.type||"main_agent"===s.type)){let i=!0;if(e){const t=e.toLowerCase();i=i&&(s.agentName.toLowerCase().includes(t)||n.tool_name&&n.tool_name.toLowerCase().includes(t)||n.data&&JSON.stringify(n.data).toLowerCase().includes(t))}t&&(i=i&&s.agentName.includes(t)),i&&o.push({event:n,inference:s,index:r,timestamp:new Date(n.timestamp)})}}),0===o.length)return'<div class="no-events">No agent events match the current filters...</div>';return`<div class="agent-events-flat">${o.map((e,t)=>{const{event:n,inference:i,index:o,timestamp:r}=e;let s="Activity",a="📋",l="";if("SubagentStart"===n.event_type)s="Started",a="🟢",l="Agent session began";else if("SubagentStop"===n.event_type)s="Stopped",a="🔴",l="Agent session ended";else if(n.tool_name&&(s=`Tool: ${n.tool_name}`,a=this.getToolIcon(n.tool_name),n.data&&n.data.tool_parameters)){const e=n.data.tool_parameters;e.file_path?l=e.file_path:e.command?l=e.command.substring(0,50)+(e.command.length>50?"...":""):e.pattern?l=`pattern="${e.pattern}"`:e.query&&(l=`query="${e.query}"`)}let c="completed";return"SubagentStart"===n.event_type?c="active":n.data&&n.data.error&&(c="error"),`\n                <div class="agent-event-item" data-index="${t}" onclick="window.dashboard.showCardDetails('agents', ${o})">\n                    <div class="agent-event-header">\n                        <div class="agent-event-time">${this.formatTimestamp(r)}</div>\n                        <div class="agent-event-agent">\n                            ${this.getAgentIcon(i.agentName)} ${i.agentName}\n                        </div>\n                        <div class="agent-event-action">\n                            ${a} ${s}\n                        </div>\n                        <div class="agent-event-status status-${c}">\n                            ${this.getStatusIcon(c)}\n                        </div>\n                    </div>\n                    ${l?`<div class="agent-event-details">${this.escapeHtml(l)}</div>`:""}\n                </div>\n            `}).join("")}</div>`}getAgentIcon(e){return{PM:"🎯","Engineer Agent":"🔧","Research Agent":"🔍","QA Agent":"✅","Documentation Agent":"📝","Security Agent":"🔒","Ops Agent":"⚙️","Version Control Agent":"📦","Data Engineer Agent":"💾","Test Integration Agent":"🧪"}[e]||"🤖"}getToolIcon(e){return{Read:"📖",Write:"✏️",Edit:"📝",Bash:"💻",Grep:"🔍",Glob:"📂",LS:"📁",Task:"📋"}[e]||"🔧"}getStatusIcon(e){return{active:"🟢",completed:"✅",error:"❌",pending:"🟡"}[e]||"❓"}formatTimestamp(e){return e.toLocaleTimeString("en-US",{hour:"2-digit",minute:"2-digit",second:"2-digit",hour12:!1})}escapeHtml(e){if(!e)return"";const t=document.createElement("div");return t.textContent=e,t.innerHTML}renderTools(){const e=document.getElementById("tools-list");if(!e)return;const t=this.fileToolTracker.getToolCalls(),n=Array.from(t.entries()),i=this.eventProcessor.getUniqueToolInstances(n),o=this.eventProcessor.generateToolHTML(i);e.innerHTML=o,this.exportManager.scrollListToBottom("tools-list"),this.updateToolsFilterDropdowns(i)}renderFiles(){const e=document.getElementById("files-list");if(!e)return;const t=this.fileToolTracker.getFileOperations(),n=Array.from(t.entries());console.log("[renderFiles] File operations map size:",t.size),console.log("[renderFiles] Files array:",n);const i=this.eventProcessor.getUniqueFileInstances(n),o=this.eventProcessor.generateFileHTML(i);0===n.length?e.innerHTML='<div class="empty-state">No file operations tracked yet. File operations will appear here when tools like Read, Write, Edit, or Grep are used.</div>':e.innerHTML=o,this.exportManager.scrollListToBottom("files-list"),this.updateFilesFilterDropdowns(n)}updateAgentsFilterDropdowns(e){const t=new Set;e.forEach(e=>{e.agentName&&"Unknown"!==e.agentName&&t.add(e.agentName)});const n=Array.from(t).filter(e=>e&&""!==e.trim());this.populateFilterDropdown("agents-type-filter",n,"All Agent Types")}updateToolsFilterDropdowns(e){const t=[...new Set(e.map(([e,t])=>t.tool_name))].filter(e=>e);this.populateFilterDropdown("tools-type-filter",t,"All Tools")}updateFilesFilterDropdowns(e){const t=[...new Set(e.flatMap(([e,t])=>t.operations.map(e=>e.operation)))].filter(e=>e);this.populateFilterDropdown("files-type-filter",t,"All Operations")}populateFilterDropdown(e,t,n="All"){const i=document.getElementById(e);if(!i)return;const o=i.value,r=t.sort((e,t)=>e.localeCompare(t));i.innerHTML=`<option value="">${n}</option>`,r.forEach(e=>{const t=document.createElement("option");t.value=e,t.textContent=e,i.appendChild(t)}),o&&r.includes(o)&&(i.value=o)}showCardDetails(e,t){switch(e){case"events":this.eventViewer&&this.eventViewer.showEventDetails(t);break;case"agents":this.showAgentDetailsByIndex(t);break;case"tools":this.showToolDetailsByIndex(t);break;case"files":this.showFileDetailsByIndex(t)}}showAgentDetailsByIndex(e){const t=this.eventProcessor.getFilteredEventsForTab("agents");if(!t||!Array.isArray(t)||e<0||e>=t.length)return void console.warn("Dashboard: Invalid agent index or events array");const n=this.eventProcessor.applyAgentsFilters([t[e]]);if(n.length>0&&this.moduleViewer&&"function"==typeof this.moduleViewer.showAgentEvent){const t=n[0];this.moduleViewer.showAgentEvent(t,e)}}showAgentInstanceDetails(e){const t=this.agentInference.getPMDelegations().get(e);if(!t){const t=this.agentInference.getUniqueAgentInstances().find(t=>t.id===e);return t?void this.showImpliedAgentDetails(t):void console.error("Agent instance not found:",e)}this.moduleViewer&&"function"==typeof this.moduleViewer.showAgentInstance?this.moduleViewer.showAgentInstance(t):console.log("Agent Instance Details:",{id:e,agentName:t.agentName,type:"PM Delegation",eventCount:t.agentEvents.length,startTime:t.timestamp,pmCall:t.pmCall})}showImpliedAgentDetails(e){this.moduleViewer&&"function"==typeof this.moduleViewer.showImpliedAgent?this.moduleViewer.showImpliedAgent(e):console.log("Implied Agent Details:",{id:e.id,agentName:e.agentName,type:"Implied PM Delegation",eventCount:e.eventCount,startTime:e.timestamp,note:"No explicit PM call found - inferred from agent activity"})}showToolDetailsByIndex(e){const t=this.fileToolTracker.getToolCalls(),n=Array.from(t.entries()),i=this.eventProcessor.applyToolCallFilters(n);if(e>=0&&e<i.length){const[t]=i[e];this.showToolCallDetails(t)}}showFileDetailsByIndex(e){const t=this.fileToolTracker.getFileOperations();let n=Array.from(t.entries());if(n=this.eventProcessor.applyFilesFilters(n),e>=0&&e<n.length){const[t]=n[e];this.showFileDetails(t)}}showToolCallDetails(e){const t=this.fileToolTracker.getToolCall(e);t&&this.moduleViewer&&this.moduleViewer.showToolCall(t,e)}showFileDetails(e){const t=this.fileToolTracker.getFileOperationsForFile(e);t&&this.moduleViewer&&this.moduleViewer.showFileOperations(t,e)}switchTab(e){this.uiStateManager.switchTab(e)}selectCard(e,t,n,i){this.uiStateManager.selectCard(e,t,n,i)}clearEvents(){this.exportManager.clearEvents()}exportEvents(){this.exportManager.exportEvents()}clearSelection(){this.uiStateManager.clearSelection(),this.eventViewer&&this.eventViewer.clearSelection(),this.moduleViewer&&this.moduleViewer.clear()}get currentWorkingDir(){return this.workingDirectoryManager.getCurrentWorkingDir()}set currentWorkingDir(e){this.workingDirectoryManager.setWorkingDirectory(e)}get currentTab(){return this.uiStateManager.getCurrentTab()}get selectedCard(){return this.uiStateManager.getSelectedCard()}get fileOperations(){return this.fileToolTracker.getFileOperations()}get toolCalls(){return this.fileToolTracker.getToolCalls()}get tabNavigation(){return this.uiStateManager?this.uiStateManager.tabNavigation:null}}async function t(e,t,i){const o=e.querySelector(".file-viewer-file-path"),r=e.querySelector(".file-viewer-file-size");o&&(o.textContent=t),r&&(r.textContent="");const s=e.querySelector(".file-viewer-loading"),a=e.querySelector(".file-viewer-error"),l=e.querySelector(".file-viewer-content-area");s&&(s.style.display="flex"),a&&(a.style.display="none"),l&&(l.style.display="none");try{const o=window.socket||window.dashboard?.socketClient?.socket||window.socketClient?.socket;if(console.log("[FileViewer] Socket search results:",{"window.socket":!!window.socket,"window.socket.connected":window.socket?.connected,"dashboard.socketClient.socket":!!window.dashboard?.socketClient?.socket,"dashboard.socketClient.socket.connected":window.dashboard?.socketClient?.socket?.connected,"window.socketClient.socket":!!window.socketClient?.socket,"window.socketClient.socket.connected":window.socketClient?.socket?.connected}),!o)throw new Error("No socket connection available. Please ensure the dashboard is connected.");o.connected||console.warn("[FileViewer] Socket found but not connected, attempting to use anyway..."),console.log("[FileViewer] Socket found, setting up listener for file_content_response");const r=new Promise((e,n)=>{const i=r=>{console.log("[FileViewer] Received file_content_response:",r),r.file_path===t&&(o.off("file_content_response",i),r.success?(console.log("[FileViewer] File content loaded successfully"),e(r)):(console.error("[FileViewer] File read failed:",r.error),n(new Error(r.error||"Failed to read file"))))};o.on("file_content_response",i),console.log("[FileViewer] Listener registered for file_content_response"),setTimeout(()=>{o.off("file_content_response",i),console.error("[FileViewer] Request timeout after 10 seconds"),n(new Error("Request timeout - server did not respond"))},1e4)}),s={file_path:t,working_dir:i};console.log("[FileViewer] Emitting read_file event with data:",s),o.emit("read_file",s);const a=await r,l=e.querySelector(".file-viewer-loading");l&&(l.style.display="none"),function(e,t){const i=e.querySelector(".file-viewer-content-area"),o=e.querySelector(".file-extension"),r=e.querySelector(".file-encoding"),s=e.querySelector(".file-viewer-file-size"),a=e.querySelector(".file-content-code");o&&(o.textContent=`Type: ${t.extension||"unknown"}`);r&&(r.textContent=`Encoding: ${t.encoding||"unknown"}`);s&&(s.textContent=`Size: ${function(e){if(!e)return"0 B";const t=1024,n=["B","KB","MB","GB"],i=Math.floor(Math.log(e)/Math.log(t));return parseFloat((e/Math.pow(t,i)).toFixed(2))+" "+n[i]}(t.file_size)}`);if(a&&t.content){a.innerHTML=function(e,t){const i=e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");switch(t){case".js":case".jsx":case".ts":case".tsx":return function(e){return n(e.replace(/\b(function|const|let|var|if|else|for|while|return|import|export|class|extends)\b/g,'<span class="keyword">$1</span>').replace(/(\/\*[\s\S]*?\*\/|\/\/.*)/g,'<span class="comment">$1</span>').replace(/('[^']*'|"[^"]*"|`[^`]*`)/g,'<span class="string">$1</span>').replace(/\b(\d+)\b/g,'<span class="number">$1</span>'))}(i);case".py":return function(e){return n(e.replace(/\b(def|class|if|elif|else|for|while|return|import|from|as|try|except|finally|with)\b/g,'<span class="keyword">$1</span>').replace(/(#.*)/g,'<span class="comment">$1</span>').replace(/('[^']*'|"[^"]*"|"""[\s\S]*?""")/g,'<span class="string">$1</span>').replace(/\b(\d+)\b/g,'<span class="number">$1</span>'))}(i);case".json":return function(e){return n(e.replace(/("[\w\s]*")\s*:/g,'<span class="property">$1</span>:').replace(/:\s*(".*?")/g,': <span class="string">$1</span>').replace(/:\s*(\d+)/g,': <span class="number">$1</span>').replace(/:\s*(true|false|null)/g,': <span class="keyword">$1</span>'))}(i);case".css":return function(e){return n(e.replace(/([.#]?[\w-]+)\s*\{/g,'<span class="selector">$1</span> {').replace(/([\w-]+)\s*:/g,'<span class="property">$1</span>:').replace(/:\s*([^;]+);/g,': <span class="value">$1</span>;').replace(/(\/\*[\s\S]*?\*\/)/g,'<span class="comment">$1</span>'))}(i);case".html":case".htm":return function(e){return n(e.replace(/(&lt;\/?[\w-]+)/g,'<span class="tag">$1</span>').replace(/([\w-]+)=(['"][^'"]*['"])/g,'<span class="attribute">$1</span>=<span class="string">$2</span>').replace(/(&lt;!--[\s\S]*?--&gt;)/g,'<span class="comment">$1</span>'))}(i);case".md":case".markdown":return function(e){return n(e.replace(/^(#{1,6})\s+(.*)$/gm,'<span class="header">$1</span> <span class="header-text">$2</span>').replace(/\*\*(.*?)\*\*/g,'<span class="bold">**$1**</span>').replace(/\*(.*?)\*/g,'<span class="italic">*$1*</span>').replace(/`([^`]+)`/g,'<span class="code">`$1`</span>').replace(/^\s*[-*+]\s+(.*)$/gm,'<span class="list-marker">•</span> $1'))}(i);default:return n(i)}}(t.content,t.extension);const i=e.querySelector(".file-viewer-scroll-wrapper");i&&setTimeout(()=>{const t=e.querySelector(".modal-content"),n=e.querySelector(".file-viewer-header"),o=e.querySelector(".file-viewer-toolbar"),r=(t?.offsetHeight||0)-(n?.offsetHeight||0)-(o?.offsetHeight||0)-40;i.style.maxHeight=`${r}px`,i.style.overflowY="auto"},50)}else console.warn("⚠️ Missing codeElement or file content");i&&(i.style.display="block")}(e,a)}catch(c){console.error("❌ Failed to fetch file content:",c);const n=e.querySelector(".file-viewer-loading");n&&(n.style.display="none");let o=c.message||"Unknown error occurred",r=[];c.message.includes("No socket connection")?(o="Failed to connect to the monitoring server",r=["Check if the monitoring server is running","Verify the socket connection in the dashboard","Try refreshing the page and reconnecting"]):c.message.includes("timeout")?(o="Request timed out",r=["The file may be too large to load quickly","Check your network connection","Try again in a few moments"]):c.message.includes("File does not exist")?(o="File not found",r=["The file may have been moved or deleted","Check the file path spelling","Refresh the file list to see current files"]):c.message.includes("Access denied")&&(o="Access denied",r=["The file is outside the allowed directories","File access is restricted for security reasons"]),function(e,t){const n=e.querySelector(".file-viewer-error"),i=e.querySelector(".error-message"),o=e.querySelector(".error-suggestions");let r=t.error||"Unknown error occurred";i&&(i.innerHTML=`\n            <div class="error-main">${r}</div>\n            ${t.file_path?`<div class="error-file">File: ${t.file_path}</div>`:""}\n            ${t.working_dir?`<div class="error-dir">Working directory: ${t.working_dir}</div>`:""}\n        `);o&&(t.suggestions&&t.suggestions.length>0?o.innerHTML=`\n                <h4>Suggestions:</h4>\n                <ul>\n                    ${t.suggestions.map(e=>`<li>${e}</li>`).join("")}\n                </ul>\n            `:o.innerHTML="");console.log("📋 Displaying file viewer error:",{originalError:t.error,processedMessage:r,suggestions:t.suggestions}),n&&(n.style.display="block")}(e,{error:o,file_path:t,working_dir:i,suggestions:r})}}function n(e){return e.split("\n").map((e,t)=>`<span class="line-number">${String(t+1).padStart(3," ")}</span> ${e||" "}`).join("\n")}function i(e){const t=document.createElement("div");return t.textContent=e,t.innerHTML}window.clearEvents=function(){window.dashboard&&window.dashboard.clearEvents()},window.exportEvents=function(){window.dashboard&&window.dashboard.exportEvents()},window.clearSelection=function(){window.dashboard&&window.dashboard.clearSelection()},window.switchTab=function(e){window.dashboard&&window.dashboard.switchTab(e)},window.copyFileContent=function(){const e=document.getElementById("file-viewer-modal");if(!e)return;const t=e.querySelector(".file-content-code");if(!t)return;const n=t.textContent;if(navigator.clipboard&&navigator.clipboard.writeText)navigator.clipboard.writeText(n).then(()=>{const t=e.querySelector(".file-content-copy");if(t){const e=t.textContent;t.textContent="✅ Copied!",setTimeout(()=>{t.textContent=e},2e3)}}).catch(e=>{console.error("Failed to copy text:",e)});else{const t=document.createElement("textarea");t.value=n,document.body.appendChild(t),t.select(),document.execCommand("copy"),document.body.removeChild(t);const i=e.querySelector(".file-content-copy");if(i){const e=i.textContent;i.textContent="✅ Copied!",setTimeout(()=>{i.textContent=e},2e3)}}},window.showFileViewerModal=async function(e){console.log("[FileViewer] Opening file:",e);let n="";window.dashboard&&window.dashboard.currentWorkingDir&&(n=window.dashboard.currentWorkingDir,console.log("[FileViewer] Using working directory:",n));let i=document.getElementById("file-viewer-modal");i||(console.log("[FileViewer] Creating new modal"),i=function(){const e=document.createElement("div");return e.id="file-viewer-modal",e.className="modal file-viewer-modal",e.innerHTML='\n        <div class="modal-content file-viewer-content">\n            <div class="file-viewer-header">\n                <h2 class="file-viewer-title">\n                    <span class="file-viewer-icon">📄</span>\n                    <span class="file-viewer-title-text">File Viewer</span>\n                </h2>\n                <div class="file-viewer-meta">\n                    <span class="file-viewer-file-path"></span>\n                    <span class="file-viewer-file-size"></span>\n                </div>\n                <button class="file-viewer-close" onclick="hideFileViewerModal()">\n                    <span>&times;</span>\n                </button>\n            </div>\n            <div class="file-viewer-body">\n                <div class="file-viewer-loading">\n                    <div class="loading-spinner"></div>\n                    <span>Loading file content...</span>\n                </div>\n                <div class="file-viewer-error" style="display: none;">\n                    <div class="error-icon">⚠️</div>\n                    <div class="error-message"></div>\n                    <div class="error-suggestions"></div>\n                </div>\n                <div class="file-viewer-content-area" style="display: none;">\n                    <div class="file-viewer-toolbar">\n                        <div class="file-viewer-info">\n                            <span class="file-extension"></span>\n                            <span class="file-encoding"></span>\n                        </div>\n                        <div class="file-viewer-actions">\n                            <button class="file-content-copy" onclick="copyFileContent()">\n                                📋 Copy\n                            </button>\n                        </div>\n                    </div>\n                    <div class="file-viewer-scroll-wrapper">\n                        <pre class="file-content-display"><code class="file-content-code"></code></pre>\n                    </div>\n                </div>\n            </div>\n        </div>\n    ',e.addEventListener("click",t=>{t.target===e&&hideFileViewerModal()}),document.addEventListener("keydown",t=>{"Escape"===t.key&&"flex"===e.style.display&&hideFileViewerModal()}),e}(),document.body.appendChild(i),await new Promise(e=>setTimeout(e,10))),i.style.display="flex",document.body.style.overflow="hidden",t(i,e,n).catch(e=>{console.error("Error updating file viewer modal:",e),function(e,t){const n=e.querySelector(".file-viewer-error"),i=e.querySelector(".error-message"),o=e.querySelector(".error-suggestions"),r=e.querySelector(".file-viewer-loading"),s=e.querySelector(".file-viewer-content-area");r&&(r.style.display="none");s&&(s.style.display="none");n&&(n.style.display="flex");let a=t.error||"Unknown error occurred";a.includes("not found")?a="📁 File not found or not accessible":a.includes("permission")?a="🔒 Permission denied accessing this file":a.includes("too large")?a="📏 File is too large to display":a.includes("socket connection")?a="🔌 Not connected to the server. Please check your connection.":a.includes("timeout")?a="⏱️ Request timed out. The server may be busy or unresponsive.":a.includes("📁")||a.includes("🔒")||a.includes("📏")||(a=`⚠️ ${a}`);i&&(i.textContent=a);o&&(t.suggestions&&t.suggestions.length>0?o.innerHTML=`\n                <h4>Suggestions:</h4>\n                <ul>\n                    ${t.suggestions.map(e=>`<li>${e}</li>`).join("")}\n                </ul>\n            `:o.innerHTML="\n                <h4>Try:</h4>\n                <ul>\n                    <li>Check if the file exists and is readable</li>\n                    <li>Verify file permissions</li>\n                    <li>Ensure the monitoring server has access to this file</li>\n                </ul>\n            ");console.log("📋 Displaying file content error:",{originalError:t.error,processedMessage:a,suggestions:t.suggestions}),n&&(n.style.display="block")}(i,{error:e.message})})},window.hideFileViewerModal=function(){const e=document.getElementById("file-viewer-modal");e&&(e.style.display="none",document.body.style.overflow="")},window.copyFileContent=function(){const e=document.getElementById("file-viewer-modal");if(!e)return;const t=e.querySelector(".file-content-code");if(!t)return;const n=t.textContent;if(navigator.clipboard&&navigator.clipboard.writeText)navigator.clipboard.writeText(n).then(()=>{const t=e.querySelector(".file-content-copy");if(t){const e=t.textContent;t.textContent="✅ Copied!",setTimeout(()=>{t.textContent=e},2e3)}}).catch(e=>{console.error("Failed to copy text:",e)});else{const t=document.createElement("textarea");t.value=n,document.body.appendChild(t),t.select(),document.execCommand("copy"),document.body.removeChild(t);const i=e.querySelector(".file-content-copy");if(i){const e=i.textContent;i.textContent="✅ Copied!",setTimeout(()=>{i.textContent=e},2e3)}}},window.showSearchViewerModal=function(e,t){let n=document.getElementById("search-viewer-modal");n||(n=function(){const e=document.createElement("div");return e.id="search-viewer-modal",e.className="modal search-viewer-modal",e.innerHTML='\n        <div class="modal-content search-viewer-content">\n            <div class="search-viewer-header">\n                <h2 class="search-viewer-title">\n                    <span class="search-viewer-icon">🔍</span>\n                    <span class="search-viewer-title-text">Search Results</span>\n                </h2>\n                <button class="search-viewer-close" onclick="hideSearchViewerModal()">\n                    <span>&times;</span>\n                </button>\n            </div>\n            <div class="search-viewer-body">\n                <div class="search-params-section">\n                    <h3>Search Parameters</h3>\n                    <pre class="search-params-display"></pre>\n                </div>\n                <div class="search-results-section">\n                    <h3>Search Results</h3>\n                    <div class="search-results-display"></div>\n                </div>\n            </div>\n        </div>\n    ',e.addEventListener("click",t=>{t.target===e&&hideSearchViewerModal()}),document.addEventListener("keydown",t=>{"Escape"===t.key&&"flex"===e.style.display&&hideSearchViewerModal()}),e}(),document.body.appendChild(n)),function(e,t,n){const o=e.querySelector(".search-params-display"),r=e.querySelector(".search-results-display");o&&t&&(o.textContent=JSON.stringify(t,null,2));if(r&&n){let e="";"string"==typeof n?e=`<pre class="search-results-text">${i(n)}</pre>`:Array.isArray(n)?(e='<ul class="search-results-list">',n.forEach(t=>{e+="object"==typeof t?`<li><pre>${JSON.stringify(t,null,2)}</pre></li>`:`<li>${i(String(t))}</li>`}),e+="</ul>"):e="object"==typeof n?`<pre class="search-results-json">${JSON.stringify(n,null,2)}</pre>`:`<div class="search-results-text">${i(String(n))}</div>`,r.innerHTML=e}}(n,e,t),n.style.display="flex",document.body.style.overflow="hidden"},window.hideSearchViewerModal=function(){const e=document.getElementById("search-viewer-modal");e&&(e.style.display="none",document.body.style.overflow="")},window.showAgentInstanceDetails=function(e){window.dashboard&&"function"==typeof window.dashboard.showAgentInstanceDetails?window.dashboard.showAgentInstanceDetails(e):console.error("Dashboard not available or method not found")},document.addEventListener("DOMContentLoaded",function(){try{window.dashboard=new e,window.dashboard&&"function"==typeof window.dashboard.postInit&&window.dashboard.postInit(),console.log("Dashboard loaded and initialized successfully"),document.dispatchEvent(new CustomEvent("dashboardReady",{detail:{dashboard:window.dashboard}}))}catch(t){console.error("Failed to initialize dashboard:",t),document.body.innerHTML=`\n            <div style="padding: 20px; font-family: sans-serif;">\n                <h1>Dashboard Initialization Error</h1>\n                <p>The dashboard failed to load properly. Please refresh the page or check the console for details.</p>\n                <pre style="background: #f5f5f5; padding: 10px; border-radius: 4px;">${t.message}</pre>\n            </div>\n        `}});
//# sourceMappingURL=dashboard.js.map
