"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from orq_poc_python_multi_env_version.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from orq_poc_python_multi_env_version.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
from pydantic import model_serializer
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class UsageTypedDict(TypedDict):
    r"""Usage statistics to add to the deployment"""

    prompt_tokens: float
    r"""Number of tokens in the prompt."""
    completion_tokens: float
    r"""Number of tokens in the generated completion."""
    total_tokens: NotRequired[float]
    r"""Total number of tokens used in the request (prompt + completion)."""


class Usage(BaseModel):
    r"""Usage statistics to add to the deployment"""

    prompt_tokens: float
    r"""Number of tokens in the prompt."""

    completion_tokens: float
    r"""Number of tokens in the generated completion."""

    total_tokens: Optional[float] = None
    r"""Total number of tokens used in the request (prompt + completion)."""


class PerformanceTypedDict(TypedDict):
    latency: float
    r"""Total time in milliseconds of the request to the LLM provider API."""
    time_to_first_token: NotRequired[float]
    r"""Total time in milliseconds to generate the first token of the completion."""


class Performance(BaseModel):
    latency: float
    r"""Total time in milliseconds of the request to the LLM provider API."""

    time_to_first_token: Optional[float] = None
    r"""Total time in milliseconds to generate the first token of the completion."""


DeploymentCreateMetricRole = Literal[
    "system",
    "assistant",
    "user",
    "exception",
    "tool",
    "prompt",
    "correction",
    "expected_output",
]
r"""The role of the prompt message"""

DeploymentCreateMetric2DeploymentsMetricsType = Literal["image_url"]


class DeploymentCreateMetric2ImageURLTypedDict(TypedDict):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""
    detail: NotRequired[str]
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class DeploymentCreateMetric2ImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""

    detail: Optional[str] = None
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class DeploymentCreateMetric22TypedDict(TypedDict):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: DeploymentCreateMetric2DeploymentsMetricsType
    image_url: DeploymentCreateMetric2ImageURLTypedDict


class DeploymentCreateMetric22(BaseModel):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: DeploymentCreateMetric2DeploymentsMetricsType

    image_url: DeploymentCreateMetric2ImageURL


DeploymentCreateMetric2Type = Literal["text"]


class DeploymentCreateMetric21TypedDict(TypedDict):
    r"""Text content part of a prompt message"""

    type: DeploymentCreateMetric2Type
    text: str


class DeploymentCreateMetric21(BaseModel):
    r"""Text content part of a prompt message"""

    type: DeploymentCreateMetric2Type

    text: str


DeploymentCreateMetricContent2TypedDict = TypeAliasType(
    "DeploymentCreateMetricContent2TypedDict",
    Union[DeploymentCreateMetric21TypedDict, DeploymentCreateMetric22TypedDict],
)


DeploymentCreateMetricContent2 = TypeAliasType(
    "DeploymentCreateMetricContent2",
    Union[DeploymentCreateMetric21, DeploymentCreateMetric22],
)


DeploymentCreateMetricContentTypedDict = TypeAliasType(
    "DeploymentCreateMetricContentTypedDict",
    Union[str, List[DeploymentCreateMetricContent2TypedDict]],
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


DeploymentCreateMetricContent = TypeAliasType(
    "DeploymentCreateMetricContent", Union[str, List[DeploymentCreateMetricContent2]]
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


DeploymentCreateMetricType = Literal["function"]


class DeploymentCreateMetricFunctionTypedDict(TypedDict):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class DeploymentCreateMetricFunction(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class DeploymentCreateMetricToolCallsTypedDict(TypedDict):
    type: DeploymentCreateMetricType
    function: DeploymentCreateMetricFunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class DeploymentCreateMetricToolCalls(BaseModel):
    type: DeploymentCreateMetricType

    function: DeploymentCreateMetricFunction

    id: Optional[str] = None

    index: Optional[float] = None


class DeploymentCreateMetricMessagesTypedDict(TypedDict):
    role: DeploymentCreateMetricRole
    r"""The role of the prompt message"""
    content: DeploymentCreateMetricContentTypedDict
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""
    tool_calls: NotRequired[List[DeploymentCreateMetricToolCallsTypedDict]]


class DeploymentCreateMetricMessages(BaseModel):
    role: DeploymentCreateMetricRole
    r"""The role of the prompt message"""

    content: DeploymentCreateMetricContent
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""

    tool_calls: Optional[List[DeploymentCreateMetricToolCalls]] = None


DeploymentCreateMetricMessageDeploymentsMetricsRole = Literal[
    "system",
    "assistant",
    "user",
    "exception",
    "tool",
    "prompt",
    "correction",
    "expected_output",
]
r"""The role of the prompt message"""


class ThreeTypedDict(TypedDict):
    role: DeploymentCreateMetricMessageDeploymentsMetricsRole
    r"""The role of the prompt message"""
    url: str


class Three(BaseModel):
    role: DeploymentCreateMetricMessageDeploymentsMetricsRole
    r"""The role of the prompt message"""

    url: str


DeploymentCreateMetricMessageRole = Literal[
    "system",
    "assistant",
    "user",
    "exception",
    "tool",
    "prompt",
    "correction",
    "expected_output",
]
r"""The role of the prompt message"""


class Message2TypedDict(TypedDict):
    role: DeploymentCreateMetricMessageRole
    r"""The role of the prompt message"""
    content: Nullable[str]


class Message2(BaseModel):
    role: DeploymentCreateMetricMessageRole
    r"""The role of the prompt message"""

    content: Nullable[str]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["content"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


MessageRole = Literal[
    "system",
    "assistant",
    "user",
    "exception",
    "tool",
    "prompt",
    "correction",
    "expected_output",
]
r"""The role of the prompt message"""

MessageType = Literal["function"]


class MessageFunctionTypedDict(TypedDict):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class MessageFunction(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class MessageToolCallsTypedDict(TypedDict):
    type: MessageType
    function: MessageFunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class MessageToolCalls(BaseModel):
    type: MessageType

    function: MessageFunction

    id: Optional[str] = None

    index: Optional[float] = None


class Message1TypedDict(TypedDict):
    role: MessageRole
    r"""The role of the prompt message"""
    tool_calls: List[MessageToolCallsTypedDict]
    content: NotRequired[Nullable[str]]


class Message1(BaseModel):
    role: MessageRole
    r"""The role of the prompt message"""

    tool_calls: List[MessageToolCalls]

    content: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["content"]
        nullable_fields = ["content"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


MessageTypedDict = TypeAliasType(
    "MessageTypedDict", Union[Message2TypedDict, ThreeTypedDict, Message1TypedDict]
)


Message = TypeAliasType("Message", Union[Message2, Three, Message1])


class ChoicesTypedDict(TypedDict):
    index: float
    message: NotRequired[MessageTypedDict]
    finish_reason: NotRequired[Nullable[str]]


class Choices(BaseModel):
    index: float

    message: Optional[Message] = None

    finish_reason: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["message", "finish_reason"]
        nullable_fields = ["finish_reason"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class DeploymentCreateMetricFeedbackTypedDict(TypedDict):
    r"""Feedback from the user on the completion"""

    score: int
    r"""The feedback score. This allow you to come with specific logic on what a `score` number means"""


class DeploymentCreateMetricFeedback(BaseModel):
    r"""Feedback from the user on the completion"""

    score: int
    r"""The feedback score. This allow you to come with specific logic on what a `score` number means"""


class DeploymentCreateMetricRequestBodyTypedDict(TypedDict):
    r"""The deployment request payload"""

    metadata: NotRequired[Dict[str, Any]]
    r"""Your own custom key-value pairs can be attached to the logs. This is useful for storing additional information related to your interactions with the LLM providers or specifics within your application."""
    usage: NotRequired[UsageTypedDict]
    r"""Usage statistics to add to the deployment"""
    performance: NotRequired[PerformanceTypedDict]
    messages: NotRequired[List[DeploymentCreateMetricMessagesTypedDict]]
    r"""A list of messages sent to the model."""
    choices: NotRequired[List[ChoicesTypedDict]]
    r"""A list of completion choices. If you are using a `completion` model then you must provide the `completion content` with the chat completion format"""
    feedback: NotRequired[DeploymentCreateMetricFeedbackTypedDict]
    r"""Feedback from the user on the completion"""


class DeploymentCreateMetricRequestBody(BaseModel):
    r"""The deployment request payload"""

    metadata: Optional[Dict[str, Any]] = None
    r"""Your own custom key-value pairs can be attached to the logs. This is useful for storing additional information related to your interactions with the LLM providers or specifics within your application."""

    usage: Optional[Usage] = None
    r"""Usage statistics to add to the deployment"""

    performance: Optional[Performance] = None

    messages: Optional[List[DeploymentCreateMetricMessages]] = None
    r"""A list of messages sent to the model."""

    choices: Optional[List[Choices]] = None
    r"""A list of completion choices. If you are using a `completion` model then you must provide the `completion content` with the chat completion format"""

    feedback: Optional[DeploymentCreateMetricFeedback] = None
    r"""Feedback from the user on the completion"""


class DeploymentCreateMetricRequestTypedDict(TypedDict):
    id: str
    r"""Deployment ID"""
    request_body: DeploymentCreateMetricRequestBodyTypedDict
    r"""The deployment request payload"""


class DeploymentCreateMetricRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Deployment ID"""

    request_body: Annotated[
        DeploymentCreateMetricRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""The deployment request payload"""


class DeploymentCreateMetricResponseBodyTypedDict(TypedDict):
    r"""Successful operation"""

    code: float
    r"""The status code of the request"""
    success: bool
    r"""Whether the request was successful"""


class DeploymentCreateMetricResponseBody(BaseModel):
    r"""Successful operation"""

    code: float
    r"""The status code of the request"""

    success: bool
    r"""Whether the request was successful"""
