"""
Defines flight controller vendor, board name and MCU series depending on hwdef.dat file information.

File automatically generated by the update_flight_controller_ids.py script
Do not edit directly. ALL CHANGES WILL BE OVERWRITTEN

SPDX-FileCopyrightText: 2024-2025 Amilcar do Carmo Lucas <amilcar.lucas@iav.de>

SPDX-License-Identifier: GPL-3.0-or-later
"""

# pylint: disable=line-too-long

# Maps USB VID to vendor(s) (manufacturer) name
VID_VENDOR_DICT: dict[int, list[str]] = {
    0x26AC: ["3DR"],
    0x1209: ["ArduPilot", "AET", "Airvolute", "Aocoda-RC-H743Dual", "CSKY", "Japan Aviation Electronics Industry Ltd.", "mRo", "Horizon31", "Dheeran labs", "Qiotek", "Sierra Aerospace", "SkySakura"],
    0x2DAE: ["Hex/ProfiCNC", "CubePilot"],
    0x3162: ["Holybro"],
    0x27AC: ["Swift-Flyer", "Laser Navigation"],
    0x35A7: ["ThePeach"],
}

# Maps USB VID,PID tuple to product name(s)
VID_PID_PRODUCT_DICT: dict[tuple[int, int], list[str]] = {
    (0x26AC, 0x1124): ["CZOEMrevG"],
    (0x1209, 0x5741): ["ACNS-CM4Pilot", "ACNS-F405AIO", "AeroFox-GNSS_F9P", "AEROFOX-H7", "AeroFox-PMU", "AET-H743-Basic", "airbotf4", "AIRLink", "Airvolute-DCS2", "AnyleafH7", "Aocoda-RC-H743Dual", "AR-F407SmartBat", "ARK_CANNODE", "ARK_FPV", "ARKV6X", "AtomRCF405NAVI", "BeastF7", "BeastF7v2", "BeastH7", "BeastH7v2", "BETAFPV-F405", "BirdCANdy", "BlitzF745", "BlitzF745AIO", "BlitzH743Pro", "BlitzMiniF745", "BlitzWingH743", "BotBloxDroneNet", "C-RTK2-HP", "CarbonixF405", "CarbonixL496", "CBU-H7-LC-Stamp", "CBU-H7-Stamp", "CrazyF405", "crazyflie2", "CSKY405", "CUAV-7-Nano", "CUAV-Nora", "CUAV-Pixhack-v3", "CUAV-X7", "CUAVv5", "CUAVv5Nano", "CubeNode", "CubeRedSecondary", "CubeRedSecondary-IO", "CubeSolo", "DevEBoxH7v2", "DroneerF405", "DrotekP3Pro", "F35Lightning", "FlyingMoonF407", "FlyingMoonF427", "FlyingMoonH743", "FlywooF405HD-AIOv2", "FlywooF405Pro", "FlywooF405S-AIO", "FlywooF745", "FlywooF745Nano", "FlywooH743Pro", "fmuv2", "fmuv3", "fmuv5", "FoxeerF405v2", "FoxeerH743v1", "FreeflyRTK", "GEPRC_TAKER_H743", "GEPRCF745BTHD", "%BOARD%", "HEEWING-F405", "HEEWING-F405v2", "Here4AP", "Here4FC", "HolybroF4_PMU", "IFLIGHT_2RAW_H7", "JFB100", "JFB-110", "JHEM_JHEF405", "JHEMCU-GSF405A", "JHEMCU-GSF405A-RX2", "JHEMCU-H743HD", "KakuteF4", "KakuteF4-Wing", "KakuteF4Mini", "KakuteF7", "KakuteF7Mini", "KakuteH7", "KakuteH7-Wing", "KakuteH7Mini", "KakuteH7Mini-Nand", "KakuteH7v2", "LongBowF405WING", "LumenierLUXF765-NDAA", "luminousbee4", "luminousbee5", "MambaF405-2022", "MambaF405v2", "MambaH743v4", "MatekF405", "MatekF405-CAN", "MatekF405-STD", "MatekF405-TE", "MatekF405-Wing", "MatekF765-SE", "MatekF765-Wing", "MatekG474", "MatekH743", "MatekH7A3", "MazzyStarDrone", "MFE_POS3_CAN", "MFT-SEMA100", "MicoAir405Mini", "MicoAir405v2", "MicoAir743", "MicoAir743-AIO", "MicoAir743v2", "mindpx-v2", "mini-pix", "modalai_fc-v1", "mRo-M10095", "mRoCANPWM-M10126", "mRoControlZeroClassic", "mRoControlZeroF7", "mRoControlZeroH7", "mRoControlZeroOEMH7", "mRoCZeroOEMH7", "mRoNexus", "mRoPixracerPro", "mRoX21", "mRoX21-777", "MUPilot", "Nucleo-G491", "Nucleo-L476", "Nucleo-L496", "NucleoH743", "NucleoH755", "NxtPX4v2", "omnibusf4", "omnibusf4pro", "omnibusf4pro-one", "omnibusf4v6", "OMNIBUSF7V2", "OmnibusNanoV6", "OrqaF405Pro", "PH4-mini", "PixC4-Jetson", "PixFlamingo", "Pixhawk1", "Pixhawk1-1M", "Pixhawk4", "Pixhawk6X", "Pixhawk6X-PPPGW", "PixPilot-C3", "PixPilot-V3", "PixPilot-V6", "PixPilot-V6PRO", "Pixracer", "PixSurveyA1", "PixSurveyA1-IND", "PixSurveyA2", "QioTekAdeptF407", "QioTekZealotF427", "QioTekZealotH743", "R9Pilot", "RadiolinkPIX6", "RADIX2HD", "ReaperF745", "revo-mini", "revo-mini-i2c", "revo-mini-sd", "rFCU", "rGNSS", "SDMODELH7V1", "SDMODELH7V2", "Sierra-F405", "Sierra-F412", "Sierra-F9P", "Sierra-L431", "Sierra-PrecisionPoint", "Sierra-TrueNavIC", "Sierra-TrueNavPro", "Sierra-TrueNavPro-G4", "Sierra-TrueNorth", "Sierra-TrueSpeed", "SIYI_N7", "SkySakuraH743", "SkystarsH7HD", "skyviper-f412-rev1", "skyviper-journey", "skyviper-v2450", "sparky2", "speedybeef4", "SpeedyBeeF405AIO", "SpeedyBeeF405Mini", "SpeedyBeeF405WING", "speedybeef4v3", "speedybeef4v4", "SPRacingH7", "SPRacingH7RF", "StellarF4", "StellarF4V2", "StellarH7V2", "SuccexF4", "SULILGH7-P1-P2", "sw-boom-f407", "sw-nav-f405", "sw-spar-f407", "Swan-K1", "TBS-Colibri-F7", "TBS_LUCID_H7", "TBS_LUCID_PRO", "TMotorH743", "VUAV-V7pro", "X-MAV-AP-H743v2", "YJUAV_A6", "YJUAV_A6SE", "YJUAV_A6SE_H743", "YJUAV_A6Ultra", "ZeroOneX6", "ZeroOneX6_Air"],
    (0x2DAE, 0x1011): ["CubeBlack", "CubeGreen-solo"],
    (0x2DAE, 0x1101): ["CubeBlack+"],
    (0x2DAE, 0x1016): ["CubeOrange"],
    (0x2DAE, 0x1057): ["Joey"],
    (0x2DAE, 0x1058): ["CubeOrange+"],
    (0x2DAE, 0x1015): ["CubePurple"],
    (0x2DAE, 0x1059): ["CubeRed"],
    (0x2DAE, 0x1012): ["CubeYellow"],
    (0x3162, 0x004B): ["Durandal"],
    (0x27AC, 0x0201): ["F4BY", "F4BY_F427"],
    (0x3162, 0x004E): ["Pix32v5"],
    (0x3162, 0x0051): ["Pixhawk5X"],
    (0x3162, 0x0053): ["Pixhawk6C"],
    (0x35A7, 0x0001): ["FCC-K1"],
    (0x35A7, 0x0002): ["FCC-R1"],
    (0x27AC, 0x1151): ["VRBrain-v51"],
    (0x27AC, 0x1152): ["VRBrain-v52"],
    (0x27AC, 0x1154): ["VRBrain-v54"],
    (0x27AC, 0x1910): ["VRCore-v10"],
    (0x27AC, 0x1351): ["VRUBrain-v51"],
}

# Maps 16-bit APJ board ID to board name(s) for 246 supported boards
APJ_BOARD_ID_NAME_DICT: dict[int, list[str]] = {
    1124: ["3DRControlZeroG"],
    1115: ["ACNS-CM4Pilot"],
    1116: ["ACNS-F405AIO"],
    1109: ["AeroFox-GNSS_F9P"],
    7110: ["AEROFOX-H7"],
    1080: ["AeroFox-PMU"],
    2024: ["AET-H743-Basic"],
    128: ["airbotf4"],
    55: ["AIRLink"],
    5200: ["Airvolute-DCS2"],
    1146: ["AnyleafH7"],
    5210: ["Aocoda-RC-H743Dual"],
    1134: ["AR-F407SmartBat"],
    83: ["ARK_CANNODE"],
    59: ["ARK_FPV"],
    57: ["ARKV6X"],
    1078: ["AtomRCF405NAVI"],
    1026: ["BeastF7"],
    1057: ["BeastF7v2"],
    1025: ["BeastH7"],
    1056: ["BeastH7v2"],
    1125: ["BETAFPV-F405"],
    1044: ["BirdCANdy"],
    1164: ["BlitzF745"],
    1117: ["BlitzF745AIO"],
    1162: ["BlitzH743Pro"],
    1163: ["BlitzMiniF745"],
    1168: ["BlitzWingH743"],
    1148: ["BotBloxDroneNet"],
    1085: ["C-RTK2-HP"],
    1064: ["CarbonixF405"],
    1053: ["CarbonixL496"],
    1182: ["CBU-H7-LC-Stamp"],
    1156: ["CBU-H7-Stamp"],
    1177: ["CrazyF405"],
    12: ["crazyflie2"],
    1158: ["CSKY405"],
    7000: ["CUAV-7-Nano"],
    1009: ["CUAV-Nora"],
    9: ["CUAV-Pixhack-v3", "CubeBlack", "CubeGreen-solo", "CubePurple", "CubeSolo", "fmuv2", "fmuv3", "mRoX21", "Pixhawk1", "Pixhawk1-1M", "skyviper-f412-rev1", "skyviper-journey", "skyviper-v2450"],
    1010: ["CUAV-X7"],
    50: ["CUAVv5", "CUAVv5Nano", "fmuv5", "PH4-mini", "Pix32v5", "Pixhawk4", "Swan-K1", "TBS-Colibri-F7"],
    1003: ["CubeBlack+"],
    1079: ["CubeNode"],
    140: ["CubeOrange"],
    1033: ["CubeOrange-joey"],
    1063: ["CubeOrangePlus"],
    1069: ["CubeRedPrimary"],
    1409: ["CubeRedPrimary-PPPGW"],
    1070: ["CubeRedSecondary", "CubeRedSecondary-IO"],
    120: ["CubeYellow"],
    1061: ["DevEBoxH7v2"],
    5800: ["DroneerF405"],
    13: ["DrotekP3Pro"],
    139: ["Durandal", "NucleoH743", "NucleoH755"],
    135: ["F35Lightning"],
    20: ["F4BY"],
    1530: ["F4BY_F427"],
    1067: ["FlyingMoonF407"],
    1068: ["FlyingMoonF427"],
    1112: ["FlyingMoonH743"],
    1180: ["FlywooF405HD-AIOv2"],
    1137: ["FlywooF405Pro"],
    1099: ["FlywooF405S-AIO"],
    1027: ["FlywooF745"],
    1042: ["FlywooF745Nano"],
    1181: ["FlywooH743Pro"],
    1157: ["FoxeerF405v2"],
    1089: ["FoxeerH743v1"],
    1028: ["FreeflyRTK"],
    1502: ["GEPRC_TAKER_H743"],
    1501: ["GEPRCF745BTHD"],
    146: ["H757I_EVAL", "H757I_EVAL_intf"],
    1119: ["HEEWING-F405", "HEEWING-F405v2"],
    1043: ["Here4AP", "Here4FC"],
    5401: ["HolybroF4_PMU"],
    1173: ["IFLIGHT_2RAW_H7"],
    1084: ["JFB100"],
    1110: ["JFB110"],
    1081: ["JHEM_JHEF405"],
    1059: ["JHEMCU-GSF405A", "JHEMCU-GSF405A-RX2"],
    1411: ["JHEMCU-H743HD"],
    122: ["KakuteF4"],
    5406: ["KakuteF4-Wing"],
    1030: ["KakuteF4Mini"],
    123: ["KakuteF7"],
    145: ["KakuteF7Mini"],
    1048: ["KakuteH7", "KakuteH7v2"],
    1105: ["KakuteH7-Wing"],
    1058: ["KakuteH7Mini", "KakuteH7Mini-Nand"],
    1315: ["kha_eth"],
    1422: ["LongBowF405WING"],
    4500: ["LumenierLUXF765-NDAA"],
    11: ["luminousbee4", "Pixracer"],
    1029: ["luminousbee5"],
    1038: ["MambaF405-2022"],
    1019: ["MambaF405v2"],
    1073: ["MambaH743v4"],
    125: ["MatekF405", "MatekF405-STD"],
    1014: ["MatekF405-CAN"],
    1054: ["MatekF405-TE"],
    127: ["MatekF405-Wing"],
    143: ["MatekF765-SE", "MatekF765-Wing"],
    1170: ["MatekG474"],
    1013: ["MatekH743"],
    1149: ["MatekH7A3"],
    188: ["MazzyStarDrone"],
    6101: ["MFE_POS3_CAN"],
    2000: ["MFT-SEMA100"],
    1161: ["MicoAir405Mini"],
    1150: ["MicoAir405v2"],
    1166: ["MicoAir743"],
    1176: ["MicoAir743-AIO"],
    1179: ["MicoAir743v2"],
    88: ["mindpx-v2"],
    3: ["mini-pix"],
    41775: ["modalai_fc-v1"],
    1041: ["mRo-M10095"],
    1098: ["mRoCANPWM-M10126"],
    1022: ["mRoControlZeroClassic"],
    141: ["mRoControlZeroF7"],
    1023: ["mRoControlZeroH7"],
    1024: ["mRoControlZeroOEMH7", "mRoCZeroOEMH7"],
    1015: ["mRoNexus"],
    1017: ["mRoPixracerPro"],
    136: ["mRoX21-777"],
    1222: ["MUPilot"],
    1040: ["Nucleo-G491"],
    1051: ["Nucleo-L476"],
    1047: ["Nucleo-L496"],
    1159: ["NxtPX4v2"],
    1002: ["omnibusf4"],
    131: ["omnibusf4pro", "omnibusf4pro-one"],
    137: ["omnibusf4v6"],
    121: ["OMNIBUSF7V2"],
    133: ["OmnibusNanoV6"],
    1155: ["OrqaF405Pro"],
    1032: ["PixC4-Jetson"],
    1090: ["PixFlamingo"],
    1131: ["PixFlamingo-F767"],
    51: ["Pixhawk5X"],
    56: ["Pixhawk6C"],
    53: ["Pixhawk6X"],
    1408: ["Pixhawk6X-PPPGW"],
    1140: ["PixPilot-C3"],
    1096: ["PixPilot-V3"],
    1083: ["PixPilot-V6"],
    1160: ["PixPilot-V6PRO"],
    1076: ["PixSurveyA1"],
    1107: ["PixSurveyA1-IND"],
    1097: ["PixSurveyA2"],
    1065: ["QioTekAdeptF407"],
    1021: ["QioTekZealotF427"],
    1036: ["QioTekZealotH743"],
    1008: ["R9Pilot"],
    1410: ["RadiolinkPIX6"],
    1118: ["RADIX2HD"],
    1074: ["ReaperF745"],
    124: ["revo-mini", "revo-mini-i2c", "revo-mini-sd"],
    1102: ["rFCU"],
    1103: ["rGNSS"],
    1111: ["SDMODELH7V1"],
    1167: ["SDMODELH7V2"],
    1052: ["Sierra-F405"],
    1055: ["Sierra-F412"],
    1034: ["Sierra-F9P"],
    1050: ["Sierra-L431"],
    1095: ["Sierra-PrecisionPoint"],
    5302: ["Sierra-TrueNavIC"],
    1091: ["Sierra-TrueNavPro"],
    5301: ["Sierra-TrueNavPro-G4"],
    1093: ["Sierra-TrueNorth"],
    1094: ["Sierra-TrueSpeed"],
    1123: ["SIYI_N7"],
    2714: ["SkySakuraH743"],
    1075: ["SkystarsH7HD"],
    130: ["sparky2"],
    134: ["speedybeef4"],
    5271: ["SpeedyBeeF405AIO"],
    1135: ["SpeedyBeeF405Mini"],
    1106: ["SpeedyBeeF405WING"],
    1082: ["speedybeef4v3"],
    1136: ["speedybeef4v4"],
    1060: ["SPRacingH7"],
    1108: ["SPRacingH7RF"],
    1500: ["StellarF4"],
    1504: ["StellarF4V2"],
    1503: ["StellarH7V2"],
    1011: ["SuccexF4"],
    2005: ["SULILGH7-P1-P2"],
    6001: ["sw-boom-f407"],
    6002: ["sw-nav-f405"],
    6000: ["sw-spar-f407"],
    5250: ["TBS_LUCID_H7"],
    5251: ["TBS_LUCID_PRO"],
    212: ["thepeach-k1"],
    213: ["thepeach-r1"],
    1138: ["TMotorH743"],
    1151: ["VRBrain-v51"],
    1152: ["VRBrain-v52"],
    1154: ["VRBrain-v54"],
    1910: ["VRCore-v10"],
    1351: ["VRUBrain-v51"],
    7100: ["VUAV-V7pro"],
    1174: ["X-MAV-AP-H743v2"],
    1113: ["YJUAV_A6"],
    1127: ["YJUAV_A6SE"],
    1141: ["YJUAV_A6SE_H743"],
    1144: ["YJUAV_A6Ultra"],
    5600: ["ZeroOneX6", "ZeroOneX6_Air"],
}

# Maps 16-bit APJ board ID to board vendor for 246 supported boards
APJ_BOARD_ID_VENDOR_DICT: dict[int, list[str]] = {
    1124: ["3DR"],  # 3DRControlZeroG
    1115: ["ArduPilot"],  # ACNS-CM4Pilot
    1116: ["ArduPilot"],  # ACNS-F405AIO
    1109: ["ArduPilot"],  # AeroFox-GNSS_F9P
    7110: ["ArduPilot"],  # AEROFOX-H7
    1080: ["ArduPilot"],  # AeroFox-PMU
    2024: ["AET"],  # AET-H743-Basic
    128: ["ArduPilot"],  # airbotf4
    55: ["ArduPilot"],  # AIRLink
    5200: ["Airvolute"],  # Airvolute-DCS2
    1146: ["ArduPilot"],  # AnyleafH7
    5210: ["Aocoda-RC-H743Dual"],  # Aocoda-RC-H743Dual
    1134: ["ArduPilot"],  # AR-F407SmartBat
    83: ["ArduPilot"],  # ARK_CANNODE
    59: ["ArduPilot"],  # ARK_FPV
    57: ["ArduPilot"],  # ARKV6X
    1078: ["ArduPilot"],  # AtomRCF405NAVI
    1026: ["ArduPilot"],  # BeastF7
    1057: ["ArduPilot"],  # BeastF7v2
    1025: ["ArduPilot"],  # BeastH7
    1056: ["ArduPilot"],  # BeastH7v2
    1125: ["ArduPilot"],  # BETAFPV-F405
    1044: ["ArduPilot"],  # BirdCANdy
    1164: ["ArduPilot"],  # BlitzF745
    1117: ["ArduPilot"],  # BlitzF745AIO
    1162: ["ArduPilot"],  # BlitzH743Pro
    1163: ["ArduPilot"],  # BlitzMiniF745
    1168: ["ArduPilot"],  # BlitzWingH743
    1148: ["ArduPilot"],  # BotBloxDroneNet
    1085: ["ArduPilot"],  # C-RTK2-HP
    1064: ["ArduPilot"],  # CarbonixF405
    1053: ["ArduPilot"],  # CarbonixL496
    1182: ["ArduPilot"],  # CBU-H7-LC-Stamp
    1156: ["ArduPilot"],  # CBU-H7-Stamp
    1177: ["ArduPilot"],  # CrazyF405
    12: ["ArduPilot"],  # crazyflie2
    1158: ["CSKY"],  # CSKY405
    7000: ["ArduPilot"],  # CUAV-7-Nano
    1009: ["ArduPilot"],  # CUAV-Nora
    9: ["ArduPilot", "Hex/ProfiCNC"],  # CUAV-Pixhack-v3, CubeBlack, CubeGreen-solo, CubePurple, CubeSolo, fmuv2, fmuv3, mRoX21, Pixhawk1, Pixhawk1-1M, skyviper-f412-rev1, skyviper-journey, skyviper-v2450
    1010: ["ArduPilot"],  # CUAV-X7
    50: ["ArduPilot", "Holybro"],  # CUAVv5, CUAVv5Nano, fmuv5, PH4-mini, Pix32v5, Pixhawk4, Swan-K1, TBS-Colibri-F7
    1003: ["Hex/ProfiCNC"],  # CubeBlack+
    1079: ["ArduPilot"],  # CubeNode
    140: ["Hex/ProfiCNC"],  # CubeOrange
    1033: ["CubePilot"],  # CubeOrange-joey
    1063: ["CubePilot"],  # CubeOrangePlus
    1069: ["CubePilot"],  # CubeRedPrimary
    1409: ["CubePilot"],  # CubeRedPrimary-PPPGW
    1070: ["ArduPilot"],  # CubeRedSecondary, CubeRedSecondary-IO
    120: ["Hex/ProfiCNC"],  # CubeYellow
    1061: ["ArduPilot"],  # DevEBoxH7v2
    5800: ["ArduPilot"],  # DroneerF405
    13: ["ArduPilot"],  # DrotekP3Pro
    139: ["Holybro", "ArduPilot"],  # Durandal, NucleoH743, NucleoH755
    135: ["ArduPilot"],  # F35Lightning
    20: ["Swift-Flyer"],  # F4BY
    1530: ["Swift-Flyer"],  # F4BY_F427
    1067: ["ArduPilot"],  # FlyingMoonF407
    1068: ["ArduPilot"],  # FlyingMoonF427
    1112: ["ArduPilot"],  # FlyingMoonH743
    1180: ["ArduPilot"],  # FlywooF405HD-AIOv2
    1137: ["ArduPilot"],  # FlywooF405Pro
    1099: ["ArduPilot"],  # FlywooF405S-AIO
    1027: ["ArduPilot"],  # FlywooF745
    1042: ["ArduPilot"],  # FlywooF745Nano
    1181: ["ArduPilot"],  # FlywooH743Pro
    1157: ["ArduPilot"],  # FoxeerF405v2
    1089: ["ArduPilot"],  # FoxeerH743v1
    1028: ["ArduPilot"],  # FreeflyRTK
    1502: ["ArduPilot"],  # GEPRC_TAKER_H743
    1501: ["ArduPilot"],  # GEPRCF745BTHD
    146: ["ArduPilot"],  # H757I_EVAL, H757I_EVAL_intf
    1119: ["ArduPilot"],  # HEEWING-F405, HEEWING-F405v2
    1043: ["ArduPilot"],  # Here4AP, Here4FC
    5401: ["ArduPilot"],  # HolybroF4_PMU
    1173: ["ArduPilot"],  # IFLIGHT_2RAW_H7
    1084: ["ArduPilot"],  # JFB100
    1110: ["Japan Aviation Electronics Industry Ltd."],  # JFB110
    1081: ["ArduPilot"],  # JHEM_JHEF405
    1059: ["ArduPilot"],  # JHEMCU-GSF405A, JHEMCU-GSF405A-RX2
    1411: ["ArduPilot"],  # JHEMCU-H743HD
    122: ["ArduPilot"],  # KakuteF4
    5406: ["ArduPilot"],  # KakuteF4-Wing
    1030: ["ArduPilot"],  # KakuteF4Mini
    123: ["ArduPilot"],  # KakuteF7
    145: ["ArduPilot"],  # KakuteF7Mini
    1048: ["ArduPilot"],  # KakuteH7, KakuteH7v2
    1105: ["ArduPilot"],  # KakuteH7-Wing
    1058: ["ArduPilot"],  # KakuteH7Mini, KakuteH7Mini-Nand
    1315: ["ArduPilot"],  # kha_eth
    1422: ["ArduPilot"],  # LongBowF405WING
    4500: ["ArduPilot"],  # LumenierLUXF765-NDAA
    11: ["ArduPilot"],  # luminousbee4, Pixracer
    1029: ["ArduPilot"],  # luminousbee5
    1038: ["ArduPilot"],  # MambaF405-2022
    1019: ["ArduPilot"],  # MambaF405v2
    1073: ["ArduPilot"],  # MambaH743v4
    125: ["ArduPilot"],  # MatekF405, MatekF405-STD
    1014: ["ArduPilot"],  # MatekF405-CAN
    1054: ["ArduPilot"],  # MatekF405-TE
    127: ["ArduPilot"],  # MatekF405-Wing
    143: ["ArduPilot"],  # MatekF765-SE, MatekF765-Wing
    1170: ["ArduPilot"],  # MatekG474
    1013: ["ArduPilot"],  # MatekH743
    1149: ["ArduPilot"],  # MatekH7A3
    188: ["ArduPilot"],  # MazzyStarDrone
    6101: ["ArduPilot"],  # MFE_POS3_CAN
    2000: ["ArduPilot"],  # MFT-SEMA100
    1161: ["ArduPilot"],  # MicoAir405Mini
    1150: ["ArduPilot"],  # MicoAir405v2
    1166: ["ArduPilot"],  # MicoAir743
    1176: ["ArduPilot"],  # MicoAir743-AIO
    1179: ["ArduPilot"],  # MicoAir743v2
    88: ["ArduPilot"],  # mindpx-v2
    3: ["ArduPilot"],  # mini-pix
    41775: ["ArduPilot"],  # modalai_fc-v1
    1041: ["ArduPilot"],  # mRo-M10095
    1098: ["ArduPilot"],  # mRoCANPWM-M10126
    1022: ["mRo"],  # mRoControlZeroClassic
    141: ["mRo"],  # mRoControlZeroF7
    1023: ["mRo"],  # mRoControlZeroH7
    1024: ["mRo"],  # mRoControlZeroOEMH7, mRoCZeroOEMH7
    1015: ["mRo"],  # mRoNexus
    1017: ["mRo"],  # mRoPixracerPro
    136: ["mRo"],  # mRoX21-777
    1222: ["ArduPilot"],  # MUPilot
    1040: ["ArduPilot"],  # Nucleo-G491
    1051: ["ArduPilot"],  # Nucleo-L476
    1047: ["ArduPilot"],  # Nucleo-L496
    1159: ["ArduPilot"],  # NxtPX4v2
    1002: ["ArduPilot"],  # omnibusf4
    131: ["ArduPilot"],  # omnibusf4pro, omnibusf4pro-one
    137: ["ArduPilot"],  # omnibusf4v6
    121: ["ArduPilot"],  # OMNIBUSF7V2
    133: ["ArduPilot"],  # OmnibusNanoV6
    1155: ["ArduPilot"],  # OrqaF405Pro
    1032: ["Horizon31"],  # PixC4-Jetson
    1090: ["Dheeran labs"],  # PixFlamingo
    1131: ["Dheeran labs"],  # PixFlamingo-F767
    51: ["Holybro"],  # Pixhawk5X
    56: ["Holybro"],  # Pixhawk6C
    53: ["ArduPilot"],  # Pixhawk6X
    1408: ["ArduPilot"],  # Pixhawk6X-PPPGW
    1140: ["ArduPilot"],  # PixPilot-C3
    1096: ["ArduPilot"],  # PixPilot-V3
    1083: ["ArduPilot"],  # PixPilot-V6
    1160: ["ArduPilot"],  # PixPilot-V6PRO
    1076: ["ArduPilot"],  # PixSurveyA1
    1107: ["ArduPilot"],  # PixSurveyA1-IND
    1097: ["ArduPilot"],  # PixSurveyA2
    1065: ["Qiotek"],  # QioTekAdeptF407
    1021: ["ArduPilot"],  # QioTekZealotF427
    1036: ["ArduPilot"],  # QioTekZealotH743
    1008: ["ArduPilot"],  # R9Pilot
    1410: ["ArduPilot"],  # RadiolinkPIX6
    1118: ["ArduPilot"],  # RADIX2HD
    1074: ["ArduPilot"],  # ReaperF745
    124: ["ArduPilot"],  # revo-mini, revo-mini-i2c, revo-mini-sd
    1102: ["ArduPilot"],  # rFCU
    1103: ["ArduPilot"],  # rGNSS
    1111: ["ArduPilot"],  # SDMODELH7V1
    1167: ["ArduPilot"],  # SDMODELH7V2
    1052: ["ArduPilot"],  # Sierra-F405
    1055: ["ArduPilot"],  # Sierra-F412
    1034: ["ArduPilot"],  # Sierra-F9P
    1050: ["ArduPilot"],  # Sierra-L431
    1095: ["Sierra Aerospace"],  # Sierra-PrecisionPoint
    5302: ["ArduPilot"],  # Sierra-TrueNavIC
    1091: ["ArduPilot"],  # Sierra-TrueNavPro
    5301: ["ArduPilot"],  # Sierra-TrueNavPro-G4
    1093: ["ArduPilot"],  # Sierra-TrueNorth
    1094: ["ArduPilot"],  # Sierra-TrueSpeed
    1123: ["ArduPilot"],  # SIYI_N7
    2714: ["SkySakura"],  # SkySakuraH743
    1075: ["ArduPilot"],  # SkystarsH7HD
    130: ["ArduPilot"],  # sparky2
    134: ["ArduPilot"],  # speedybeef4
    5271: ["ArduPilot"],  # SpeedyBeeF405AIO
    1135: ["ArduPilot"],  # SpeedyBeeF405Mini
    1106: ["ArduPilot"],  # SpeedyBeeF405WING
    1082: ["ArduPilot"],  # speedybeef4v3
    1136: ["ArduPilot"],  # speedybeef4v4
    1060: ["ArduPilot"],  # SPRacingH7
    1108: ["ArduPilot"],  # SPRacingH7RF
    1500: ["ArduPilot"],  # StellarF4
    1504: ["ArduPilot"],  # StellarF4V2
    1503: ["ArduPilot"],  # StellarH7V2
    1011: ["ArduPilot"],  # SuccexF4
    2005: ["ArduPilot"],  # SULILGH7-P1-P2
    6001: ["ArduPilot"],  # sw-boom-f407
    6002: ["ArduPilot"],  # sw-nav-f405
    6000: ["ArduPilot"],  # sw-spar-f407
    5250: ["ArduPilot"],  # TBS_LUCID_H7
    5251: ["ArduPilot"],  # TBS_LUCID_PRO
    212: ["ThePeach"],  # thepeach-k1
    213: ["ThePeach"],  # thepeach-r1
    1138: ["ArduPilot"],  # TMotorH743
    1151: ["Laser Navigation"],  # VRBrain-v51
    1152: ["Laser Navigation"],  # VRBrain-v52
    1154: ["Laser Navigation"],  # VRBrain-v54
    1910: ["Laser Navigation"],  # VRCore-v10
    1351: ["Laser Navigation"],  # VRUBrain-v51
    7100: ["ArduPilot"],  # VUAV-V7pro
    1174: ["ArduPilot"],  # X-MAV-AP-H743v2
    1113: ["ArduPilot"],  # YJUAV_A6
    1127: ["ArduPilot"],  # YJUAV_A6SE
    1141: ["ArduPilot"],  # YJUAV_A6SE_H743
    1144: ["ArduPilot"],  # YJUAV_A6Ultra
    5600: ["ArduPilot"],  # ZeroOneX6, ZeroOneX6_Air
}

# Maps 16-bit APJ board ID to MCU series for 246 supported boards
APJ_BOARD_ID_MCU_SERIES_DICT: dict[int, list[str]] = {
    1124: ["STM32H7xx"],  # 3DRControlZeroG
    1115: ["STM32F4xx"],  # ACNS-CM4Pilot
    1116: ["STM32F4xx"],  # ACNS-F405AIO
    1109: ["STM32L431"],  # AeroFox-GNSS_F9P
    7110: ["STM32H7xx"],  # AEROFOX-H7
    1080: ["STM32L431"],  # AeroFox-PMU
    2024: ["STM32H7xx"],  # AET-H743-Basic
    128: ["STM32F4xx"],  # airbotf4
    55: ["STM32F7xx"],  # AIRLink
    5200: ["STM32H7xx"],  # Airvolute-DCS2
    1146: ["STM32H7xx"],  # AnyleafH7
    5210: ["STM32H7xx"],  # Aocoda-RC-H743Dual
    1134: ["CKS32F4xx"],  # AR-F407SmartBat
    83: ["STM32F4xx"],  # ARK_CANNODE
    59: ["STM32H7xx"],  # ARK_FPV
    57: ["STM32H7xx"],  # ARKV6X
    1078: ["STM32F4xx"],  # AtomRCF405NAVI
    1026: ["STM32F7xx"],  # BeastF7
    1057: ["STM32F7xx"],  # BeastF7v2
    1025: ["STM32H7xx"],  # BeastH7
    1056: ["STM32H7xx"],  # BeastH7v2
    1125: ["STM32F4xx"],  # BETAFPV-F405
    1044: ["STM32F4xx"],  # BirdCANdy
    1164: ["STM32F7xx"],  # BlitzF745
    1117: ["STM32F7xx"],  # BlitzF745AIO
    1162: ["STM32H7xx"],  # BlitzH743Pro
    1163: ["STM32F7xx"],  # BlitzMiniF745
    1168: ["STM32H7xx"],  # BlitzWingH743
    1148: ["STM32H7xx"],  # BotBloxDroneNet
    1085: ["STM32F4xx"],  # C-RTK2-HP
    1064: ["STM32F4xx"],  # CarbonixF405
    1053: ["STM32L496"],  # CarbonixL496
    1182: ["STM32H7xx"],  # CBU-H7-LC-Stamp
    1156: ["STM32H7xx"],  # CBU-H7-Stamp
    1177: ["STM32F4xx"],  # CrazyF405
    12: ["STM32F4xx"],  # crazyflie2
    1158: ["STM32F4xx"],  # CSKY405
    7000: ["STM32H7xx"],  # CUAV-7-Nano
    1009: ["STM32H7xx"],  # CUAV-Nora
    9: ["STM32F4xx"],  # CUAV-Pixhack-v3, CubeBlack, CubeGreen-solo, CubePurple, CubeSolo, fmuv2, fmuv3, mRoX21, Pixhawk1, Pixhawk1-1M, skyviper-f412-rev1, skyviper-journey, skyviper-v2450
    1010: ["STM32H7xx"],  # CUAV-X7
    50: ["STM32F7xx"],  # CUAVv5, CUAVv5Nano, fmuv5, PH4-mini, Pix32v5, Pixhawk4, Swan-K1, TBS-Colibri-F7
    1003: ["STM32F4xx"],  # CubeBlack+
    1079: ["STM32H7xx"],  # CubeNode
    140: ["STM32H7xx"],  # CubeOrange
    1033: ["STM32H7xx"],  # CubeOrange-joey
    1063: ["STM32H7xx"],  # CubeOrangePlus
    1069: ["STM32H7xx"],  # CubeRedPrimary
    1409: ["STM32H7xx"],  # CubeRedPrimary-PPPGW
    1070: ["STM32H7xx"],  # CubeRedSecondary, CubeRedSecondary-IO
    120: ["STM32F7xx"],  # CubeYellow
    1061: ["STM32H7xx"],  # DevEBoxH7v2
    5800: ["STM32F4xx"],  # DroneerF405
    13: ["STM32F4xx"],  # DrotekP3Pro
    139: ["STM32H7xx"],  # Durandal, NucleoH743, NucleoH755
    135: ["STM32F4xx"],  # F35Lightning
    20: ["STM32F4xx"],  # F4BY
    1530: ["STM32F4xx"],  # F4BY_F427
    1067: ["STM32F4xx"],  # FlyingMoonF407
    1068: ["STM32F4xx"],  # FlyingMoonF427
    1112: ["STM32H7xx"],  # FlyingMoonH743
    1180: ["STM32F4xx"],  # FlywooF405HD-AIOv2
    1137: ["STM32F4xx"],  # FlywooF405Pro
    1099: ["STM32F4xx"],  # FlywooF405S-AIO
    1027: ["STM32F7xx"],  # FlywooF745
    1042: ["STM32F7xx"],  # FlywooF745Nano
    1181: ["STM32H7xx"],  # FlywooH743Pro
    1157: ["STM32F4xx"],  # FoxeerF405v2
    1089: ["STM32H7xx"],  # FoxeerH743v1
    1028: ["STM32F7xx"],  # FreeflyRTK
    1502: ["STM32H7xx"],  # GEPRC_TAKER_H743
    1501: ["STM32F7xx"],  # GEPRCF745BTHD
    146: ["STM32H7xx"],  # H757I_EVAL, H757I_EVAL_intf
    1119: ["STM32F4xx"],  # HEEWING-F405, HEEWING-F405v2
    1043: ["STM32H7xx"],  # Here4AP, Here4FC
    5401: ["STM32F4xx"],  # HolybroF4_PMU
    1173: ["STM32H7xx"],  # IFLIGHT_2RAW_H7
    1084: ["STM32F7xx"],  # JFB100
    1110: ["STM32H7xx"],  # JFB110
    1081: ["STM32F4xx"],  # JHEM_JHEF405
    1059: ["STM32F4xx"],  # JHEMCU-GSF405A, JHEMCU-GSF405A-RX2
    1411: ["STM32H7xx"],  # JHEMCU-H743HD
    122: ["STM32F4xx"],  # KakuteF4
    5406: ["STM32F4xx"],  # KakuteF4-Wing
    1030: ["STM32F4xx"],  # KakuteF4Mini
    123: ["STM32F7xx"],  # KakuteF7
    145: ["STM32F7xx"],  # KakuteF7Mini
    1048: ["STM32H7xx"],  # KakuteH7, KakuteH7v2
    1105: ["STM32H7xx"],  # KakuteH7-Wing
    1058: ["STM32H7xx"],  # KakuteH7Mini, KakuteH7Mini-Nand
    1315: ["STM32H7xx"],  # kha_eth
    1422: ["STM32F4xx"],  # LongBowF405WING
    4500: ["STM32F7xx"],  # LumenierLUXF765-NDAA
    11: ["STM32F4xx"],  # luminousbee4, Pixracer
    1029: ["STM32H7xx"],  # luminousbee5
    1038: ["STM32F4xx"],  # MambaF405-2022
    1019: ["STM32F4xx"],  # MambaF405v2
    1073: ["STM32H7xx"],  # MambaH743v4
    125: ["STM32F4xx"],  # MatekF405, MatekF405-STD
    1014: ["STM32F4xx"],  # MatekF405-CAN
    1054: ["STM32F4xx"],  # MatekF405-TE
    127: ["STM32F4xx"],  # MatekF405-Wing
    143: ["STM32F7xx"],  # MatekF765-SE, MatekF765-Wing
    1170: ["STM32G474"],  # MatekG474
    1013: ["STM32H7xx"],  # MatekH743
    1149: ["STM32H7xx"],  # MatekH7A3
    188: ["STM32F7xx"],  # MazzyStarDrone
    6101: ["STM32F4xx"],  # MFE_POS3_CAN
    2000: ["STM32H7xx"],  # MFT-SEMA100
    1161: ["STM32F4xx"],  # MicoAir405Mini
    1150: ["STM32F4xx"],  # MicoAir405v2
    1166: ["STM32H7xx"],  # MicoAir743
    1176: ["STM32H7xx"],  # MicoAir743-AIO
    1179: ["STM32H7xx"],  # MicoAir743v2
    88: ["STM32F4xx"],  # mindpx-v2
    3: ["STM32F4xx"],  # mini-pix
    41775: ["STM32F7xx"],  # modalai_fc-v1
    1041: ["STM32G4xx"],  # mRo-M10095
    1098: ["STM32G4xx"],  # mRoCANPWM-M10126
    1022: ["STM32H7xx"],  # mRoControlZeroClassic
    141: ["STM32F7xx"],  # mRoControlZeroF7
    1023: ["STM32H7xx"],  # mRoControlZeroH7
    1024: ["STM32H7xx"],  # mRoControlZeroOEMH7, mRoCZeroOEMH7
    1015: ["STM32H7xx"],  # mRoNexus
    1017: ["STM32H7xx"],  # mRoPixracerPro
    136: ["STM32F7xx"],  # mRoX21-777
    1222: ["STM32F7xx"],  # MUPilot
    1040: ["STM32G491"],  # Nucleo-G491
    1051: ["STM32L476"],  # Nucleo-L476
    1047: ["STM32L496"],  # Nucleo-L496
    1159: ["STM32H7xx"],  # NxtPX4v2
    1002: ["STM32F4xx"],  # omnibusf4
    131: ["STM32F4xx"],  # omnibusf4pro, omnibusf4pro-one
    137: ["STM32F4xx"],  # omnibusf4v6
    121: ["STM32F7xx"],  # OMNIBUSF7V2
    133: ["STM32F4xx"],  # OmnibusNanoV6
    1155: ["STM32F4xx"],  # OrqaF405Pro
    1032: ["STM32H7xx"],  # PixC4-Jetson
    1090: ["STM32L4xx"],  # PixFlamingo
    1131: ["STM32F7xx"],  # PixFlamingo-F767
    51: ["STM32F7xx"],  # Pixhawk5X
    56: ["STM32H7xx"],  # Pixhawk6C
    53: ["STM32H7xx"],  # Pixhawk6X
    1408: ["STM32H7xx"],  # Pixhawk6X-PPPGW
    1140: ["STM32F4xx"],  # PixPilot-C3
    1096: ["STM32F4xx"],  # PixPilot-V3
    1083: ["STM32H7xx"],  # PixPilot-V6
    1160: ["STM32H7xx"],  # PixPilot-V6PRO
    1076: ["STM32F4xx"],  # PixSurveyA1
    1107: ["STM32F4xx"],  # PixSurveyA1-IND
    1097: ["STM32H7xx"],  # PixSurveyA2
    1065: ["CKS32F4xx"],  # QioTekAdeptF407
    1021: ["STM32F4xx"],  # QioTekZealotF427
    1036: ["STM32H7xx"],  # QioTekZealotH743
    1008: ["STM32F7xx"],  # R9Pilot
    1410: ["STM32F7xx"],  # RadiolinkPIX6
    1118: ["STM32H7xx"],  # RADIX2HD
    1074: ["STM32F7xx"],  # ReaperF745
    124: ["STM32F4xx"],  # revo-mini, revo-mini-i2c, revo-mini-sd
    1102: ["STM32H7xx"],  # rFCU
    1103: ["STM32G4xx"],  # rGNSS
    1111: ["STM32H7xx"],  # SDMODELH7V1
    1167: ["STM32H7xx"],  # SDMODELH7V2
    1052: ["STM32F4xx"],  # Sierra-F405
    1055: ["STM32F4xx"],  # Sierra-F412
    1034: ["STM32F4xx"],  # Sierra-F9P
    1050: ["STM32L431"],  # Sierra-L431
    1095: ["STM32F4xx"],  # Sierra-PrecisionPoint
    5302: ["STM32L431"],  # Sierra-TrueNavIC
    1091: ["STM32L431"],  # Sierra-TrueNavPro
    5301: ["STM32G4xx"],  # Sierra-TrueNavPro-G4
    1093: ["STM32L431"],  # Sierra-TrueNorth
    1094: ["STM32L431"],  # Sierra-TrueSpeed
    1123: ["STM32H7xx"],  # SIYI_N7
    2714: ["STM32H7xx"],  # SkySakuraH743
    1075: ["STM32H7xx"],  # SkystarsH7HD
    130: ["STM32F4xx"],  # sparky2
    134: ["STM32F4xx"],  # speedybeef4
    5271: ["STM32F4xx"],  # SpeedyBeeF405AIO
    1135: ["STM32F4xx"],  # SpeedyBeeF405Mini
    1106: ["STM32F4xx"],  # SpeedyBeeF405WING
    1082: ["STM32F4xx"],  # speedybeef4v3
    1136: ["STM32F4xx"],  # speedybeef4v4
    1060: ["STM32H7xx"],  # SPRacingH7
    1108: ["STM32H7xx"],  # SPRacingH7RF
    1500: ["STM32F4xx"],  # StellarF4
    1504: ["STM32F4xx"],  # StellarF4V2
    1503: ["STM32H7xx"],  # StellarH7V2
    1011: ["STM32F4xx"],  # SuccexF4
    2005: ["STM32H7xx"],  # SULILGH7-P1-P2
    6001: ["STM32F4xx"],  # sw-boom-f407
    6002: ["STM32F4xx"],  # sw-nav-f405
    6000: ["STM32F4xx"],  # sw-spar-f407
    5250: ["STM32H7xx"],  # TBS_LUCID_H7
    5251: ["STM32F4xx"],  # TBS_LUCID_PRO
    212: ["STM32F4xx"],  # thepeach-k1
    213: ["STM32F4xx"],  # thepeach-r1
    1138: ["STM32H7xx"],  # TMotorH743
    1151: ["STM32F4xx"],  # VRBrain-v51
    1152: ["STM32F4xx"],  # VRBrain-v52
    1154: ["STM32F4xx"],  # VRBrain-v54
    1910: ["STM32F4xx"],  # VRCore-v10
    1351: ["STM32F4xx"],  # VRUBrain-v51
    7100: ["STM32H7xx"],  # VUAV-V7pro
    1174: ["STM32H7xx"],  # X-MAV-AP-H743v2
    1113: ["STM32H7xx"],  # YJUAV_A6
    1127: ["STM32H7xx"],  # YJUAV_A6SE
    1141: ["STM32H7xx"],  # YJUAV_A6SE_H743
    1144: ["STM32H7xx"],  # YJUAV_A6Ultra
    5600: ["STM32H7xx"],  # ZeroOneX6, ZeroOneX6_Air
}

# Maps MCU series to 16-bit APJ board ID for 246 supported boards
MCU_SERIES_APJ_BOARD_ID_DICT: dict[str, list[int]] = {
    "CKS32F4xx": [1134, 1065],  # AR-F407SmartBat, QioTekAdeptF407
    "STM32F4xx": [1115, 1116, 128, 83, 1078, 1125, 1044, 1085, 1064, 1177, 12, 1158, 9, 1003, 5800, 13, 135, 20, 1530, 1067, 1068, 1180, 1137, 1099, 1157, 1119, 5401, 1081, 1059, 122, 5406, 1030, 1422, 11, 1038, 1019, 125, 1014, 1054, 127, 6101, 1161, 1150, 88, 3, 1002, 131, 137, 133, 1155, 1140, 1096, 1076, 1107, 1021, 124, 1052, 1055, 1034, 1095, 130, 134, 5271, 1135, 1106, 1082, 1136, 1500, 1504, 1011, 6001, 6002, 6000, 5251, 212, 213, 1151, 1152, 1154, 1910, 1351],  # ACNS-CM4Pilot, ACNS-F405AIO, airbotf4, ARK_CANNODE, AtomRCF405NAVI, BETAFPV-F405, BirdCANdy, C-RTK2-HP, CarbonixF405, CrazyF405, crazyflie2, CSKY405, CUAV-Pixhack-v3, CubeBlack, CubeGreen-solo, CubePurple, CubeSolo, fmuv2, fmuv3, mRoX21, Pixhawk1, Pixhawk1-1M, skyviper-f412-rev1, skyviper-journey, skyviper-v2450, CubeBlack+, DroneerF405, DrotekP3Pro, F35Lightning, F4BY, F4BY_F427, FlyingMoonF407, FlyingMoonF427, FlywooF405HD-AIOv2, FlywooF405Pro, FlywooF405S-AIO, FoxeerF405v2, HEEWING-F405, HEEWING-F405v2, HolybroF4_PMU, JHEM_JHEF405, JHEMCU-GSF405A, JHEMCU-GSF405A-RX2, KakuteF4, KakuteF4-Wing, KakuteF4Mini, LongBowF405WING, luminousbee4, Pixracer, MambaF405-2022, MambaF405v2, MatekF405, MatekF405-STD, MatekF405-CAN, MatekF405-TE, MatekF405-Wing, MFE_POS3_CAN, MicoAir405Mini, MicoAir405v2, mindpx-v2, mini-pix, omnibusf4, omnibusf4pro, omnibusf4pro-one, omnibusf4v6, OmnibusNanoV6, OrqaF405Pro, PixPilot-C3, PixPilot-V3, PixSurveyA1, PixSurveyA1-IND, QioTekZealotF427, revo-mini, revo-mini-i2c, revo-mini-sd, Sierra-F405, Sierra-F412, Sierra-F9P, Sierra-PrecisionPoint, sparky2, speedybeef4, SpeedyBeeF405AIO, SpeedyBeeF405Mini, SpeedyBeeF405WING, speedybeef4v3, speedybeef4v4, StellarF4, StellarF4V2, SuccexF4, sw-boom-f407, sw-nav-f405, sw-spar-f407, TBS_LUCID_PRO, thepeach-k1, thepeach-r1, VRBrain-v51, VRBrain-v52, VRBrain-v54, VRCore-v10, VRUBrain-v51
    "STM32F7xx": [55, 1026, 1057, 1164, 1117, 1163, 50, 120, 1027, 1042, 1028, 1501, 1084, 123, 145, 4500, 143, 188, 41775, 141, 136, 1222, 121, 1131, 51, 1008, 1410, 1074],  # AIRLink, BeastF7, BeastF7v2, BlitzF745, BlitzF745AIO, BlitzMiniF745, CUAVv5, CUAVv5Nano, fmuv5, PH4-mini, Pix32v5, Pixhawk4, Swan-K1, TBS-Colibri-F7, CubeYellow, FlywooF745, FlywooF745Nano, FreeflyRTK, GEPRCF745BTHD, JFB100, KakuteF7, KakuteF7Mini, LumenierLUXF765-NDAA, MatekF765-SE, MatekF765-Wing, MazzyStarDrone, modalai_fc-v1, mRoControlZeroF7, mRoX21-777, MUPilot, OMNIBUSF7V2, PixFlamingo-F767, Pixhawk5X, R9Pilot, RadiolinkPIX6, ReaperF745
    "STM32G474": [1170],  # MatekG474
    "STM32G491": [1040],  # Nucleo-G491
    "STM32G4xx": [1041, 1098, 1103, 5301],  # mRo-M10095, mRoCANPWM-M10126, rGNSS, Sierra-TrueNavPro-G4
    "STM32H7xx": [1124, 7110, 2024, 5200, 1146, 5210, 59, 57, 1025, 1056, 1162, 1168, 1148, 1182, 1156, 7000, 1009, 1010, 1079, 140, 1033, 1063, 1069, 1409, 1070, 1061, 139, 1112, 1181, 1089, 1502, 146, 1043, 1173, 1110, 1411, 1048, 1105, 1058, 1315, 1029, 1073, 1013, 1149, 2000, 1166, 1176, 1179, 1022, 1023, 1024, 1015, 1017, 1159, 1032, 56, 53, 1408, 1083, 1160, 1097, 1036, 1118, 1102, 1111, 1167, 1123, 2714, 1075, 1060, 1108, 1503, 2005, 5250, 1138, 7100, 1174, 1113, 1127, 1141, 1144, 5600],  # 3DRControlZeroG, AEROFOX-H7, AET-H743-Basic, Airvolute-DCS2, AnyleafH7, Aocoda-RC-H743Dual, ARK_FPV, ARKV6X, BeastH7, BeastH7v2, BlitzH743Pro, BlitzWingH743, BotBloxDroneNet, CBU-H7-LC-Stamp, CBU-H7-Stamp, CUAV-7-Nano, CUAV-Nora, CUAV-X7, CubeNode, CubeOrange, CubeOrange-joey, CubeOrangePlus, CubeRedPrimary, CubeRedPrimary-PPPGW, CubeRedSecondary, CubeRedSecondary-IO, DevEBoxH7v2, Durandal, NucleoH743, NucleoH755, FlyingMoonH743, FlywooH743Pro, FoxeerH743v1, GEPRC_TAKER_H743, H757I_EVAL, H757I_EVAL_intf, Here4AP, Here4FC, IFLIGHT_2RAW_H7, JFB110, JHEMCU-H743HD, KakuteH7, KakuteH7v2, KakuteH7-Wing, KakuteH7Mini, KakuteH7Mini-Nand, kha_eth, luminousbee5, MambaH743v4, MatekH743, MatekH7A3, MFT-SEMA100, MicoAir743, MicoAir743-AIO, MicoAir743v2, mRoControlZeroClassic, mRoControlZeroH7, mRoControlZeroOEMH7, mRoCZeroOEMH7, mRoNexus, mRoPixracerPro, NxtPX4v2, PixC4-Jetson, Pixhawk6C, Pixhawk6X, Pixhawk6X-PPPGW, PixPilot-V6, PixPilot-V6PRO, PixSurveyA2, QioTekZealotH743, RADIX2HD, rFCU, SDMODELH7V1, SDMODELH7V2, SIYI_N7, SkySakuraH743, SkystarsH7HD, SPRacingH7, SPRacingH7RF, StellarH7V2, SULILGH7-P1-P2, TBS_LUCID_H7, TMotorH743, VUAV-V7pro, X-MAV-AP-H743v2, YJUAV_A6, YJUAV_A6SE, YJUAV_A6SE_H743, YJUAV_A6Ultra, ZeroOneX6, ZeroOneX6_Air
    "STM32L431": [1109, 1080, 1050, 5302, 1091, 1093, 1094],  # AeroFox-GNSS_F9P, AeroFox-PMU, Sierra-L431, Sierra-TrueNavIC, Sierra-TrueNavPro, Sierra-TrueNorth, Sierra-TrueSpeed
    "STM32L476": [1051],  # Nucleo-L476
    "STM32L496": [1053, 1047],  # CarbonixL496, Nucleo-L496
    "STM32L4xx": [1090],  # PixFlamingo
}
