# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDeploymentTemplatesResult',
    'AwaitableGetDeploymentTemplatesResult',
    'get_deployment_templates',
    'get_deployment_templates_output',
]

@pulumi.output_type
class GetDeploymentTemplatesResult:
    """
    A collection of values returned by getDeploymentTemplates.
    """
    def __init__(__self__, id=None, region=None, show_deprecated=None, stack_version=None, templates=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if show_deprecated and not isinstance(show_deprecated, bool):
            raise TypeError("Expected argument 'show_deprecated' to be a bool")
        pulumi.set(__self__, "show_deprecated", show_deprecated)
        if stack_version and not isinstance(stack_version, str):
            raise TypeError("Expected argument 'stack_version' to be a str")
        pulumi.set(__self__, "stack_version", stack_version)
        if templates and not isinstance(templates, list):
            raise TypeError("Expected argument 'templates' to be a list")
        pulumi.set(__self__, "templates", templates)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Filters for a deployment template with this id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region to select. For Elastic Cloud Enterprise (ECE) installations, use `ece-region`.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="showDeprecated")
    def show_deprecated(self) -> Optional[builtins.bool]:
        """
        Enable to also show deprecated deployment templates. (Set to false by default.)
        """
        return pulumi.get(self, "show_deprecated")

    @property
    @pulumi.getter(name="stackVersion")
    def stack_version(self) -> Optional[builtins.str]:
        """
        Filters for deployment templates compatible with this stack version.
        """
        return pulumi.get(self, "stack_version")

    @property
    @pulumi.getter
    def templates(self) -> Sequence['outputs.GetDeploymentTemplatesTemplateResult']:
        """
        List of available deployment templates.
        """
        return pulumi.get(self, "templates")


class AwaitableGetDeploymentTemplatesResult(GetDeploymentTemplatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentTemplatesResult(
            id=self.id,
            region=self.region,
            show_deprecated=self.show_deprecated,
            stack_version=self.stack_version,
            templates=self.templates)


def get_deployment_templates(id: Optional[builtins.str] = None,
                             region: Optional[builtins.str] = None,
                             show_deprecated: Optional[builtins.bool] = None,
                             stack_version: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentTemplatesResult:
    """
    Use this data source to retrieve a list of available deployment templates.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ec as ec

    example = ec.get_deployment_templates(region="us-east-1")
    my_deployment = ec.Deployment("my_deployment",
        name="My Deployment",
        version="8.12.2",
        region=all_templates["region"],
        deployment_template_id=all_templates["templates"][0]["id"],
        elasticsearch={
            "hot": {
                "autoscaling": {},
            },
        },
        kibana={})
    ```


    :param builtins.str id: Filters for a deployment template with this id.
    :param builtins.str region: Region to select. For Elastic Cloud Enterprise (ECE) installations, use `ece-region`.
    :param builtins.bool show_deprecated: Enable to also show deprecated deployment templates. (Set to false by default.)
    :param builtins.str stack_version: Filters for deployment templates compatible with this stack version.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    __args__['showDeprecated'] = show_deprecated
    __args__['stackVersion'] = stack_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ec:index/getDeploymentTemplates:getDeploymentTemplates', __args__, opts=opts, typ=GetDeploymentTemplatesResult).value

    return AwaitableGetDeploymentTemplatesResult(
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        show_deprecated=pulumi.get(__ret__, 'show_deprecated'),
        stack_version=pulumi.get(__ret__, 'stack_version'),
        templates=pulumi.get(__ret__, 'templates'))
def get_deployment_templates_output(id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    region: Optional[pulumi.Input[builtins.str]] = None,
                                    show_deprecated: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                    stack_version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeploymentTemplatesResult]:
    """
    Use this data source to retrieve a list of available deployment templates.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ec as ec

    example = ec.get_deployment_templates(region="us-east-1")
    my_deployment = ec.Deployment("my_deployment",
        name="My Deployment",
        version="8.12.2",
        region=all_templates["region"],
        deployment_template_id=all_templates["templates"][0]["id"],
        elasticsearch={
            "hot": {
                "autoscaling": {},
            },
        },
        kibana={})
    ```


    :param builtins.str id: Filters for a deployment template with this id.
    :param builtins.str region: Region to select. For Elastic Cloud Enterprise (ECE) installations, use `ece-region`.
    :param builtins.bool show_deprecated: Enable to also show deprecated deployment templates. (Set to false by default.)
    :param builtins.str stack_version: Filters for deployment templates compatible with this stack version.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    __args__['showDeprecated'] = show_deprecated
    __args__['stackVersion'] = stack_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ec:index/getDeploymentTemplates:getDeploymentTemplates', __args__, opts=opts, typ=GetDeploymentTemplatesResult)
    return __ret__.apply(lambda __response__: GetDeploymentTemplatesResult(
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        show_deprecated=pulumi.get(__response__, 'show_deprecated'),
        stack_version=pulumi.get(__response__, 'stack_version'),
        templates=pulumi.get(__response__, 'templates')))
