"""Implementations of 'EnumWithSelectedValue' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""

from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private._internal import mixins
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.gears.micro_geometry import _586

_ARRAY = python_net_import("System", "Array")
_ENUM_WITH_SELECTED_VALUE = python_net_import(
    "SMT.MastaAPI.Utility.Property", "EnumWithSelectedValue"
)

if TYPE_CHECKING:
    from typing import Any, List, Type, TypeVar

    Self = TypeVar("Self", bound="EnumWithSelectedValue_LocationOfEvaluationLowerLimit")


__docformat__ = "restructuredtext en"
__all__ = ("EnumWithSelectedValue_LocationOfEvaluationLowerLimit",)


class EnumWithSelectedValue_LocationOfEvaluationLowerLimit(
    mixins.EnumWithSelectedValueMixin, Enum
):
    """EnumWithSelectedValue_LocationOfEvaluationLowerLimit

    A specific implementation of 'EnumWithSelectedValue' for 'LocationOfEvaluationLowerLimit' types.
    """

    __qualname__ = "LocationOfEvaluationLowerLimit"

    @classmethod
    def wrapper_type(
        cls: "Type[EnumWithSelectedValue_LocationOfEvaluationLowerLimit]",
    ) -> "Any":
        """Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _ENUM_WITH_SELECTED_VALUE

    @classmethod
    def wrapped_type(
        cls: "Type[EnumWithSelectedValue_LocationOfEvaluationLowerLimit]",
    ) -> "_586.LocationOfEvaluationLowerLimit":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly

        Returns:
            _586.LocationOfEvaluationLowerLimit
        """
        return _586.LocationOfEvaluationLowerLimit

    @classmethod
    def implicit_type(
        cls: "Type[EnumWithSelectedValue_LocationOfEvaluationLowerLimit]",
    ) -> "Any":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _586.LocationOfEvaluationLowerLimit.type_()

    @property
    def selected_value(self: "Self") -> "_586.LocationOfEvaluationLowerLimit":
        """mastapy.gears.micro_geometry.LocationOfEvaluationLowerLimit

        Note:
            This property is readonly.
        """
        return None

    @property
    def available_values(self: "Self") -> "List[_586.LocationOfEvaluationLowerLimit]":
        """List[mastapy.gears.micro_geometry.LocationOfEvaluationLowerLimit]

        Note:
            This property is readonly.
        """
        return None
