"""Implementations of 'EnumWithSelectedValue' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""

from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private._internal import mixins
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.system_model.part_model.couplings import _2658

_ARRAY = python_net_import("System", "Array")
_ENUM_WITH_SELECTED_VALUE = python_net_import(
    "SMT.MastaAPI.Utility.Property", "EnumWithSelectedValue"
)

if TYPE_CHECKING:
    from typing import Any, List, Type, TypeVar

    Self = TypeVar("Self", bound="EnumWithSelectedValue_RigidConnectorToothSpacingType")


__docformat__ = "restructuredtext en"
__all__ = ("EnumWithSelectedValue_RigidConnectorToothSpacingType",)


class EnumWithSelectedValue_RigidConnectorToothSpacingType(
    mixins.EnumWithSelectedValueMixin, Enum
):
    """EnumWithSelectedValue_RigidConnectorToothSpacingType

    A specific implementation of 'EnumWithSelectedValue' for 'RigidConnectorToothSpacingType' types.
    """

    __qualname__ = "RigidConnectorToothSpacingType"

    @classmethod
    def wrapper_type(
        cls: "Type[EnumWithSelectedValue_RigidConnectorToothSpacingType]",
    ) -> "Any":
        """Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _ENUM_WITH_SELECTED_VALUE

    @classmethod
    def wrapped_type(
        cls: "Type[EnumWithSelectedValue_RigidConnectorToothSpacingType]",
    ) -> "_2658.RigidConnectorToothSpacingType":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly

        Returns:
            _2658.RigidConnectorToothSpacingType
        """
        return _2658.RigidConnectorToothSpacingType

    @classmethod
    def implicit_type(
        cls: "Type[EnumWithSelectedValue_RigidConnectorToothSpacingType]",
    ) -> "Any":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _2658.RigidConnectorToothSpacingType.type_()

    @property
    def selected_value(self: "Self") -> "_2658.RigidConnectorToothSpacingType":
        """mastapy.system_model.part_model.couplings.RigidConnectorToothSpacingType

        Note:
            This property is readonly.
        """
        return None

    @property
    def available_values(self: "Self") -> "List[_2658.RigidConnectorToothSpacingType]":
        """List[mastapy.system_model.part_model.couplings.RigidConnectorToothSpacingType]

        Note:
            This property is readonly.
        """
        return None
