"""Implementations of 'EnumWithSelectedValue' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""

from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private._internal import mixins
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.detailed_rigid_connectors.splines import _1467

_ARRAY = python_net_import("System", "Array")
_ENUM_WITH_SELECTED_VALUE = python_net_import(
    "SMT.MastaAPI.Utility.Property", "EnumWithSelectedValue"
)

if TYPE_CHECKING:
    from typing import Any, List, Type, TypeVar

    Self = TypeVar("Self", bound="EnumWithSelectedValue_SplineRatingTypes")


__docformat__ = "restructuredtext en"
__all__ = ("EnumWithSelectedValue_SplineRatingTypes",)


class EnumWithSelectedValue_SplineRatingTypes(mixins.EnumWithSelectedValueMixin, Enum):
    """EnumWithSelectedValue_SplineRatingTypes

    A specific implementation of 'EnumWithSelectedValue' for 'SplineRatingTypes' types.
    """

    __qualname__ = "SplineRatingTypes"

    @classmethod
    def wrapper_type(cls: "Type[EnumWithSelectedValue_SplineRatingTypes]") -> "Any":
        """Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _ENUM_WITH_SELECTED_VALUE

    @classmethod
    def wrapped_type(
        cls: "Type[EnumWithSelectedValue_SplineRatingTypes]",
    ) -> "_1467.SplineRatingTypes":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly

        Returns:
            _1467.SplineRatingTypes
        """
        return _1467.SplineRatingTypes

    @classmethod
    def implicit_type(cls: "Type[EnumWithSelectedValue_SplineRatingTypes]") -> "Any":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _1467.SplineRatingTypes.type_()

    @property
    def selected_value(self: "Self") -> "_1467.SplineRatingTypes":
        """mastapy.detailed_rigid_connectors.splines.SplineRatingTypes

        Note:
            This property is readonly.
        """
        return None

    @property
    def available_values(self: "Self") -> "List[_1467.SplineRatingTypes]":
        """List[mastapy.detailed_rigid_connectors.splines.SplineRatingTypes]

        Note:
            This property is readonly.
        """
        return None
