"""Implementations of 'EnumWithSelectedValue' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""

from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private._internal import mixins
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.detailed_rigid_connectors.interference_fits import _1498

_ARRAY = python_net_import("System", "Array")
_ENUM_WITH_SELECTED_VALUE = python_net_import(
    "SMT.MastaAPI.Utility.Property", "EnumWithSelectedValue"
)

if TYPE_CHECKING:
    from typing import Any, List, Type, TypeVar

    Self = TypeVar("Self", bound="EnumWithSelectedValue_Table4JointInterfaceTypes")


__docformat__ = "restructuredtext en"
__all__ = ("EnumWithSelectedValue_Table4JointInterfaceTypes",)


class EnumWithSelectedValue_Table4JointInterfaceTypes(
    mixins.EnumWithSelectedValueMixin, Enum
):
    """EnumWithSelectedValue_Table4JointInterfaceTypes

    A specific implementation of 'EnumWithSelectedValue' for 'Table4JointInterfaceTypes' types.
    """

    __qualname__ = "Table4JointInterfaceTypes"

    @classmethod
    def wrapper_type(
        cls: "Type[EnumWithSelectedValue_Table4JointInterfaceTypes]",
    ) -> "Any":
        """Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _ENUM_WITH_SELECTED_VALUE

    @classmethod
    def wrapped_type(
        cls: "Type[EnumWithSelectedValue_Table4JointInterfaceTypes]",
    ) -> "_1498.Table4JointInterfaceTypes":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly

        Returns:
            _1498.Table4JointInterfaceTypes
        """
        return _1498.Table4JointInterfaceTypes

    @classmethod
    def implicit_type(
        cls: "Type[EnumWithSelectedValue_Table4JointInterfaceTypes]",
    ) -> "Any":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _1498.Table4JointInterfaceTypes.type_()

    @property
    def selected_value(self: "Self") -> "_1498.Table4JointInterfaceTypes":
        """mastapy.detailed_rigid_connectors.interference_fits.Table4JointInterfaceTypes

        Note:
            This property is readonly.
        """
        return None

    @property
    def available_values(self: "Self") -> "List[_1498.Table4JointInterfaceTypes]":
        """List[mastapy.detailed_rigid_connectors.interference_fits.Table4JointInterfaceTypes]

        Note:
            This property is readonly.
        """
        return None
