"""Implementations of 'Overridable' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""

from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private._internal import mixins
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.bearings.bearing_designs.rolling import _2232

_OVERRIDABLE = python_net_import("SMT.MastaAPI.Utility.Property", "Overridable")

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="Overridable_WidthSeries")


__docformat__ = "restructuredtext en"
__all__ = ("Overridable_WidthSeries",)


class Overridable_WidthSeries(mixins.OverridableMixin, Enum):
    """Overridable_WidthSeries

    A specific implementation of 'Overridable' for 'WidthSeries' types.
    """

    __qualname__ = "WidthSeries"

    @classmethod
    def wrapper_type(cls: "Type[Overridable_WidthSeries]") -> "Any":
        """Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _OVERRIDABLE

    @classmethod
    def wrapped_type(cls: "Type[Overridable_WidthSeries]") -> "_2232.WidthSeries":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly

        Returns:
            _2232.WidthSeries
        """
        return _2232.WidthSeries

    @classmethod
    def implicit_type(cls: "Type[Overridable_WidthSeries]") -> "Any":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _2232.WidthSeries.type_()

    @property
    def value(self: "Self") -> "_2232.WidthSeries":
        """mastapy.bearings.bearing_designs.rolling.WidthSeries

        Note:
            This property is readonly.
        """
        return None

    @property
    def overridden(self: "Self") -> "bool":
        """bool

        Note:
            This property is readonly.
        """
        return None

    @property
    def override_value(self: "Self") -> "_2232.WidthSeries":
        """mastapy.bearings.bearing_designs.rolling.WidthSeries

        Note:
            This property is readonly.
        """
        return None

    @property
    def calculated_value(self: "Self") -> "_2232.WidthSeries":
        """mastapy.bearings.bearing_designs.rolling.WidthSeries

        Note:
            This property is readonly.
        """
        return None
