"""ElementForce"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private import _0
from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_property_get,
)

_ELEMENT_FORCE = python_net_import(
    "SMT.MastaAPI.Bearings.BearingResults", "ElementForce"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="ElementForce")
    CastSelf = TypeVar("CastSelf", bound="ElementForce._Cast_ElementForce")


__docformat__ = "restructuredtext en"
__all__ = ("ElementForce",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_ElementForce:
    """Special nested class for casting ElementForce to subclasses."""

    __parent__: "ElementForce"

    @property
    def element_force(self: "CastSelf") -> "ElementForce":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class ElementForce(_0.APIBase):
    """ElementForce

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _ELEMENT_FORCE

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def axial(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Axial")

        if temp is None:
            return 0.0

        return temp

    @property
    def moment(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Moment")

        if temp is None:
            return 0.0

        return temp

    @property
    def radial(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Radial")

        if temp is None:
            return 0.0

        return temp

    @property
    def cast_to(self: "Self") -> "_Cast_ElementForce":
        """Cast to another type.

        Returns:
            _Cast_ElementForce
        """
        return _Cast_ElementForce(self)
