"""RollingBearingSpeedResults"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private import _0
from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_property_get,
)

_ROLLING_BEARING_SPEED_RESULTS = python_net_import(
    "SMT.MastaAPI.Bearings.BearingResults.Rolling", "RollingBearingSpeedResults"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="RollingBearingSpeedResults")
    CastSelf = TypeVar(
        "CastSelf", bound="RollingBearingSpeedResults._Cast_RollingBearingSpeedResults"
    )


__docformat__ = "restructuredtext en"
__all__ = ("RollingBearingSpeedResults",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_RollingBearingSpeedResults:
    """Special nested class for casting RollingBearingSpeedResults to subclasses."""

    __parent__: "RollingBearingSpeedResults"

    @property
    def rolling_bearing_speed_results(self: "CastSelf") -> "RollingBearingSpeedResults":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class RollingBearingSpeedResults(_0.APIBase):
    """RollingBearingSpeedResults

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _ROLLING_BEARING_SPEED_RESULTS

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def absolute_element_passing_order(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "AbsoluteElementPassingOrder")

        if temp is None:
            return 0.0

        return temp

    @property
    def element_spin_order(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "ElementSpinOrder")

        if temp is None:
            return 0.0

        return temp

    @property
    def fundamental_train_order(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "FundamentalTrainOrder")

        if temp is None:
            return 0.0

        return temp

    @property
    def inner_race_element_passing_order(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "InnerRaceElementPassingOrder")

        if temp is None:
            return 0.0

        return temp

    @property
    def outer_race_element_passing_order(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "OuterRaceElementPassingOrder")

        if temp is None:
            return 0.0

        return temp

    @property
    def cast_to(self: "Self") -> "_Cast_RollingBearingSpeedResults":
        """Cast to another type.

        Returns:
            _Cast_RollingBearingSpeedResults
        """
        return _Cast_RollingBearingSpeedResults(self)
