"""OuterSupportTolerance"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.bearings.tolerances import _1977

_OUTER_SUPPORT_TOLERANCE = python_net_import(
    "SMT.MastaAPI.Bearings.Tolerances", "OuterSupportTolerance"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private.bearings.tolerances import _1956, _1964

    Self = TypeVar("Self", bound="OuterSupportTolerance")
    CastSelf = TypeVar(
        "CastSelf", bound="OuterSupportTolerance._Cast_OuterSupportTolerance"
    )


__docformat__ = "restructuredtext en"
__all__ = ("OuterSupportTolerance",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_OuterSupportTolerance:
    """Special nested class for casting OuterSupportTolerance to subclasses."""

    __parent__: "OuterSupportTolerance"

    @property
    def support_tolerance(self: "CastSelf") -> "_1977.SupportTolerance":
        return self.__parent__._cast(_1977.SupportTolerance)

    @property
    def interference_tolerance(self: "CastSelf") -> "_1964.InterferenceTolerance":
        from mastapy._private.bearings.tolerances import _1964

        return self.__parent__._cast(_1964.InterferenceTolerance)

    @property
    def bearing_connection_component(
        self: "CastSelf",
    ) -> "_1956.BearingConnectionComponent":
        from mastapy._private.bearings.tolerances import _1956

        return self.__parent__._cast(_1956.BearingConnectionComponent)

    @property
    def outer_support_tolerance(self: "CastSelf") -> "OuterSupportTolerance":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class OuterSupportTolerance(_1977.SupportTolerance):
    """OuterSupportTolerance

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _OUTER_SUPPORT_TOLERANCE

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def cast_to(self: "Self") -> "_Cast_OuterSupportTolerance":
        """Cast to another type.

        Returns:
            _Cast_OuterSupportTolerance
        """
        return _Cast_OuterSupportTolerance(self)
