"""GeometryToExport"""

from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private._internal.python_net import python_net_import

_GEOMETRY_TO_EXPORT = python_net_import("SMT.MastaAPI.Cycloidal", "GeometryToExport")

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="GeometryToExport")
    CastSelf = TypeVar("CastSelf", bound="GeometryToExport._Cast_GeometryToExport")


__docformat__ = "restructuredtext en"
__all__ = ("GeometryToExport",)


class GeometryToExport(Enum):
    """GeometryToExport

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls) -> "Type":
        return _GEOMETRY_TO_EXPORT

    SINGLE_LOBE = 0
    WHOLE_DISC = 1


def __enum_setattr(self: "Self", attr: str, value: "Any") -> None:
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: "Self", attr: str) -> None:
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


GeometryToExport.__setattr__ = __enum_setattr
GeometryToExport.__delattr__ = __enum_delattr
