"""GBT17855SplineJointRating"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_property_get,
)
from mastapy._private.detailed_rigid_connectors.splines.ratings import _1482

_GBT17855_SPLINE_JOINT_RATING = python_net_import(
    "SMT.MastaAPI.DetailedRigidConnectors.Splines.Ratings", "GBT17855SplineJointRating"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private.detailed_rigid_connectors.rating import _1486

    Self = TypeVar("Self", bound="GBT17855SplineJointRating")
    CastSelf = TypeVar(
        "CastSelf", bound="GBT17855SplineJointRating._Cast_GBT17855SplineJointRating"
    )


__docformat__ = "restructuredtext en"
__all__ = ("GBT17855SplineJointRating",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_GBT17855SplineJointRating:
    """Special nested class for casting GBT17855SplineJointRating to subclasses."""

    __parent__: "GBT17855SplineJointRating"

    @property
    def spline_joint_rating(self: "CastSelf") -> "_1482.SplineJointRating":
        return self.__parent__._cast(_1482.SplineJointRating)

    @property
    def shaft_hub_connection_rating(
        self: "CastSelf",
    ) -> "_1486.ShaftHubConnectionRating":
        from mastapy._private.detailed_rigid_connectors.rating import _1486

        return self.__parent__._cast(_1486.ShaftHubConnectionRating)

    @property
    def gbt17855_spline_joint_rating(self: "CastSelf") -> "GBT17855SplineJointRating":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class GBT17855SplineJointRating(_1482.SplineJointRating):
    """GBT17855SplineJointRating

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _GBT17855_SPLINE_JOINT_RATING

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def application_factor(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "ApplicationFactor")

        if temp is None:
            return 0.0

        return temp

    @property
    def backlash_factor(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "BacklashFactor")

        if temp is None:
            return 0.0

        return temp

    @property
    def calculated_compressive_stress(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "CalculatedCompressiveStress")

        if temp is None:
            return 0.0

        return temp

    @property
    def calculated_maximum_tooth_shearing_stress(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(
            self.wrapped, "CalculatedMaximumToothShearingStress"
        )

        if temp is None:
            return 0.0

        return temp

    @property
    def calculated_root_bending_stress(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "CalculatedRootBendingStress")

        if temp is None:
            return 0.0

        return temp

    @property
    def distribution_factor(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "DistributionFactor")

        if temp is None:
            return 0.0

        return temp

    @property
    def equivalent_stress(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "EquivalentStress")

        if temp is None:
            return 0.0

        return temp

    @property
    def face_load_distribution_factor(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "FaceLoadDistributionFactor")

        if temp is None:
            return 0.0

        return temp

    @property
    def k_factor(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "KFactor")

        if temp is None:
            return 0.0

        return temp

    @property
    def name(self: "Self") -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Name")

        if temp is None:
            return ""

        return temp

    @property
    def safety_factor_for_compressive_stress(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "SafetyFactorForCompressiveStress")

        if temp is None:
            return 0.0

        return temp

    @property
    def safety_factor_for_equivalent_stress(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "SafetyFactorForEquivalentStress")

        if temp is None:
            return 0.0

        return temp

    @property
    def safety_factor_for_root_bending_stress(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "SafetyFactorForRootBendingStress")

        if temp is None:
            return 0.0

        return temp

    @property
    def safety_factor_for_tooth_shearing_stress(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(
            self.wrapped, "SafetyFactorForToothShearingStress"
        )

        if temp is None:
            return 0.0

        return temp

    @property
    def safety_factor_for_wearing_stress(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "SafetyFactorForWearingStress")

        if temp is None:
            return 0.0

        return temp

    @property
    def cast_to(self: "Self") -> "_Cast_GBT17855SplineJointRating":
        """Cast to another type.

        Returns:
            _Cast_GBT17855SplineJointRating
        """
        return _Cast_GBT17855SplineJointRating(self)
