"""CoreLossCoefficients"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private import _0
from mastapy._private._internal import conversion, utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_method_call,
    pythonnet_property_get,
    pythonnet_property_set,
)
from mastapy._private._internal.type_enforcement import enforce_parameter_types

_CORE_LOSS_COEFFICIENTS = python_net_import(
    "SMT.MastaAPI.ElectricMachines", "CoreLossCoefficients"
)

if TYPE_CHECKING:
    from typing import Any, List, Type, TypeVar

    Self = TypeVar("Self", bound="CoreLossCoefficients")
    CastSelf = TypeVar(
        "CastSelf", bound="CoreLossCoefficients._Cast_CoreLossCoefficients"
    )


__docformat__ = "restructuredtext en"
__all__ = ("CoreLossCoefficients",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_CoreLossCoefficients:
    """Special nested class for casting CoreLossCoefficients to subclasses."""

    __parent__: "CoreLossCoefficients"

    @property
    def core_loss_coefficients(self: "CastSelf") -> "CoreLossCoefficients":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class CoreLossCoefficients(_0.APIBase):
    """CoreLossCoefficients

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _CORE_LOSS_COEFFICIENTS

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def c_coefficient_eddy(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "CCoefficientEddy")

        if temp is None:
            return 0.0

        return temp

    @c_coefficient_eddy.setter
    @enforce_parameter_types
    def c_coefficient_eddy(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "CCoefficientEddy", float(value) if value is not None else 0.0
        )

    @property
    def c_coefficient_excess(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "CCoefficientExcess")

        if temp is None:
            return 0.0

        return temp

    @c_coefficient_excess.setter
    @enforce_parameter_types
    def c_coefficient_excess(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped,
            "CCoefficientExcess",
            float(value) if value is not None else 0.0,
        )

    @property
    def c_coefficient_hysteresis(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "CCoefficientHysteresis")

        if temp is None:
            return 0.0

        return temp

    @c_coefficient_hysteresis.setter
    @enforce_parameter_types
    def c_coefficient_hysteresis(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped,
            "CCoefficientHysteresis",
            float(value) if value is not None else 0.0,
        )

    @property
    def field_exponent_eddy(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "FieldExponentEddy")

        if temp is None:
            return 0.0

        return temp

    @field_exponent_eddy.setter
    @enforce_parameter_types
    def field_exponent_eddy(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped,
            "FieldExponentEddy",
            float(value) if value is not None else 0.0,
        )

    @property
    def field_exponent_excess(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "FieldExponentExcess")

        if temp is None:
            return 0.0

        return temp

    @field_exponent_excess.setter
    @enforce_parameter_types
    def field_exponent_excess(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped,
            "FieldExponentExcess",
            float(value) if value is not None else 0.0,
        )

    @property
    def field_exponent_hysteresis(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "FieldExponentHysteresis")

        if temp is None:
            return 0.0

        return temp

    @field_exponent_hysteresis.setter
    @enforce_parameter_types
    def field_exponent_hysteresis(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped,
            "FieldExponentHysteresis",
            float(value) if value is not None else 0.0,
        )

    @property
    def frequency_exponent_eddy(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "FrequencyExponentEddy")

        if temp is None:
            return 0.0

        return temp

    @frequency_exponent_eddy.setter
    @enforce_parameter_types
    def frequency_exponent_eddy(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped,
            "FrequencyExponentEddy",
            float(value) if value is not None else 0.0,
        )

    @property
    def frequency_exponent_excess(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "FrequencyExponentExcess")

        if temp is None:
            return 0.0

        return temp

    @frequency_exponent_excess.setter
    @enforce_parameter_types
    def frequency_exponent_excess(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped,
            "FrequencyExponentExcess",
            float(value) if value is not None else 0.0,
        )

    @property
    def frequency_exponent_hysteresis(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "FrequencyExponentHysteresis")

        if temp is None:
            return 0.0

        return temp

    @frequency_exponent_hysteresis.setter
    @enforce_parameter_types
    def frequency_exponent_hysteresis(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped,
            "FrequencyExponentHysteresis",
            float(value) if value is not None else 0.0,
        )

    @property
    def report_names(self: "Self") -> "List[str]":
        """List[str]

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "ReportNames")

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp, str)

        if value is None:
            return None

        return value

    @enforce_parameter_types
    def output_default_report_to(self: "Self", file_path: "str") -> None:
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        pythonnet_method_call(
            self.wrapped, "OutputDefaultReportTo", file_path if file_path else ""
        )

    def get_default_report_with_encoded_images(self: "Self") -> "str":
        """str"""
        method_result = pythonnet_method_call(
            self.wrapped, "GetDefaultReportWithEncodedImages"
        )
        return method_result

    @enforce_parameter_types
    def output_active_report_to(self: "Self", file_path: "str") -> None:
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        pythonnet_method_call(
            self.wrapped, "OutputActiveReportTo", file_path if file_path else ""
        )

    @enforce_parameter_types
    def output_active_report_as_text_to(self: "Self", file_path: "str") -> None:
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        pythonnet_method_call(
            self.wrapped, "OutputActiveReportAsTextTo", file_path if file_path else ""
        )

    def get_active_report_with_encoded_images(self: "Self") -> "str":
        """str"""
        method_result = pythonnet_method_call(
            self.wrapped, "GetActiveReportWithEncodedImages"
        )
        return method_result

    @enforce_parameter_types
    def output_named_report_to(
        self: "Self", report_name: "str", file_path: "str"
    ) -> None:
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        pythonnet_method_call(
            self.wrapped,
            "OutputNamedReportTo",
            report_name if report_name else "",
            file_path if file_path else "",
        )

    @enforce_parameter_types
    def output_named_report_as_masta_report(
        self: "Self", report_name: "str", file_path: "str"
    ) -> None:
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        pythonnet_method_call(
            self.wrapped,
            "OutputNamedReportAsMastaReport",
            report_name if report_name else "",
            file_path if file_path else "",
        )

    @enforce_parameter_types
    def output_named_report_as_text_to(
        self: "Self", report_name: "str", file_path: "str"
    ) -> None:
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        pythonnet_method_call(
            self.wrapped,
            "OutputNamedReportAsTextTo",
            report_name if report_name else "",
            file_path if file_path else "",
        )

    @enforce_parameter_types
    def get_named_report_with_encoded_images(self: "Self", report_name: "str") -> "str":
        """str

        Args:
            report_name (str)
        """
        report_name = str(report_name)
        method_result = pythonnet_method_call(
            self.wrapped,
            "GetNamedReportWithEncodedImages",
            report_name if report_name else "",
        )
        return method_result

    @property
    def cast_to(self: "Self") -> "_Cast_CoreLossCoefficients":
        """Cast to another type.

        Returns:
            _Cast_CoreLossCoefficients
        """
        return _Cast_CoreLossCoefficients(self)
