"""AGMAGleasonConicalAccuracyGrades"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal import constructor, utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.implicit import overridable
from mastapy._private._internal.overridable_constructor import _unpack_overridable
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_property_get,
    pythonnet_property_set,
)
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private.gears import _326

_AGMA_GLEASON_CONICAL_ACCURACY_GRADES = python_net_import(
    "SMT.MastaAPI.Gears.GearDesigns.AGMAGleasonConical",
    "AGMAGleasonConicalAccuracyGrades",
)

if TYPE_CHECKING:
    from typing import Any, Tuple, Type, TypeVar, Union

    Self = TypeVar("Self", bound="AGMAGleasonConicalAccuracyGrades")
    CastSelf = TypeVar(
        "CastSelf",
        bound="AGMAGleasonConicalAccuracyGrades._Cast_AGMAGleasonConicalAccuracyGrades",
    )


__docformat__ = "restructuredtext en"
__all__ = ("AGMAGleasonConicalAccuracyGrades",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_AGMAGleasonConicalAccuracyGrades:
    """Special nested class for casting AGMAGleasonConicalAccuracyGrades to subclasses."""

    __parent__: "AGMAGleasonConicalAccuracyGrades"

    @property
    def accuracy_grades(self: "CastSelf") -> "_326.AccuracyGrades":
        return self.__parent__._cast(_326.AccuracyGrades)

    @property
    def agma_gleason_conical_accuracy_grades(
        self: "CastSelf",
    ) -> "AGMAGleasonConicalAccuracyGrades":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class AGMAGleasonConicalAccuracyGrades(_326.AccuracyGrades):
    """AGMAGleasonConicalAccuracyGrades

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _AGMA_GLEASON_CONICAL_ACCURACY_GRADES

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def agma_quality_grade_new(self: "Self") -> "int":
        """int"""
        temp = pythonnet_property_get(self.wrapped, "AGMAQualityGradeNew")

        if temp is None:
            return 0

        return temp

    @agma_quality_grade_new.setter
    @enforce_parameter_types
    def agma_quality_grade_new(self: "Self", value: "int") -> None:
        pythonnet_property_set(
            self.wrapped, "AGMAQualityGradeNew", int(value) if value is not None else 0
        )

    @property
    def agma_quality_grade_old(self: "Self") -> "int":
        """int"""
        temp = pythonnet_property_get(self.wrapped, "AGMAQualityGradeOld")

        if temp is None:
            return 0

        return temp

    @agma_quality_grade_old.setter
    @enforce_parameter_types
    def agma_quality_grade_old(self: "Self", value: "int") -> None:
        pythonnet_property_set(
            self.wrapped, "AGMAQualityGradeOld", int(value) if value is not None else 0
        )

    @property
    def single_pitch_deviation(self: "Self") -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = pythonnet_property_get(self.wrapped, "SinglePitchDeviation")

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._private._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @single_pitch_deviation.setter
    @enforce_parameter_types
    def single_pitch_deviation(
        self: "Self", value: "Union[float, Tuple[float, bool]]"
    ) -> None:
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        pythonnet_property_set(self.wrapped, "SinglePitchDeviation", value)

    @property
    def cast_to(self: "Self") -> "_Cast_AGMAGleasonConicalAccuracyGrades":
        """Cast to another type.

        Returns:
            _Cast_AGMAGleasonConicalAccuracyGrades
        """
        return _Cast_AGMAGleasonConicalAccuracyGrades(self)
