"""CutterFlankSections"""

from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private._internal.python_net import python_net_import

_CUTTER_FLANK_SECTIONS = python_net_import(
    "SMT.MastaAPI.Gears.Manufacturing.Cylindrical", "CutterFlankSections"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="CutterFlankSections")
    CastSelf = TypeVar(
        "CastSelf", bound="CutterFlankSections._Cast_CutterFlankSections"
    )


__docformat__ = "restructuredtext en"
__all__ = ("CutterFlankSections",)


class CutterFlankSections(Enum):
    """CutterFlankSections

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls) -> "Type":
        return _CUTTER_FLANK_SECTIONS

    BOTTOM_LANDTOPPING = 0
    SEMITOPPING = 1
    MAIN_PROFILE = 2
    PROTUBERANCE_BLADE = 3
    TIP_FILLET = 4
    TOP_LAND = 5


def __enum_setattr(self: "Self", attr: str, value: "Any") -> None:
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: "Self", attr: str) -> None:
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


CutterFlankSections.__setattr__ = __enum_setattr
CutterFlankSections.__delattr__ = __enum_delattr
