"""ShaftAxialBendingTorsionalComponentValues"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_property_get,
)
from mastapy._private.shafts import _18

_SHAFT_AXIAL_BENDING_TORSIONAL_COMPONENT_VALUES = python_net_import(
    "SMT.MastaAPI.Shafts", "ShaftAxialBendingTorsionalComponentValues"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="ShaftAxialBendingTorsionalComponentValues")
    CastSelf = TypeVar(
        "CastSelf",
        bound="ShaftAxialBendingTorsionalComponentValues._Cast_ShaftAxialBendingTorsionalComponentValues",
    )


__docformat__ = "restructuredtext en"
__all__ = ("ShaftAxialBendingTorsionalComponentValues",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_ShaftAxialBendingTorsionalComponentValues:
    """Special nested class for casting ShaftAxialBendingTorsionalComponentValues to subclasses."""

    __parent__: "ShaftAxialBendingTorsionalComponentValues"

    @property
    def shaft_axial_torsional_component_values(
        self: "CastSelf",
    ) -> "_18.ShaftAxialTorsionalComponentValues":
        return self.__parent__._cast(_18.ShaftAxialTorsionalComponentValues)

    @property
    def shaft_axial_bending_torsional_component_values(
        self: "CastSelf",
    ) -> "ShaftAxialBendingTorsionalComponentValues":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class ShaftAxialBendingTorsionalComponentValues(_18.ShaftAxialTorsionalComponentValues):
    """ShaftAxialBendingTorsionalComponentValues

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _SHAFT_AXIAL_BENDING_TORSIONAL_COMPONENT_VALUES

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def bending(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Bending")

        if temp is None:
            return 0.0

        return temp

    @property
    def cast_to(self: "Self") -> "_Cast_ShaftAxialBendingTorsionalComponentValues":
        """Cast to another type.

        Returns:
            _Cast_ShaftAxialBendingTorsionalComponentValues
        """
        return _Cast_ShaftAxialBendingTorsionalComponentValues(self)
