"""SocketConnectionSelection"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private import _0
from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_method_call,
    pythonnet_property_get,
)

_SOCKET_CONNECTION_SELECTION = python_net_import(
    "SMT.MastaAPI.SystemModel.ConnectionsAndSockets", "SocketConnectionSelection"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="SocketConnectionSelection")
    CastSelf = TypeVar(
        "CastSelf", bound="SocketConnectionSelection._Cast_SocketConnectionSelection"
    )


__docformat__ = "restructuredtext en"
__all__ = ("SocketConnectionSelection",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_SocketConnectionSelection:
    """Special nested class for casting SocketConnectionSelection to subclasses."""

    __parent__: "SocketConnectionSelection"

    @property
    def socket_connection_selection(self: "CastSelf") -> "SocketConnectionSelection":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class SocketConnectionSelection(_0.APIBase):
    """SocketConnectionSelection

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _SOCKET_CONNECTION_SELECTION

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def name(self: "Self") -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Name")

        if temp is None:
            return ""

        return temp

    def select(self: "Self") -> None:
        """Method does not return."""
        pythonnet_method_call(self.wrapped, "Select")

    @property
    def cast_to(self: "Self") -> "_Cast_SocketConnectionSelection":
        """Cast to another type.

        Returns:
            _Cast_SocketConnectionSelection
        """
        return _Cast_SocketConnectionSelection(self)
