"""NamedTuple3"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar, Generic, TypeVar

from mastapy._private import _0
from mastapy._private._internal import constructor, utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_property_get,
)

_NAMED_TUPLE_3 = python_net_import("SMT.MastaAPI.Utility.Generics", "NamedTuple3")

if TYPE_CHECKING:
    from typing import Any, Type

    Self = TypeVar("Self", bound="NamedTuple3")
    CastSelf = TypeVar("CastSelf", bound="NamedTuple3._Cast_NamedTuple3")

T1 = TypeVar("T1")
T2 = TypeVar("T2")
T3 = TypeVar("T3")

__docformat__ = "restructuredtext en"
__all__ = ("NamedTuple3",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_NamedTuple3:
    """Special nested class for casting NamedTuple3 to subclasses."""

    __parent__: "NamedTuple3"

    @property
    def named_tuple_3(self: "CastSelf") -> "NamedTuple3":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class NamedTuple3(_0.APIBase, Generic[T1, T2, T3]):
    """NamedTuple3

    This is a mastapy class.

    Generic Types:
        T1
        T2
        T3
    """

    TYPE: ClassVar["Type"] = _NAMED_TUPLE_3

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def item_1(self: "Self") -> "T1":
        """T1

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Item1")

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def item_2(self: "Self") -> "T2":
        """T2

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Item2")

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def item_3(self: "Self") -> "T3":
        """T3

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Item3")

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def name(self: "Self") -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Name")

        if temp is None:
            return ""

        return temp

    @property
    def cast_to(self: "Self") -> "_Cast_NamedTuple3":
        """Cast to another type.

        Returns:
            _Cast_NamedTuple3
        """
        return _Cast_NamedTuple3(self)
