"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .approvalrequestdecision import (
    ApprovalRequestDecision,
    ApprovalRequestDecisionTypedDict,
)
from .approvalrequestuser import ApprovalRequestUser, ApprovalRequestUserTypedDict
from .approvalticketdetails import ApprovalTicketDetails, ApprovalTicketDetailsTypedDict
from datetime import datetime
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class ApprovalRequestObjectApprovalRequestTypedDict(TypedDict):
    assignee_user: NotRequired[ApprovalRequestUserTypedDict]
    created_at: NotRequired[datetime]
    r"""The time the approval request was created"""
    created_by_user: NotRequired[ApprovalRequestUserTypedDict]
    decided_at: NotRequired[Nullable[datetime]]
    r"""The time at which the approver submitted a decision about the request."""
    decisions: NotRequired[List[ApprovalRequestDecisionTypedDict]]
    r"""List of decisions for the approval request"""
    id: NotRequired[str]
    r"""Unique identifier for the approval request"""
    message: NotRequired[str]
    r"""Details for the approval request"""
    status: NotRequired[str]
    r"""Current status of the approval request"""
    subject: NotRequired[str]
    r"""Subject for the approval request"""
    ticket_details: NotRequired[ApprovalTicketDetailsTypedDict]
    withdrawn_reason: NotRequired[Nullable[str]]
    r"""Reason for withdrawing the approval request"""


class ApprovalRequestObjectApprovalRequest(BaseModel):
    assignee_user: Optional[ApprovalRequestUser] = None

    created_at: Optional[datetime] = None
    r"""The time the approval request was created"""

    created_by_user: Optional[ApprovalRequestUser] = None

    decided_at: OptionalNullable[datetime] = UNSET
    r"""The time at which the approver submitted a decision about the request."""

    decisions: Optional[List[ApprovalRequestDecision]] = None
    r"""List of decisions for the approval request"""

    id: Optional[str] = None
    r"""Unique identifier for the approval request"""

    message: Optional[str] = None
    r"""Details for the approval request"""

    status: Optional[str] = None
    r"""Current status of the approval request"""

    subject: Optional[str] = None
    r"""Subject for the approval request"""

    ticket_details: Optional[ApprovalTicketDetails] = None

    withdrawn_reason: OptionalNullable[str] = UNSET
    r"""Reason for withdrawing the approval request"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "assignee_user",
            "created_at",
            "created_by_user",
            "decided_at",
            "decisions",
            "id",
            "message",
            "status",
            "subject",
            "ticket_details",
            "withdrawn_reason",
        ]
        nullable_fields = ["decided_at", "withdrawn_reason"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ApprovalRequestObjectTypedDict(TypedDict):
    approval_request: NotRequired[ApprovalRequestObjectApprovalRequestTypedDict]


class ApprovalRequestObject(BaseModel):
    approval_request: Optional[ApprovalRequestObjectApprovalRequest] = None
