"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class ApprovalRequestsSearchResponseApprovalRequestTypedDict(TypedDict):
    approval_workflow_instance_id: NotRequired[str]
    r"""Unique identifier for the approval workflow instance. See [Approval Workflow Instances](/api-reference/ticketing/approvals/approval_workflow_instances/#approval-workflow-instances)"""
    created_at: NotRequired[datetime]
    r"""The time the approval request was created was created"""
    created_by_name: NotRequired[str]
    r"""Name of the user that created the approval request"""
    id: NotRequired[str]
    r"""Unique identifier for the approval request"""
    message: NotRequired[str]
    r"""Details for the approval request"""
    requester_name: NotRequired[str]
    r"""Name of the user that can make a decision on the approval request"""
    status: NotRequired[str]
    r"""Current status of the approval request"""
    subject: NotRequired[str]
    r"""Subject for the approval request"""


class ApprovalRequestsSearchResponseApprovalRequest(BaseModel):
    approval_workflow_instance_id: Optional[str] = None
    r"""Unique identifier for the approval workflow instance. See [Approval Workflow Instances](/api-reference/ticketing/approvals/approval_workflow_instances/#approval-workflow-instances)"""

    created_at: Optional[datetime] = None
    r"""The time the approval request was created was created"""

    created_by_name: Optional[str] = None
    r"""Name of the user that created the approval request"""

    id: Optional[str] = None
    r"""Unique identifier for the approval request"""

    message: Optional[str] = None
    r"""Details for the approval request"""

    requester_name: Optional[str] = None
    r"""Name of the user that can make a decision on the approval request"""

    status: Optional[str] = None
    r"""Current status of the approval request"""

    subject: Optional[str] = None
    r"""Subject for the approval request"""


class ApprovalRequestsSearchResponseTypedDict(TypedDict):
    after_cursor: NotRequired[Nullable[str]]
    r"""Cursor for the next page of results"""
    after_url: NotRequired[Nullable[str]]
    r"""URL for the next page of results"""
    approval_requests: NotRequired[
        List[ApprovalRequestsSearchResponseApprovalRequestTypedDict]
    ]
    before_cursor: NotRequired[Nullable[str]]
    r"""Cursor for the previous page of results"""
    before_url: NotRequired[Nullable[str]]
    r"""URL for the previous page of results"""


class ApprovalRequestsSearchResponse(BaseModel):
    after_cursor: OptionalNullable[str] = UNSET
    r"""Cursor for the next page of results"""

    after_url: OptionalNullable[str] = UNSET
    r"""URL for the next page of results"""

    approval_requests: Optional[List[ApprovalRequestsSearchResponseApprovalRequest]] = (
        None
    )

    before_cursor: OptionalNullable[str] = UNSET
    r"""Cursor for the previous page of results"""

    before_url: OptionalNullable[str] = UNSET
    r"""URL for the previous page of results"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "after_cursor",
            "after_url",
            "approval_requests",
            "before_cursor",
            "before_url",
        ]
        nullable_fields = ["after_cursor", "after_url", "before_cursor", "before_url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
