"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attachmentobject_input import (
    AttachmentObjectInput,
    AttachmentObjectInputTypedDict,
)
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class BrandObjectInputTypedDict(TypedDict):
    name: str
    r"""The name of the brand"""
    subdomain: str
    r"""The subdomain of the brand"""
    active: NotRequired[bool]
    r"""If the brand is set as active"""
    brand_url: NotRequired[str]
    r"""The url of the brand"""
    default: NotRequired[bool]
    r"""Is the brand the default brand for this account"""
    has_help_center: NotRequired[bool]
    r"""If the brand has a Help Center"""
    host_mapping: NotRequired[str]
    r"""The hostmapping to this brand, if any. Only admins view this property."""
    is_deleted: NotRequired[bool]
    r"""If the brand object is deleted or not"""
    logo: NotRequired[AttachmentObjectInputTypedDict]
    r"""A file represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object"""
    signature_template: NotRequired[str]
    r"""The signature template for a brand"""


class BrandObjectInput(BaseModel):
    name: str
    r"""The name of the brand"""

    subdomain: str
    r"""The subdomain of the brand"""

    active: Optional[bool] = None
    r"""If the brand is set as active"""

    brand_url: Optional[str] = None
    r"""The url of the brand"""

    default: Optional[bool] = None
    r"""Is the brand the default brand for this account"""

    has_help_center: Optional[bool] = None
    r"""If the brand has a Help Center"""

    host_mapping: Optional[str] = None
    r"""The hostmapping to this brand, if any. Only admins view this property."""

    is_deleted: Optional[bool] = None
    r"""If the brand object is deleted or not"""

    logo: Optional[AttachmentObjectInput] = None
    r"""A file represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object"""

    signature_template: Optional[str] = None
    r"""The signature template for a brand"""
