"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata


CreateUserIdentityType = Literal[
    "email",
    "facebook",
    "phone_number",
    "sdk",
    "twitter",
    "messaging",
    "microsoft",
]
r"""Filters results by one or more identity types using the format `?type[]={type}&type[]={type}`"""


class CreateUserIdentityRequestTypedDict(TypedDict):
    user_id: int
    r"""The id of the user"""
    type: NotRequired[CreateUserIdentityType]
    r"""Filters results by one or more identity types using the format `?type[]={type}&type[]={type}`"""


class CreateUserIdentityRequest(BaseModel):
    user_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The id of the user"""

    type: Annotated[
        Optional[CreateUserIdentityType],
        pydantic.Field(alias="type[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters results by one or more identity types using the format `?type[]={type}&type[]={type}`"""
