"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from typing import Literal, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


CustomStatusObjectStatusCategory = Literal[
    "new",
    "open",
    "pending",
    "hold",
    "solved",
]
r"""The status category the custom ticket status belongs to"""


class CustomStatusObjectTypedDict(TypedDict):
    agent_label: str
    r"""The label displayed to agents. Maximum length is 48 characters"""
    status_category: CustomStatusObjectStatusCategory
    r"""The status category the custom ticket status belongs to"""
    active: NotRequired[bool]
    r"""If true, the custom status is set to active, If false, the custom status is set to inactive"""
    created_at: NotRequired[datetime]
    r"""The date and time the custom ticket status was created"""
    default: NotRequired[bool]
    r"""If true, the custom status is set to default. If false, the custom status is set to non-default"""
    description: NotRequired[str]
    r"""The description of when the user should select this custom ticket status"""
    end_user_description: NotRequired[str]
    r"""The description displayed to end users"""
    end_user_label: NotRequired[str]
    r"""The label displayed to end users. Maximum length is 48 characters"""
    id: NotRequired[int]
    r"""Automatically assigned when the custom ticket status is created"""
    raw_agent_label: NotRequired[str]
    r"""The dynamic content placeholder. If the dynamic content placeholder is not available, this is the \"agent_label\" value. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    raw_description: NotRequired[str]
    r"""The dynamic content placeholder. If the dynamic content placeholder is not available, this is the \"description\" value. [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    raw_end_user_description: NotRequired[str]
    r"""The dynamic content placeholder. If the dynamic content placeholder is not available, this is the \"end_user_description\" value. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    raw_end_user_label: NotRequired[str]
    r"""The dynamic content placeholder. If the dynamic content placeholder is not available, this is the \"end_user_label\" value. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    updated_at: NotRequired[datetime]
    r"""The date and time the custom ticket status was last updated"""


class CustomStatusObject(BaseModel):
    agent_label: str
    r"""The label displayed to agents. Maximum length is 48 characters"""

    status_category: CustomStatusObjectStatusCategory
    r"""The status category the custom ticket status belongs to"""

    active: Optional[bool] = None
    r"""If true, the custom status is set to active, If false, the custom status is set to inactive"""

    created_at: Optional[datetime] = None
    r"""The date and time the custom ticket status was created"""

    default: Optional[bool] = None
    r"""If true, the custom status is set to default. If false, the custom status is set to non-default"""

    description: Optional[str] = None
    r"""The description of when the user should select this custom ticket status"""

    end_user_description: Optional[str] = None
    r"""The description displayed to end users"""

    end_user_label: Optional[str] = None
    r"""The label displayed to end users. Maximum length is 48 characters"""

    id: Optional[int] = None
    r"""Automatically assigned when the custom ticket status is created"""

    raw_agent_label: Optional[str] = None
    r"""The dynamic content placeholder. If the dynamic content placeholder is not available, this is the \"agent_label\" value. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    raw_description: Optional[str] = None
    r"""The dynamic content placeholder. If the dynamic content placeholder is not available, this is the \"description\" value. [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    raw_end_user_description: Optional[str] = None
    r"""The dynamic content placeholder. If the dynamic content placeholder is not available, this is the \"end_user_description\" value. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    raw_end_user_label: Optional[str] = None
    r"""The dynamic content placeholder. If the dynamic content placeholder is not available, this is the \"end_user_label\" value. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    updated_at: Optional[datetime] = None
    r"""The date and time the custom ticket status was last updated"""
