"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class EssentialsCardObjectTypedDict(TypedDict):
    fields: List[Dict[str, Any]]
    r"""Fields that are displayed in the essentials card details. The order is defined by the order of the fields in the array"""
    created_at: NotRequired[datetime]
    r"""Date and time the essentials card were created"""
    default: NotRequired[bool]
    r"""If true, the system has used the first twenty fields for the custom object type as the essentials card."""
    id: NotRequired[Nullable[str]]
    r"""id of the essentials card

    """
    key: NotRequired[str]
    r"""Object type. Example: `zen:user` refers to `User` type

    """
    layout: NotRequired[str]
    r"""layout type

    """
    max_count: NotRequired[int]
    r"""Maximum number of fields allowed in the essentials card"""
    updated_at: NotRequired[datetime]
    r"""Date and time the essentials card were last updated"""


class EssentialsCardObject(BaseModel):
    fields: List[Dict[str, Any]]
    r"""Fields that are displayed in the essentials card details. The order is defined by the order of the fields in the array"""

    created_at: Optional[datetime] = None
    r"""Date and time the essentials card were created"""

    default: Optional[bool] = None
    r"""If true, the system has used the first twenty fields for the custom object type as the essentials card."""

    id: OptionalNullable[str] = UNSET
    r"""id of the essentials card

    """

    key: Optional[str] = None
    r"""Object type. Example: `zen:user` refers to `User` type

    """

    layout: Optional[str] = None
    r"""layout type

    """

    max_count: Optional[int] = None
    r"""Maximum number of fields allowed in the essentials card"""

    updated_at: Optional[datetime] = None
    r"""Date and time the essentials card were last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "created_at",
            "default",
            "id",
            "key",
            "layout",
            "max_count",
            "updated_at",
        ]
        nullable_fields = ["id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
