"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .auditlogsresponse import AuditLogsResponse, AuditLogsResponseTypedDict
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class ListAuditLogsRequestTypedDict(TypedDict):
    page_before: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_after: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_size: NotRequired[int]
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """
    filter_source_type: NotRequired[str]
    r"""Filter audit logs by the source type. For example, user or rule"""
    filter_source_id: NotRequired[int]
    r"""Filter audit logs by the source id. Requires `filter[source_type]` to also be set"""
    filter_actor_id: NotRequired[int]
    r"""Filter audit logs by the actor id"""
    filter_ip_address: NotRequired[str]
    r"""Filter audit logs by the ip address"""
    filter_created_at: NotRequired[str]
    r"""Filter audit logs by the time of creation. When used, you must specify `filter[created_at]` twice in your request, first with the start time and again with an end time"""
    filter_action: NotRequired[str]
    r"""Filter audit logs by the action"""
    sort: NotRequired[str]
    r"""Cursor pagination only. Sort audit logs. Default is `sort=-created_at`"""


class ListAuditLogsRequest(BaseModel):
    page_before: Annotated[
        Optional[str],
        pydantic.Field(alias="page[before]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """

    filter_source_type: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[source_type]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter audit logs by the source type. For example, user or rule"""

    filter_source_id: Annotated[
        Optional[int],
        pydantic.Field(alias="filter[source_id]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter audit logs by the source id. Requires `filter[source_type]` to also be set"""

    filter_actor_id: Annotated[
        Optional[int],
        pydantic.Field(alias="filter[actor_id]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter audit logs by the actor id"""

    filter_ip_address: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[ip_address]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter audit logs by the ip address"""

    filter_created_at: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[created_at]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter audit logs by the time of creation. When used, you must specify `filter[created_at]` twice in your request, first with the start time and again with an end time"""

    filter_action: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[action]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter audit logs by the action"""

    sort: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Cursor pagination only. Sort audit logs. Default is `sort=-created_at`"""


class ListAuditLogsResponseTypedDict(TypedDict):
    result: AuditLogsResponseTypedDict


class ListAuditLogsResponse(BaseModel):
    next: Callable[[], Optional[ListAuditLogsResponse]]

    result: AuditLogsResponse
