"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ticketcommentsresponse import (
    TicketCommentsResponse,
    TicketCommentsResponseTypedDict,
)
import pydantic
from typing import Callable, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata


ListCommentsSort = Literal[
    "created_at",
    "-created_at",
]
r"""Specifies how to sort the comments. Possible values are \"created_at\" (ascending order) or \"-created_at\" (descending order)

"""


class ListCommentsRequestTypedDict(TypedDict):
    request_id: int
    r"""The ID of the request"""
    page_before: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_after: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_size: NotRequired[int]
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """
    sort: NotRequired[ListCommentsSort]
    r"""Specifies how to sort the comments. Possible values are \"created_at\" (ascending order) or \"-created_at\" (descending order)

    """
    since: NotRequired[str]
    r"""Filters the comments from the given datetime"""
    role: NotRequired[str]
    r"""One of \"agent\", \"end_user\". If not specified it does not filter"""


class ListCommentsRequest(BaseModel):
    request_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the request"""

    page_before: Annotated[
        Optional[str],
        pydantic.Field(alias="page[before]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """

    sort: Annotated[
        Optional[ListCommentsSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Specifies how to sort the comments. Possible values are \"created_at\" (ascending order) or \"-created_at\" (descending order)

    """

    since: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters the comments from the given datetime"""

    role: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""One of \"agent\", \"end_user\". If not specified it does not filter"""


class ListCommentsResponseTypedDict(TypedDict):
    result: TicketCommentsResponseTypedDict


class ListCommentsResponse(BaseModel):
    next: Callable[[], Optional[ListCommentsResponse]]

    result: TicketCommentsResponse
