"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .searchresponse import SearchResponse, SearchResponseTypedDict
from typing import Callable, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


SortBy = Literal[
    "updated_at",
    "created_at",
    "priority",
    "status",
    "ticket_type",
]
r"""One of `updated_at`, `created_at`, `priority`, `status`, or `ticket_type`. Defaults to sorting by relevance"""


SortOrder = Literal[
    "asc",
    "desc",
]
r"""One of `asc` or `desc`.  Defaults to `desc`"""


class ListSearchResultsRequestTypedDict(TypedDict):
    query: str
    r"""The search query. See [Query basics](#query-basics) above. For details on the query syntax, see the [Zendesk Support search reference](https://support.zendesk.com/hc/en-us/articles/203663226)"""
    sort_by: NotRequired[SortBy]
    r"""One of `updated_at`, `created_at`, `priority`, `status`, or `ticket_type`. Defaults to sorting by relevance"""
    sort_order: NotRequired[SortOrder]
    r"""One of `asc` or `desc`.  Defaults to `desc`"""
    page: NotRequired[int]
    r"""Page number for offset pagination"""
    per_page: NotRequired[int]
    r"""Number of items per page"""


class ListSearchResultsRequest(BaseModel):
    query: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The search query. See [Query basics](#query-basics) above. For details on the query syntax, see the [Zendesk Support search reference](https://support.zendesk.com/hc/en-us/articles/203663226)"""

    sort_by: Annotated[
        Optional[SortBy],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""One of `updated_at`, `created_at`, `priority`, `status`, or `ticket_type`. Defaults to sorting by relevance"""

    sort_order: Annotated[
        Optional[SortOrder],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""One of `asc` or `desc`.  Defaults to `desc`"""

    page: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number for offset pagination"""

    per_page: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Number of items per page"""


class ListSearchResultsResponseTypedDict(TypedDict):
    result: SearchResponseTypedDict


class ListSearchResultsResponse(BaseModel):
    next: Callable[[], Optional[ListSearchResultsResponse]]

    result: SearchResponse
