"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ticketfieldsresponse import TicketFieldsResponse, TicketFieldsResponseTypedDict
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class ListTicketFieldsRequestTypedDict(TypedDict):
    locale: NotRequired[str]
    r"""Forces the `title_in_portal` property to return a dynamic content variant for the specified locale.
    Only accepts [active locale ids](/api-reference/ticketing/account-configuration/locales/#list-locales).
    Example: `locale=\"de\"`.

    """
    creator: NotRequired[bool]
    r"""Displays the `creator_user_id` and `creator_app_name` properties. If the ticket field is created
    by an app, `creator_app_name` is the name of the app and `creator_user_id` is `-1`. If the ticket field
    is not created by an app, `creator_app_name` is null

    """
    page_size: NotRequired[int]
    r"""Number of records per page (required for cursor pagination)"""
    page_after: NotRequired[str]
    r"""Cursor for pagination (opaque string)"""


class ListTicketFieldsRequest(BaseModel):
    locale: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Forces the `title_in_portal` property to return a dynamic content variant for the specified locale.
    Only accepts [active locale ids](/api-reference/ticketing/account-configuration/locales/#list-locales).
    Example: `locale=\"de\"`.

    """

    creator: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Displays the `creator_user_id` and `creator_app_name` properties. If the ticket field is created
    by an app, `creator_app_name` is the name of the app and `creator_user_id` is `-1`. If the ticket field
    is not created by an app, `creator_app_name` is null

    """

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Number of records per page (required for cursor pagination)"""

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Cursor for pagination (opaque string)"""


class ListTicketFieldsResponseTypedDict(TypedDict):
    result: TicketFieldsResponseTypedDict


class ListTicketFieldsResponse(BaseModel):
    next: Callable[[], Optional[ListTicketFieldsResponse]]

    result: TicketFieldsResponse
