"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .triggeractionobject import TriggerActionObject, TriggerActionObjectTypedDict
from .triggerconditionsobject import (
    TriggerConditionsObject,
    TriggerConditionsObjectTypedDict,
)
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class ObjectTriggerObjectInputTypedDict(TypedDict):
    actions: List[TriggerActionObjectTypedDict]
    r"""An array of actions the trigger does when its conditions are met. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)"""
    conditions: TriggerConditionsObjectTypedDict
    r"""An object that describes the circumstances under which the trigger performs its actions. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""
    title: str
    r"""The title of the trigger"""
    active: NotRequired[bool]
    r"""Whether the trigger is active"""
    description: NotRequired[str]
    r"""The description of the trigger"""
    position: NotRequired[int]
    r"""Position of the trigger, determines the order they will execute in"""
    raw_title: NotRequired[str]
    r"""The raw format of the title of the trigger"""


class ObjectTriggerObjectInput(BaseModel):
    actions: List[TriggerActionObject]
    r"""An array of actions the trigger does when its conditions are met. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)"""

    conditions: TriggerConditionsObject
    r"""An object that describes the circumstances under which the trigger performs its actions. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""

    title: str
    r"""The title of the trigger"""

    active: Optional[bool] = None
    r"""Whether the trigger is active"""

    description: Optional[str] = None
    r"""The description of the trigger"""

    position: Optional[int] = None
    r"""Position of the trigger, determines the order they will execute in"""

    raw_title: Optional[str] = None
    r"""The raw format of the title of the trigger"""
