"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, UNSET_SENTINEL


class OrganizationMembershipObjectTypedDict(TypedDict):
    default: Nullable[bool]
    r"""Denotes whether this is the default organization membership for the user. If false, returns `null`"""
    organization_id: int
    r"""The ID of the organization associated with this user, in this membership"""
    user_id: int
    r"""The ID of the user for whom this memberships belongs"""
    created_at: NotRequired[datetime]
    r"""When this record was created"""
    id: NotRequired[int]
    r"""Automatically assigned when the membership is created"""
    organization_name: NotRequired[str]
    r"""The name of the organization associated with this user, in this membership"""
    updated_at: NotRequired[datetime]
    r"""When this record last got updated"""
    url: NotRequired[str]
    r"""The API url of this membership"""
    view_tickets: NotRequired[bool]
    r"""Denotes whether the user can or cannot have access to all organization's tickets."""


class OrganizationMembershipObject(BaseModel):
    default: Nullable[bool]
    r"""Denotes whether this is the default organization membership for the user. If false, returns `null`"""

    organization_id: int
    r"""The ID of the organization associated with this user, in this membership"""

    user_id: int
    r"""The ID of the user for whom this memberships belongs"""

    created_at: Optional[datetime] = None
    r"""When this record was created"""

    id: Optional[int] = None
    r"""Automatically assigned when the membership is created"""

    organization_name: Optional[str] = None
    r"""The name of the organization associated with this user, in this membership"""

    updated_at: Optional[datetime] = None
    r"""When this record last got updated"""

    url: Optional[str] = None
    r"""The API url of this membership"""

    view_tickets: Optional[bool] = None
    r"""Denotes whether the user can or cannot have access to all organization's tickets."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "created_at",
            "id",
            "organization_name",
            "updated_at",
            "url",
            "view_tickets",
        ]
        nullable_fields = ["default"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
