"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from typing import Dict, List, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


OrganizationFieldsTypedDict = TypeAliasType(
    "OrganizationFieldsTypedDict", Union[str, float]
)


OrganizationFields = TypeAliasType("OrganizationFields", Union[str, float])


class OrganizationObjectTypedDict(TypedDict):
    name: str
    r"""A unique name for the organization"""
    created_at: NotRequired[str]
    r"""The time the organization was created"""
    details: NotRequired[Nullable[str]]
    r"""Any details obout the organization, such as the address"""
    domain_names: NotRequired[List[str]]
    r"""An array of domain names associated with this organization"""
    external_id: NotRequired[Nullable[str]]
    r"""A unique external id to associate organizations to an external record. The id is case-insensitive. For example, \"company1\" and \"Company1\" are considered the same"""
    group_id: NotRequired[Nullable[int]]
    r"""New tickets from users in this organization are automatically put in this group"""
    id: NotRequired[int]
    r"""Automatically assigned when the organization is created"""
    notes: NotRequired[Nullable[str]]
    r"""Any notes you have about the organization"""
    organization_fields: NotRequired[Nullable[Dict[str, OrganizationFieldsTypedDict]]]
    r"""Custom fields for this organization. See [Custom organization fields](/api-reference/ticketing/organizations/organizations/#custom-organization-fields)"""
    shared_comments: NotRequired[bool]
    r"""End users in this organization are able to comment on each other's tickets"""
    shared_tickets: NotRequired[bool]
    r"""End users in this organization are able to see each other's tickets"""
    tags: NotRequired[List[str]]
    r"""The tags of the organization"""
    updated_at: NotRequired[str]
    r"""The time of the last update of the organization"""
    url: NotRequired[str]
    r"""The API url of this organization"""


class OrganizationObject(BaseModel):
    name: str
    r"""A unique name for the organization"""

    created_at: Optional[str] = None
    r"""The time the organization was created"""

    details: OptionalNullable[str] = UNSET
    r"""Any details obout the organization, such as the address"""

    domain_names: Optional[List[str]] = None
    r"""An array of domain names associated with this organization"""

    external_id: OptionalNullable[str] = UNSET
    r"""A unique external id to associate organizations to an external record. The id is case-insensitive. For example, \"company1\" and \"Company1\" are considered the same"""

    group_id: OptionalNullable[int] = UNSET
    r"""New tickets from users in this organization are automatically put in this group"""

    id: Optional[int] = None
    r"""Automatically assigned when the organization is created"""

    notes: OptionalNullable[str] = UNSET
    r"""Any notes you have about the organization"""

    organization_fields: OptionalNullable[Dict[str, OrganizationFields]] = UNSET
    r"""Custom fields for this organization. See [Custom organization fields](/api-reference/ticketing/organizations/organizations/#custom-organization-fields)"""

    shared_comments: Optional[bool] = None
    r"""End users in this organization are able to comment on each other's tickets"""

    shared_tickets: Optional[bool] = None
    r"""End users in this organization are able to see each other's tickets"""

    tags: Optional[List[str]] = None
    r"""The tags of the organization"""

    updated_at: Optional[str] = None
    r"""The time of the last update of the organization"""

    url: Optional[str] = None
    r"""The API url of this organization"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "created_at",
            "details",
            "domain_names",
            "external_id",
            "group_id",
            "id",
            "notes",
            "organization_fields",
            "shared_comments",
            "shared_tickets",
            "tags",
            "updated_at",
            "url",
        ]
        nullable_fields = [
            "details",
            "external_id",
            "group_id",
            "notes",
            "organization_fields",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class OrganizationObjectInputTypedDict(TypedDict):
    name: str
    r"""A unique name for the organization"""
    details: NotRequired[Nullable[str]]
    r"""Any details obout the organization, such as the address"""
    domain_names: NotRequired[List[str]]
    r"""An array of domain names associated with this organization"""
    external_id: NotRequired[Nullable[str]]
    r"""A unique external id to associate organizations to an external record. The id is case-insensitive. For example, \"company1\" and \"Company1\" are considered the same"""
    group_id: NotRequired[Nullable[int]]
    r"""New tickets from users in this organization are automatically put in this group"""
    id: NotRequired[int]
    r"""Automatically assigned when the organization is created"""
    notes: NotRequired[Nullable[str]]
    r"""Any notes you have about the organization"""
    organization_fields: NotRequired[Nullable[Dict[str, OrganizationFieldsTypedDict]]]
    r"""Custom fields for this organization. See [Custom organization fields](/api-reference/ticketing/organizations/organizations/#custom-organization-fields)"""
    shared_comments: NotRequired[bool]
    r"""End users in this organization are able to comment on each other's tickets"""
    shared_tickets: NotRequired[bool]
    r"""End users in this organization are able to see each other's tickets"""
    tags: NotRequired[List[str]]
    r"""The tags of the organization"""


class OrganizationObjectInput(BaseModel):
    name: str
    r"""A unique name for the organization"""

    details: OptionalNullable[str] = UNSET
    r"""Any details obout the organization, such as the address"""

    domain_names: Optional[List[str]] = None
    r"""An array of domain names associated with this organization"""

    external_id: OptionalNullable[str] = UNSET
    r"""A unique external id to associate organizations to an external record. The id is case-insensitive. For example, \"company1\" and \"Company1\" are considered the same"""

    group_id: OptionalNullable[int] = UNSET
    r"""New tickets from users in this organization are automatically put in this group"""

    id: Optional[int] = None
    r"""Automatically assigned when the organization is created"""

    notes: OptionalNullable[str] = UNSET
    r"""Any notes you have about the organization"""

    organization_fields: OptionalNullable[Dict[str, OrganizationFields]] = UNSET
    r"""Custom fields for this organization. See [Custom organization fields](/api-reference/ticketing/organizations/organizations/#custom-organization-fields)"""

    shared_comments: Optional[bool] = None
    r"""End users in this organization are able to comment on each other's tickets"""

    shared_tickets: Optional[bool] = None
    r"""End users in this organization are able to see each other's tickets"""

    tags: Optional[List[str]] = None
    r"""The tags of the organization"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "details",
            "domain_names",
            "external_id",
            "group_id",
            "id",
            "notes",
            "organization_fields",
            "shared_comments",
            "shared_tickets",
            "tags",
        ]
        nullable_fields = [
            "details",
            "external_id",
            "group_id",
            "notes",
            "organization_fields",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
