"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class SatisfactionRatingObjectTypedDict(TypedDict):
    assignee_id: int
    r"""The id of agent assigned to at the time of rating"""
    group_id: int
    r"""The id of group assigned to at the time of rating"""
    requester_id: int
    r"""The id of ticket requester submitting the rating"""
    score: str
    r"""The rating \"offered\", \"unoffered\", \"good\" or \"bad\" """
    ticket_id: int
    r"""The id of ticket being rated"""
    comment: NotRequired[str]
    r"""The comment received with this rating, if available"""
    created_at: NotRequired[datetime]
    r"""The time the satisfaction rating got created"""
    id: NotRequired[int]
    r"""Automatically assigned upon creation"""
    reason: NotRequired[str]
    r"""The reason for a bad rating given by the requester in a follow-up question. Satisfaction reasons must be [enabled](https://support.zendesk.com/hc/en-us/articles/223152967)"""
    reason_code: NotRequired[int]
    r"""The default reasons the user can select from a list menu for giving a negative rating. See [Reason codes](/api-reference/ticketing/ticket-management/satisfaction_reasons/#reason-codes) in the Satisfaction Reasons API. Can only be set on ratings with a `score` of \"bad\". Responses don't include this property"""
    reason_id: NotRequired[int]
    r"""id for the reason the user gave a negative rating. Can only be set on ratings with a `score` of \"bad\". To get a descriptive value for the id, use the [Show Reason for Satisfaction Rating](/api-reference/ticketing/ticket-management/satisfaction_reasons/#show-reason-for-satisfaction-rating) endpoint"""
    updated_at: NotRequired[datetime]
    r"""The time the satisfaction rating got updated"""
    url: NotRequired[str]
    r"""The API url of this rating"""


class SatisfactionRatingObject(BaseModel):
    assignee_id: int
    r"""The id of agent assigned to at the time of rating"""

    group_id: int
    r"""The id of group assigned to at the time of rating"""

    requester_id: int
    r"""The id of ticket requester submitting the rating"""

    score: str
    r"""The rating \"offered\", \"unoffered\", \"good\" or \"bad\" """

    ticket_id: int
    r"""The id of ticket being rated"""

    comment: Optional[str] = None
    r"""The comment received with this rating, if available"""

    created_at: Optional[datetime] = None
    r"""The time the satisfaction rating got created"""

    id: Optional[int] = None
    r"""Automatically assigned upon creation"""

    reason: Optional[str] = None
    r"""The reason for a bad rating given by the requester in a follow-up question. Satisfaction reasons must be [enabled](https://support.zendesk.com/hc/en-us/articles/223152967)"""

    reason_code: Optional[int] = None
    r"""The default reasons the user can select from a list menu for giving a negative rating. See [Reason codes](/api-reference/ticketing/ticket-management/satisfaction_reasons/#reason-codes) in the Satisfaction Reasons API. Can only be set on ratings with a `score` of \"bad\". Responses don't include this property"""

    reason_id: Optional[int] = None
    r"""id for the reason the user gave a negative rating. Can only be set on ratings with a `score` of \"bad\". To get a descriptive value for the id, use the [Show Reason for Satisfaction Rating](/api-reference/ticketing/ticket-management/satisfaction_reasons/#show-reason-for-satisfaction-rating) endpoint"""

    updated_at: Optional[datetime] = None
    r"""The time the satisfaction rating got updated"""

    url: Optional[str] = None
    r"""The API url of this rating"""
